/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.realm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.newjradius.exception.JRadiusException;
import net.newjradius.realm.JRadiusRealm;
import net.newjradius.realm.RadiusRealm;
import net.newjradius.realm.RealmFactory;
import net.newjradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class StaticRealms
implements RealmFactory {
    protected Map<String, JRadiusRealm> realms = new LinkedHashMap<String, JRadiusRealm>();

    @Override
    public JRadiusRealm getRealm(String realmName) throws JRadiusException {
        return this.realms.get(realmName);
    }

    @Override
    public Collection<JRadiusRealm> getRealms() throws JRadiusException {
        return this.realms.values();
    }

    @Override
    public void setConfig(XMLConfiguration config, HierarchicalConfiguration.Node root) {
        List list = root.getChildren("realm");
        for (HierarchicalConfiguration.Node node : list) {
            config.setRoot(node);
            RadiusRealm realm = new RadiusRealm();
            realm.setRealm(config.getConfigString("name"));
            realm.setServer(config.getConfigString("server"));
            realm.setSharedSecret(config.getConfigString("sharedSecret"));
            realm.setAuthPort(Integer.parseInt(config.getConfigString("authPort")));
            realm.setAcctPort(Integer.parseInt(config.getConfigString("acctPort")));
            this.realms.put(realm.getRealm(), realm);
        }
    }
}

