/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.newjradius.handler.chain.JRCommand;
import net.newjradius.server.JRadiusEvent;
import net.newjradius.server.JRadiusThread;
import net.newjradius.server.event.ServerEvent;
import net.newjradius.session.JRadiusSession;
import net.newjradius.session.JRadiusSessionManager;

public class EventDispatcher
extends JRadiusThread {
    private BlockingQueue<JRadiusEvent> eventQueue = new LinkedBlockingQueue<JRadiusEvent>();
    private List<JRCommand> eventHandlers = new LinkedList<JRCommand>();
    private volatile boolean active = false;

    public void post(JRadiusEvent event) {
        while (this.getActive()) {
            try {
                this.eventQueue.put(event);
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void run() {
        this.active = true;
        while (this.getActive()) {
            try {
                Thread.yield();
                this.dispatchEvent();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent() {
        JRadiusEvent event = null;
        while (this.getActive()) {
            try {
                event = this.eventQueue.take();
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (event != null) {
            JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager(event.getSender());
            JRadiusSession session = null;
            if (event instanceof ServerEvent) {
                session = ((ServerEvent)event).getRequest().getSession();
            }
            if (session != null) {
                sessionManager.lock(session);
            }
            try {
                for (JRCommand command : this.eventHandlers) {
                    try {
                        if (!command.doesHandle(event) || !command.execute(event)) continue;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            finally {
                if (session != null) {
                    sessionManager.unlock(session, false);
                }
            }
        }
    }

    public List<JRCommand> getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(List<JRCommand> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }
}

