/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.newjradius.handler.chain.JRCommand;
import net.newjradius.packet.attribute.AttributeDictionary;
import net.newjradius.packet.attribute.AttributeFactory;
import net.newjradius.server.EventDispatcher;
import net.newjradius.server.Listener;
import net.newjradius.server.ListenerRequest;
import net.newjradius.server.Processor;
import net.newjradius.server.config.Configuration;
import net.newjradius.server.config.DictionaryConfigurationItem;
import net.newjradius.server.config.ListenerConfigurationItem;
import net.newjradius.session.JRadiusSessionManager;
import org.springframework.beans.factory.InitializingBean;

public class JRadiusServer
implements InitializingBean {
    public static final int JRADIUS_authenticate = 1;
    public static final int JRADIUS_authorize = 2;
    public static final int JRADIUS_preacct = 3;
    public static final int JRADIUS_accounting = 4;
    public static final int JRADIUS_checksimul = 5;
    public static final int JRADIUS_pre_proxy = 6;
    public static final int JRADIUS_post_proxy = 7;
    public static final int JRADIUS_post_auth = 8;
    public static final int JRADIUS_max_request_type = 8;
    public static final int RLM_MODULE_REJECT = 0;
    public static final int RLM_MODULE_FAIL = 1;
    public static final int RLM_MODULE_OK = 2;
    public static final int RLM_MODULE_HANDLED = 3;
    public static final int RLM_MODULE_INVALID = 4;
    public static final int RLM_MODULE_USERLOCK = 5;
    public static final int RLM_MODULE_NOTFOUND = 6;
    public static final int RLM_MODULE_NOOP = 7;
    public static final int RLM_MODULE_UPDATED = 8;
    public static final int RLM_MODULE_NUMCODES = 9;
    private List<Processor> processors = new LinkedList<Processor>();
    private List<Listener> listeners = new LinkedList<Listener>();
    private EventDispatcher eventDispatcher;
    private boolean running = false;

    public JRadiusServer() throws Exception {
    }

    public JRadiusServer(EventDispatcher eventDispatcher) throws Exception {
        this();
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.eventDispatcher == null) {
            this.eventDispatcher = new EventDispatcher();
        }
        this.initializeServer();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (!this.running) {
            this.eventDispatcher.start();
            for (Processor processor : this.processors) {
                processor.start();
            }
            for (Listener listener : this.listeners) {
                listener.start();
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            for (Listener listener : this.listeners) {
                listener.setActive(false);
            }
            for (Processor processor : this.processors) {
                processor.setActive(false);
                processor.interrupt();
            }
            JRadiusSessionManager.shutdownManagers();
            this.eventDispatcher.setActive(false);
            this.eventDispatcher.interrupt();
            this.running = false;
        }
    }

    private void initializeServer() throws Exception {
        for (DictionaryConfigurationItem dictionaryConfig : Configuration.getDictionaryConfigs()) {
            AttributeFactory.loadAttributeDictionary((AttributeDictionary)Configuration.getBean(dictionaryConfig.getClassName()));
        }
        for (ListenerConfigurationItem listenerConfig : Configuration.getListenerConfigs()) {
            LinkedBlockingQueue<ListenerRequest> queue = new LinkedBlockingQueue<ListenerRequest>();
            this.createListenerWithConfigAndQueue(listenerConfig, queue);
            this.createProcessorsWithConfigAndQueue(listenerConfig, queue);
        }
    }

    private void createProcessorsWithConfigAndQueue(ListenerConfigurationItem listenerConfig, BlockingQueue<ListenerRequest> queue) throws Exception {
        for (int j = 0; j < listenerConfig.getNumberOfThreads(); ++j) {
            Processor processor = this.newProcessorForName(listenerConfig.getProcessorClassName());
            processor.setRequestQueue(queue);
            this.setPacketHandlersForProcessor(listenerConfig, processor);
            this.setEventHandlersForProcessor(listenerConfig, this.eventDispatcher);
            processor.setEventDispatcher(this.eventDispatcher);
            this.processors.add(processor);
        }
    }

    private void setPacketHandlersForProcessor(ListenerConfigurationItem cfg, Processor processor) {
        List<JRCommand> requestHandlers = cfg.getRequestHandlers();
        if (requestHandlers == null) {
            return;
        }
        for (JRCommand jRCommand : requestHandlers) {
        }
        processor.setRequestHandlers(requestHandlers);
    }

    private void setEventHandlersForProcessor(ListenerConfigurationItem cfg, EventDispatcher dispatcher) {
        List<JRCommand> eventHandlers = cfg.getEventHandlers();
        if (eventHandlers == null) {
            return;
        }
        for (JRCommand jRCommand : eventHandlers) {
        }
        dispatcher.setEventHandlers(eventHandlers);
    }

    private void createListenerWithConfigAndQueue(ListenerConfigurationItem listenerConfig, BlockingQueue<ListenerRequest> queue) throws Exception {
        Listener listener = this.newListenerWithConfig(listenerConfig);
        listener.setRequestQueue(queue);
        this.listeners.add(listener);
    }

    private Listener newListenerWithConfig(ListenerConfigurationItem cfg) throws Exception {
        Listener listener = (Listener)Configuration.getBean(cfg.getClassName());
        listener.setConfiguration(cfg);
        return listener;
    }

    private Processor newProcessorForName(String className) throws Exception {
        Processor processor = (Processor)Configuration.getBean(className);
        return processor;
    }

    public static String resultCodeToString(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "REJECT";
            }
            case 1: {
                return "FAIL";
            }
            case 2: {
                return "OK";
            }
            case 3: {
                return "HANDLED";
            }
            case 4: {
                return "INVALID";
            }
            case 5: {
                return "USERLOCK";
            }
            case 6: {
                return "NOTFOUND";
            }
            case 7: {
                return "NOOP";
            }
            case 8: {
                return "UPDATED";
            }
            case 9: {
                return "NUMCODES";
            }
        }
        return "UNKNOWN";
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }
}

