/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server;

import java.util.List;
import net.newjradius.exception.JRadiusException;
import net.newjradius.exception.JRadiusSecurityException;
import net.newjradius.handler.chain.JRCommand;
import net.newjradius.server.JRadiusRequest;
import net.newjradius.server.Processor;
import net.newjradius.server.event.HandlerLogEvent;
import net.newjradius.session.JRadiusSession;
import net.newjradius.session.JRadiusSessionManager;

public abstract class RadiusProcessor
extends Processor {
    protected abstract void logReturnCode(int var1, JRCommand var2);

    protected int handleRadiusException(JRadiusRequest request, JRadiusException e) {
        JRadiusSession session = request.getSession();
        String error = e.getMessage();
        if (session != null) {
            try {
                session.getLogEntry(request).addMessage(error);
            }
            catch (JRadiusException jRadiusException) {
                // empty catch block
            }
        }
        return e instanceof JRadiusSecurityException ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int runPacketHandlers(JRadiusRequest request) {
        List<JRCommand> handlers = this.getRequestHandlers();
        int result = 7;
        boolean exceptionThrown = false;
        if (handlers == null) {
            return result;
        }
        JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager(request.getSender());
        JRadiusSession session = null;
        if (sessionManager != null) {
            session = request.getSession();
            if (session == null) {
                try {
                    session = sessionManager.getSession(request);
                }
                catch (JRadiusException e) {
                    String error = e.getMessage();
                    String mesg = "Rejecting request";
                    try {
                        mesg = mesg + ": " + request.getRequestPacket().toString();
                    }
                    catch (JRadiusException jRadiusException) {
                        // empty catch block
                    }
                    return 0;
                }
            }
            if (session == null) {
                return 0;
            }
            request.setSession(session);
            sessionManager.lock(session);
        }
        try {
            for (JRCommand handler : handlers) {
                boolean stop = false;
                try {
                    if (!handler.doesHandle(request)) continue;
                    stop = handler.execute(request);
                    result = request.getReturnValue();
                    this.logReturnCode(result, handler);
                    if (!stop) continue;
                }
                catch (JRadiusException e) {
                    exceptionThrown = true;
                    result = this.handleRadiusException(request, e);
                    this.logReturnCode(result, handler);
                }
                catch (Throwable e) {
                    exceptionThrown = true;
                    String error = e.getMessage();
                    result = 1;
                    this.logReturnCode(result, handler);
                    e.printStackTrace();
                }
                break;
            }
            if (session != null && !exceptionThrown) {
                try {
                    session.onPostProcessing(request);
                }
                catch (JRadiusException e) {
                    result = this.handleRadiusException(request, e);
                }
                catch (Throwable e) {
                    result = 1;
                }
            }
            if (result == 0 && request.isAccountingRequest()) {
                result = 2;
            }
            if (session != null && session.isLogging()) {
                HandlerLogEvent log = new HandlerLogEvent(request, request.getSessionKey(), result);
                this.getEventDispatcher().post(log);
            }
        }
        finally {
            if (session != null) {
                sessionManager.unlock(session, true);
            }
        }
        return result;
    }
}

