/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.newjradius.server.JRadiusThread;
import net.newjradius.server.KeepAliveListener;
import net.newjradius.server.Listener;
import net.newjradius.server.ListenerRequest;
import net.newjradius.server.TCPListenerRequest;
import net.newjradius.server.config.Configuration;
import net.newjradius.server.config.ListenerConfigurationItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public abstract class TCPListener
extends JRadiusThread
implements Listener {
    protected Log log = LogFactory.getLog(this.getClass());
    protected boolean active = false;
    protected ListenerConfigurationItem config;
    protected BlockingQueue<ListenerRequest> queue;
    protected int port = 1814;
    protected int backlog = 1024;
    protected boolean requiresSSL = false;
    protected boolean usingSSL = false;
    protected boolean keepAlive;
    protected ServerSocket serverSocket;
    protected final List<KeepAliveListener> keepAliveListeners = new LinkedList<KeepAliveListener>();
    protected boolean sslWantClientAuth;
    protected boolean sslNeedClientAuth;
    protected String[] sslEnabledProtocols;
    protected String[] sslEnabledCiphers;
    protected ObjectPool requestObjectPool = new SoftReferenceObjectPool(new PoolableObjectFactory(){

        @Override
        public boolean validateObject(Object arg0) {
            return true;
        }

        @Override
        public void passivateObject(Object arg0) throws Exception {
        }

        @Override
        public Object makeObject() throws Exception {
            return new TCPListenerRequest();
        }

        @Override
        public void destroyObject(Object arg0) throws Exception {
        }

        @Override
        public void activateObject(Object arg0) throws Exception {
            TCPListenerRequest req = (TCPListenerRequest)arg0;
            req.clear();
        }
    });

    @Override
    public void setConfiguration(ListenerConfigurationItem cfg) {
        try {
            this.setConfiguration(cfg, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfiguration(ListenerConfigurationItem cfg, boolean noKeepAlive) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, IOException {
        this.keepAlive = !noKeepAlive;
        this.config = cfg;
        Map<String, String> props = this.config.getProperties();
        String s = props.get("port");
        if (s != null) {
            this.port = new Integer(s);
        }
        if ((s = props.get("backlog")) != null) {
            this.backlog = new Integer(s);
        }
        if (this.keepAlive && (s = props.get("keepAlive")) != null) {
            this.keepAlive = new Boolean(s);
        }
        String useSSL = props.get("useSSL");
        String trustAll = props.get("trustAll");
        if (this.requiresSSL || "true".equalsIgnoreCase(useSSL)) {
            String trustManager;
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            String keyManager = props.get("keyManager");
            if (keyManager != null && keyManager.length() > 0) {
                try {
                    KeyManager manager = (KeyManager)Configuration.getBean(keyManager);
                    keyManagers = new KeyManager[]{manager};
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String keystore = props.get("keyStore");
                String keystoreType = props.get("keyStoreType");
                String keystorePassword = props.get("keyStorePassword");
                String keyPassword = props.get("keyPassword");
                if (keystore != null) {
                    if (keystoreType == null) {
                        keystoreType = "pkcs12";
                    }
                    KeyStore ks = KeyStore.getInstance(keystoreType);
                    ks.load(new FileInputStream(keystore), keystorePassword == null ? null : keystorePassword.toCharArray());
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ks, keyPassword == null ? null : keyPassword.toCharArray());
                    keyManagers = kmf.getKeyManagers();
                }
            }
            if ((trustManager = props.get("trustManager")) != null && trustManager.length() > 0) {
                try {
                    TrustManager manager = (TrustManager)Configuration.getBean(trustManager);
                    trustManagers = new TrustManager[]{manager};
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("true".equalsIgnoreCase(trustAll)) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            } else {
                String keystore = props.get("caStore");
                String keystoreType = props.get("caStoreType");
                String keystorePassword = props.get("caStorePassword");
                if (keystore != null) {
                    if (keystoreType == null) {
                        keystoreType = "pkcs12";
                    }
                    KeyStore caKeys = KeyStore.getInstance(keystoreType);
                    caKeys.load(new FileInputStream(keystore), keystorePassword == null ? null : keystorePassword.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(caKeys);
                    trustManagers = tmf.getTrustManagers();
                }
            }
            SSLContext sslContext = SSLContext.getInstance("SSLv3");
            sslContext.init(keyManagers, trustManagers, null);
            SSLServerSocketFactory socketFactory = sslContext.getServerSocketFactory();
            SSLServerSocket sslServerSocket = (SSLServerSocket)socketFactory.createServerSocket(this.port, this.backlog);
            this.serverSocket = sslServerSocket;
            if (this.sslWantClientAuth) {
                sslServerSocket.setWantClientAuth(true);
            }
            if (this.sslNeedClientAuth) {
                sslServerSocket.setNeedClientAuth(true);
            }
            if (this.sslEnabledProtocols != null) {
                sslServerSocket.setEnabledProtocols(this.sslEnabledProtocols);
            }
            if (this.sslEnabledCiphers != null) {
                sslServerSocket.setEnabledCipherSuites(this.sslEnabledCiphers);
            }
            this.usingSSL = true;
        } else {
            this.serverSocket = new ServerSocket(this.port, this.backlog);
        }
        this.serverSocket.setReuseAddress(true);
        this.setActive(true);
    }

    @Override
    public void setRequestQueue(BlockingQueue<ListenerRequest> q) {
        this.queue = q;
    }

    public void setListenerConfigurationItem(ListenerConfigurationItem cfg) {
        this.config = cfg;
        this.setName(this.config.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() throws Exception {
        Socket socket = this.serverSocket.accept();
        socket.setTcpNoDelay(false);
        if (this.keepAlive) {
            KeepAliveListener keepAliveListener = new KeepAliveListener(socket, this, this.queue);
            keepAliveListener.start();
            List<KeepAliveListener> list = this.keepAliveListeners;
            synchronized (list) {
                this.keepAliveListeners.add(keepAliveListener);
            }
        } else {
            TCPListenerRequest lr = (TCPListenerRequest)this.requestObjectPool.borrowObject();
            lr.setBorrowedFromPool(this.requestObjectPool);
            lr.accept(socket, this, false, false);
            while (true) {
                try {
                    this.queue.put(lr);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public void deadKeepAliveListener(KeepAliveListener keepAliveListener) {
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            for (KeepAliveListener listener : this.keepAliveListeners) {
                try {
                    listener.shutdown(true);
                }
                catch (Throwable throwable) {}
            }
            this.keepAliveListeners.clear();
            try {
                this.serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        while (this.getActive()) {
            try {
                Thread.yield();
                this.listen();
            }
            catch (SocketException e) {
                if (this.getActive()) continue;
                break;
            }
            catch (InterruptedException e) {
            }
            catch (SSLException e) {
                this.active = false;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }
}

