/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.newjradius.server.Listener;
import net.newjradius.server.ListenerRequest;

public class TCPListenerRequest
extends ListenerRequest {
    private Socket socket;
    private InputStream bin;
    private OutputStream bout;
    boolean keepAlive;

    public TCPListenerRequest() {
    }

    public TCPListenerRequest(Socket socket, Listener listener, boolean getEvent, boolean keepAlive) throws Exception {
        this.accept(socket, listener, getEvent, keepAlive);
    }

    public TCPListenerRequest(Socket socket, InputStream bin, OutputStream bout, Listener listener, boolean getEvent, boolean keepAlive) throws Exception {
        this.accept(socket, bin, bout, listener, getEvent, keepAlive);
    }

    public void accept(Socket socket, Listener listener, boolean getEvent, boolean keepAlive) throws Exception {
        this.accept(socket, new BufferedInputStream(socket.getInputStream(), 4096), new BufferedOutputStream(socket.getOutputStream(), 4096), listener, getEvent, keepAlive);
    }

    public void accept(Socket socket, InputStream bin, OutputStream bout, Listener listener, boolean getEvent, boolean keepAlive) throws Exception {
        this.listener = listener;
        this.socket = socket;
        this.bin = bin;
        this.bout = bout;
        this.keepAlive = keepAlive;
        if (getEvent) {
            this.event = this.getEventFromListener();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.bin;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.bout;
    }

    @Override
    public Map<String, String> getServerVariables() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("REMOTE_ADDR", this.socket.getInetAddress().getHostAddress());
        return result;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }
}

