/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.newjradius.handler.chain.JRCommand;
import net.newjradius.handler.chain.JRConfigParser;
import net.newjradius.log.RadiusLogger;
import net.newjradius.realm.JRadiusRealmManager;
import net.newjradius.realm.RealmFactory;
import net.newjradius.server.config.DictionaryConfigurationItem;
import net.newjradius.server.config.HandlerConfigurationItem;
import net.newjradius.server.config.ListenerConfigurationItem;
import net.newjradius.server.config.LogConfigurationItem;
import net.newjradius.server.config.PacketHandlerConfigurationItem;
import net.newjradius.server.config.XMLConfiguration;
import net.newjradius.session.JRadiusSessionManager;
import net.newjradius.session.SessionFactory;
import net.newjradius.session.SessionKeyProvider;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public class Configuration {
    private static XMLConfiguration xmlCfg;
    private static HierarchicalConfiguration.Node root;
    private static boolean debug;
    private static int timeoutSeconds;
    private static File configFile;
    private static Map<String, ListenerConfigurationItem> listeners;
    private static Map packetHandlers;
    private static Map eventHandlers;
    private static Map dictionaries;
    private static BeanFactory beanFactory;
    private static JRConfigParser parser;
    private static CatalogFactory factory;
    private static LogConfigurationItem logConfig;
    private static final String SESSION_MANAGER_KEY = "session-manager";
    private static final String REALM_MANAGER_KEY = "realm-manager";
    private static final String REQUESTER_KEY = "requester";
    private static final String KEY_PROVIDER_KEY = "key-provider";
    private static final String SESSION_FACTORY_KEY = "session-factory";
    private static final String REALM_FACTORY_KEY = "realm-factory";

    public static void initialize(File file) throws FileNotFoundException, ConfigurationException {
        configFile = file;
        Configuration.initialize(new FileInputStream(file), null);
    }

    public static void initialize(InputStream input, BeanFactory factory) throws FileNotFoundException, ConfigurationException {
        logConfig = null;
        beanFactory = factory;
        xmlCfg = new XMLConfiguration(new InputStreamReader(input));
        root = xmlCfg.getRoot();
        Configuration.setLogConfig();
        Configuration.setGeneralOptions();
        Configuration.setRealmManagerConfig();
        Configuration.setSessionManagerConfig();
        Configuration.setDictionaryConfigs();
        Configuration.setPacketHandlersConfigs();
        Configuration.setEventHandlersConfigs();
        Configuration.setListenerConfigs();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getConfigFileDir() {
        if (configFile == null) {
            return ".";
        }
        String configFileDir = configFile.getParent();
        if (configFileDir == null) {
            return ".";
        }
        return configFileDir;
    }

    public static Collection getPacketHandlers() {
        return packetHandlers.values();
    }

    public static Collection getEventHandlers() {
        return eventHandlers.values();
    }

    public static PacketHandlerConfigurationItem packetHandlerConfigurationForName(String name) {
        return (PacketHandlerConfigurationItem)packetHandlers.get(name);
    }

    public static HandlerConfigurationItem eventHandlerConfigurationForName(String name) {
        return (HandlerConfigurationItem)eventHandlers.get(name);
    }

    public static JRCommand packetHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static JRCommand eventHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static Command getCommand(String commandID) throws IllegalArgumentException {
        int splitPos;
        String DELIMITER = ":";
        String commandName = commandID;
        String catalogName = null;
        Catalog catalog = null;
        if (commandID != null && (splitPos = commandID.indexOf(DELIMITER)) != -1) {
            catalogName = commandID.substring(0, splitPos);
            commandName = commandID.substring(splitPos + DELIMITER.length());
            if (commandName.indexOf(DELIMITER) != -1) {
                throw new IllegalArgumentException("commandID [" + commandID + "] has too many delimiters (reserved for future use)");
            }
        }
        if (catalogName != null ? (catalog = factory.getCatalog(catalogName)) == null : (catalog = factory.getCatalog()) == null) {
            return null;
        }
        return catalog.getCommand(commandName);
    }

    public static Collection<ListenerConfigurationItem> getListenerConfigs() {
        return listeners.values();
    }

    public static ListenerConfigurationItem listenerConfigurationForName(String name) {
        return listeners.get(name);
    }

    public static Collection getDictionaryConfigs() {
        return dictionaries.values();
    }

    public static DictionaryConfigurationItem dictionaryConfigurationForName(String name) {
        return (DictionaryConfigurationItem)dictionaries.get(name);
    }

    public static int getTimeoutSeconds() {
        return timeoutSeconds;
    }

    private static void setGeneralOptions() {
        debug = xmlCfg.getConfigBoolean("debug");
        timeoutSeconds = xmlCfg.getConfigInt("timeout");
        List children = root.getChildren("chain-catalog");
        for (HierarchicalConfiguration.Node node : children) {
            block7: {
                xmlCfg.setRoot(node);
                String catalogURL = xmlCfg.getConfigString("name");
                if (catalogURL != null) {
                    try {
                        boolean failure;
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        URL url = classLoader.getResource(catalogURL);
                        if (url == null) break block7;
                        try {
                            url.openStream().close();
                            failure = false;
                        }
                        catch (Exception e) {
                            failure = true;
                        }
                        if (!failure) {
                            parser.parse(url);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setDictionaryConfigs() {
        List children = root.getChildren(DictionaryConfigurationItem.XML_KEY);
        for (HierarchicalConfiguration.Node node : children) {
            xmlCfg.setRoot(node);
            DictionaryConfigurationItem item = new DictionaryConfigurationItem(node, xmlCfg);
            dictionaries.put(item.getName(), item);
            xmlCfg.setRoot(root);
        }
    }

    private static void setLogConfig() {
        List children = root.getChildren(LogConfigurationItem.XML_KEY);
        for (HierarchicalConfiguration.Node node : children) {
            xmlCfg.setRoot(node);
            if (logConfig != null) {
                return;
            }
            logConfig = new LogConfigurationItem(node, xmlCfg);
            try {
                RadiusLogger radiusLogger = (RadiusLogger)Configuration.getBean(logConfig.getClassName());
            }
            catch (Exception e) {
                logConfig = null;
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setPacketHandlersConfigs() {
        List list = root.getChildren("packet-handlers");
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren("packet-handler");
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                PacketHandlerConfigurationItem item = new PacketHandlerConfigurationItem(node2, xmlCfg);
                packetHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setEventHandlersConfigs() {
        List list = root.getChildren("event-handlers");
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren("event-handler");
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                HandlerConfigurationItem item = new HandlerConfigurationItem(node2, xmlCfg);
                eventHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setListenerConfigs() {
        List list = root.getChildren(ListenerConfigurationItem.XML_LIST_KEY);
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren(ListenerConfigurationItem.XML_KEY);
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                ListenerConfigurationItem item = new ListenerConfigurationItem(node2, xmlCfg);
                listeners.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setSessionManagerConfig() {
        List list = root.getChildren(SESSION_MANAGER_KEY);
        for (HierarchicalConfiguration.Node node : list) {
            xmlCfg.setRoot(node);
            String clazz = xmlCfg.getConfigString("class");
            String requester = xmlCfg.getConfigString(REQUESTER_KEY);
            String keyProvider = xmlCfg.getConfigString(KEY_PROVIDER_KEY);
            String sessionFactory = xmlCfg.getConfigString(SESSION_FACTORY_KEY);
            if (clazz != null) {
                try {
                    JRadiusSessionManager manager = (JRadiusSessionManager)Configuration.getBean(clazz);
                    JRadiusSessionManager.setManager(requester, manager);
                }
                catch (Exception manager) {
                    // empty catch block
                }
            }
            if (keyProvider != null) {
                try {
                    SessionKeyProvider provider = (SessionKeyProvider)Configuration.getBean(keyProvider);
                    JRadiusSessionManager.getManager(requester).setSessionKeyProvider(requester, provider);
                }
                catch (Exception provider) {
                    // empty catch block
                }
            }
            if (sessionFactory == null) continue;
            try {
                SessionFactory factory = (SessionFactory)Configuration.getBean(sessionFactory);
                factory.setConfig(xmlCfg, node);
                JRadiusSessionManager.getManager(requester).setSessionFactory(requester, factory);
            }
            catch (Exception exception) {}
        }
    }

    public static Object getBean(String name) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Object o = null;
        if (name == null) {
            return null;
        }
        if (name.startsWith("bean:")) {
            String[] s = name.split(":");
            o = beanFactory.getBean(s[1]);
        } else {
            Class<?> clazz = Class.forName(name);
            if (clazz == null) {
                return null;
            }
            o = clazz.newInstance();
            if (o instanceof BeanFactoryAware) {
                try {
                    ((BeanFactoryAware)o).setBeanFactory(beanFactory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (o instanceof InitializingBean) {
                try {
                    ((InitializingBean)o).afterPropertiesSet();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return o;
    }

    private static void setRealmManagerConfig() {
        List list = root.getChildren(REALM_MANAGER_KEY);
        for (HierarchicalConfiguration.Node node : list) {
            xmlCfg.setRoot(node);
            String requester = xmlCfg.getConfigString(REQUESTER_KEY);
            String realmFactory = xmlCfg.getConfigString(REALM_FACTORY_KEY);
            if (realmFactory == null) continue;
            try {
                RealmFactory factory = (RealmFactory)Configuration.getBean(realmFactory);
                factory.setConfig(xmlCfg, node);
                JRadiusRealmManager.getManager().setRealmFactory(requester, factory);
            }
            catch (Exception exception) {}
        }
    }

    static {
        listeners = new LinkedHashMap<String, ListenerConfigurationItem>();
        packetHandlers = new LinkedHashMap();
        eventHandlers = new LinkedHashMap();
        dictionaries = new LinkedHashMap();
        parser = new JRConfigParser();
        factory = CatalogFactory.getInstance();
    }
}

