/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import net.newjradius.packet.JRadiusPacket;
import net.newjradius.packet.RadiusFormat;
import net.newjradius.packet.attribute.AttributeFactory;
import net.newjradius.packet.attribute.RadiusAttribute;
import net.newjradius.util.MD5;

public class MessageAuthenticator {
    private static final RadiusFormat format = RadiusFormat.getInstance();

    public static void generateRequestMessageAuthenticator(JRadiusPacket request, String sharedSecret) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] hash = new byte[16];
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        request.overwriteAttribute(AttributeFactory.newAttribute(80L, hash, request.isRecyclable()));
        format.packPacket(request, sharedSecret, buffer, true);
        System.arraycopy(MD5.hmac_md5(buffer.array(), 0, buffer.position(), sharedSecret.getBytes()), 0, hash, 0, 16);
    }

    public static void generateResponseMessageAuthenticator(JRadiusPacket request, JRadiusPacket reply, String sharedSecret) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] hash = new byte[16];
        byte[] requestAuth = request.getAuthenticator();
        byte[] replyAuth = reply.getAuthenticator();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        reply.setAuthenticator(requestAuth);
        reply.overwriteAttribute(AttributeFactory.newAttribute(80L, hash, reply.isRecyclable()));
        format.packPacket(reply, sharedSecret, buffer, true);
        System.arraycopy(MD5.hmac_md5(buffer.array(), 0, buffer.position(), sharedSecret.getBytes()), 0, hash, 0, 16);
        reply.setAuthenticator(replyAuth);
    }

    public static void generateResponseMessageAuthenticatorAsFirstAttribute(byte[] requestAuth, JRadiusPacket reply, String sharedSecret) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] hash = new byte[16];
        byte[] replyAuth = reply.getAuthenticator();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        reply.setAuthenticator(requestAuth);
        reply.overwriteAttribute(AttributeFactory.newAttribute(80L, hash, reply.isRecyclable()));
        Collections.swap(reply.getAttributes().getAttributeList(), 0, reply.getAttributes().getAttributeList().indexOf(reply.findAttribute(80L)));
        format.packPacket(reply, sharedSecret, buffer, true);
        System.arraycopy(MD5.hmac_md5(buffer.array(), 0, buffer.position(), sharedSecret.getBytes()), 0, hash, 0, 16);
        reply.setAuthenticator(replyAuth);
    }

    public static Boolean verifyRequest(JRadiusPacket request, String sharedSecret) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] hash = new byte[16];
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        RadiusAttribute attr = request.findAttribute(80L);
        if (attr == null) {
            return null;
        }
        byte[] pval = attr.getValue().getBytes();
        attr.setValue(hash);
        format.packPacket(request, sharedSecret, buffer, true);
        System.arraycopy(MD5.hmac_md5(buffer.array(), 0, buffer.position(), sharedSecret.getBytes()), 0, hash, 0, 16);
        attr.setValue(pval);
        return new Boolean(Arrays.equals(pval, hash));
    }

    public static Boolean verifyReply(byte[] requestAuth, JRadiusPacket reply, String sharedSecret) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] replyAuth = reply.getAuthenticator();
        byte[] hash = new byte[16];
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        RadiusAttribute attr = reply.findAttribute(80L);
        if (attr == null) {
            return null;
        }
        byte[] pval = attr.getValue().getBytes();
        attr.setValue(hash);
        reply.setAuthenticator(requestAuth);
        format.packPacket(reply, sharedSecret, buffer, true);
        System.arraycopy(MD5.hmac_md5(buffer.array(), 0, buffer.position(), sharedSecret.getBytes()), 0, hash, 0, 16);
        reply.setAuthenticator(replyAuth);
        return new Boolean(Arrays.equals(pval, hash));
    }
}

