/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.accells.api.APIRequestSignatureClientFilter;
import org.accells.api.APISignatureClientFilter;
import org.accells.api.AuthenticationAPI;
import org.accells.api.AuthenticationManagedOrganizationAPI;
import org.accells.api.ContextLocaleGetter;
import org.accells.api.OrganizationAPI;
import org.accells.api.PingIdAPIConstructorParams;
import org.accells.api.PolicyEditorAPI;
import org.accells.api.PolicyManagedEditorAPI;
import org.accells.api.SuperAdminAPI;
import org.accells.api.TestingAPI;
import org.accells.api.UserAdminAPI;
import org.accells.api.UserAdminManagedOrganizationAPI;
import org.accells.api.exceptions.AccellsAPIException;
import org.accells.api.model.accellsinternal.request.body.GetPropertiesRequest;
import org.accells.api.model.accellsinternal.request.body.LoadPropertiesRequest;
import org.accells.api.model.accellsinternal.response.body.GetPropertiesResponse;
import org.accells.api.model.accellsinternal.response.body.LoadPropertiesResponse;
import org.accells.api.model.email.request.SendAuthenticationMailRequest;
import org.accells.api.model.email.request.SendDownloadAndPairMailRequest;
import org.accells.api.model.email.request.SendFraudMailRequest;
import org.accells.api.model.email.request.SendOnBoardingMailRequest;
import org.accells.api.model.email.response.SendAuthenticationMailResponse;
import org.accells.api.model.email.response.SendDownloadAndPairMailResponse;
import org.accells.api.model.email.response.SendFraudMailResponse;
import org.accells.api.model.email.response.SendOnBoardingMailResponse;
import org.accells.api.model.passwordless.request.body.FinishWebAuthnPasswordlessAuthRequest;
import org.accells.api.model.passwordless.request.body.IssueWinSignOnCsrRequest;
import org.accells.api.model.passwordless.request.body.ReadKerberosCredentialsRequest;
import org.accells.api.model.passwordless.request.body.StartWebAuthnPasswordlessAuthRequest;
import org.accells.api.model.passwordless.response.body.FinishWebAuthnPasswordlessAuthResponse;
import org.accells.api.model.passwordless.response.body.IssueWinSignOnCsrResponse;
import org.accells.api.model.passwordless.response.body.ReadKerberosCredentialsResponse;
import org.accells.api.model.passwordless.response.body.StartWebAuthnPasswordlessAuthResponse;
import org.accells.api.model.policy.request.CreateAuthenticationPolicyRequest;
import org.accells.api.model.policy.request.CreateBulkAuthenticationPolicyRequest;
import org.accells.api.model.policy.request.CreateBulkDeviceRequirementsRequest;
import org.accells.api.model.policy.request.CreateDeviceRequirementsRequest;
import org.accells.api.model.policy.request.CreateGeoFenceRequest;
import org.accells.api.model.policy.request.CreatePairingConditionsRequest;
import org.accells.api.model.policy.request.ReadAuthenticationPolicyRequest;
import org.accells.api.model.policy.request.ReadBulkAuthenticationPolicyRequest;
import org.accells.api.model.policy.request.ReadDeviceRequirementsRequest;
import org.accells.api.model.policy.request.ReadGeoFenceRequest;
import org.accells.api.model.policy.request.ReadPairingConditionsRequest;
import org.accells.api.model.policy.response.CreateAuthenticationPolicyResponse;
import org.accells.api.model.policy.response.CreateBulkAuthenticationPolicyResponse;
import org.accells.api.model.policy.response.CreateBulkDeviceRequirementsResponse;
import org.accells.api.model.policy.response.CreateDeviceRequirementsResponse;
import org.accells.api.model.policy.response.CreateGeoFenceResponse;
import org.accells.api.model.policy.response.CreatePairingConditionsResponse;
import org.accells.api.model.policy.response.ReadAuthenticationPolicyResponse;
import org.accells.api.model.policy.response.ReadBulkAuthenticationPolicyResponse;
import org.accells.api.model.policy.response.ReadDeviceRequirementsResponse;
import org.accells.api.model.policy.response.ReadGeoFenceResponse;
import org.accells.api.model.policy.response.ReadPairingConditionsResponse;
import org.accells.api.model.request.AccellsRequest;
import org.accells.api.model.request.RequestHeader;
import org.accells.api.model.request.body.ActivateUserRequest;
import org.accells.api.model.request.body.AddApplicationRequest;
import org.accells.api.model.request.body.AddFeatureFlaggingRequest;
import org.accells.api.model.request.body.AddOrganizationEmailTemplateRequest;
import org.accells.api.model.request.body.AddSessionDataRequest;
import org.accells.api.model.request.body.AddUserRequest;
import org.accells.api.model.request.body.AddUserSPRequest;
import org.accells.api.model.request.body.AgentAuthRequest;
import org.accells.api.model.request.body.AuthOfflineRequest;
import org.accells.api.model.request.body.AuthOnlineRequest;
import org.accells.api.model.request.body.AuthStatusRequest;
import org.accells.api.model.request.body.AuthenticatorAppStartPairingRequest;
import org.accells.api.model.request.body.BypassRequest;
import org.accells.api.model.request.body.CancelAuthenticationRequest;
import org.accells.api.model.request.body.CreateAgentRequest;
import org.accells.api.model.request.body.CreateAgentsRequest;
import org.accells.api.model.request.body.CreateBulkOrganizationLocalizationRequest;
import org.accells.api.model.request.body.CreateJobRequest;
import org.accells.api.model.request.body.CreateJwsRequest;
import org.accells.api.model.request.body.CreateOrganizationLocalizationRequest;
import org.accells.api.model.request.body.CreateOrganizationRequest;
import org.accells.api.model.request.body.CreateOrganizationTokensRequest;
import org.accells.api.model.request.body.DeleteAgentRequest;
import org.accells.api.model.request.body.DeleteAgentsRequest;
import org.accells.api.model.request.body.DeleteAllOrgLocalizationRequest;
import org.accells.api.model.request.body.DeleteApplicationsRequest;
import org.accells.api.model.request.body.DeleteBulkOrganizationAttributeRequest;
import org.accells.api.model.request.body.DeleteFeatureFlaggingRequest;
import org.accells.api.model.request.body.DeleteOrganizationAttributeRequest;
import org.accells.api.model.request.body.DeleteOrganizationLocalizationRequest;
import org.accells.api.model.request.body.DeleteOrganizationRequest;
import org.accells.api.model.request.body.DeleteOrganizationTokensRequest;
import org.accells.api.model.request.body.DeleteSessionDataRequest;
import org.accells.api.model.request.body.DeleteUserRequest;
import org.accells.api.model.request.body.DeleteUserSPRequest;
import org.accells.api.model.request.body.EditUserRequest;
import org.accells.api.model.request.body.EditUserSPRequest;
import org.accells.api.model.request.body.FinalizeOfflinePairingRequest;
import org.accells.api.model.request.body.FinalizeSmsPairingRequest;
import org.accells.api.model.request.body.GetActivationCodeRequest;
import org.accells.api.model.request.body.GetAgentRequest;
import org.accells.api.model.request.body.GetAllServiceProvidersRequest;
import org.accells.api.model.request.body.GetAppVersionsRequest;
import org.accells.api.model.request.body.GetApplicationsRequest;
import org.accells.api.model.request.body.GetBulkJobStatusRequest;
import org.accells.api.model.request.body.GetDeviceModelsRequest;
import org.accells.api.model.request.body.GetDeviceOSVersionsRequest;
import org.accells.api.model.request.body.GetJobStatusRequest;
import org.accells.api.model.request.body.GetOrgKeysRequest;
import org.accells.api.model.request.body.GetOrgReportRequest;
import org.accells.api.model.request.body.GetPayloadRequest;
import org.accells.api.model.request.body.GetSessionDataRequest;
import org.accells.api.model.request.body.GetUserRequest;
import org.accells.api.model.request.body.HeartbeatRequest;
import org.accells.api.model.request.body.LinkNewPingIDToPingOneRequest;
import org.accells.api.model.request.body.LinkNewPingOneToPingIDRequest;
import org.accells.api.model.request.body.OfflinePairingRequest;
import org.accells.api.model.request.body.OrgMigrationRequest;
import org.accells.api.model.request.body.OrgReportMigrationRequest;
import org.accells.api.model.request.body.PairMockupUserRequest;
import org.accells.api.model.request.body.PairYubiKeyRequest;
import org.accells.api.model.request.body.PairingStatusRequest;
import org.accells.api.model.request.body.PolicyMigrationRequest;
import org.accells.api.model.request.body.ReadBulkOrgLocalizationRequest;
import org.accells.api.model.request.body.ReadBulkOrganizationAttributeRequest;
import org.accells.api.model.request.body.ReadFeatureFlaggingRequest;
import org.accells.api.model.request.body.ReadOrgLocalizationRequest;
import org.accells.api.model.request.body.ReadOrganizationAttributeRequest;
import org.accells.api.model.request.body.ReadOrganizationEmailTemplateRequest;
import org.accells.api.model.request.body.ReadOrganizationRequest;
import org.accells.api.model.request.body.ReadOrganizationTokensRequest;
import org.accells.api.model.request.body.RemoveBypassRequest;
import org.accells.api.model.request.body.RemoveOrganizationEmailTemplateRequest;
import org.accells.api.model.request.body.ReportFraudRequest;
import org.accells.api.model.request.body.ResyncOathTokenRequest;
import org.accells.api.model.request.body.RevokeOrganizationTokensRequest;
import org.accells.api.model.request.body.SavePayloadRequest;
import org.accells.api.model.request.body.SecureDataCaptureRequest;
import org.accells.api.model.request.body.StartAuthenticationRequest;
import org.accells.api.model.request.body.StartOfflinePairingRequest;
import org.accells.api.model.request.body.StartSmsPairingRequest;
import org.accells.api.model.request.body.SuspendUserRequest;
import org.accells.api.model.request.body.UnlinkPingOneToPingIDRequest;
import org.accells.api.model.request.body.UnpairDeviceRequest;
import org.accells.api.model.request.body.UnpairOrganizationUsersRequest;
import org.accells.api.model.request.body.UnpairUsersByFingerPrintRequest;
import org.accells.api.model.request.body.UpdateAgentRequest;
import org.accells.api.model.request.body.UpdateApplicationsRequest;
import org.accells.api.model.request.body.UpdateBulkOrganizationAttributeRequest;
import org.accells.api.model.request.body.UpdateDeviceAttributeRequest;
import org.accells.api.model.request.body.UpdateOrganizationAttributeRequest;
import org.accells.api.model.request.body.UpdateOrganizationRequest;
import org.accells.api.model.request.body.VerifyJwtSignatureRequest;
import org.accells.api.model.request.body.VerifyOrgKeysPermissionsRequest;
import org.accells.api.model.request.body.WebAuthnFinishPairingRequest;
import org.accells.api.model.request.body.WebAuthnStartAuthRequest;
import org.accells.api.model.request.body.WebAuthnStartPairingRequest;
import org.accells.api.model.request.body.ZeroTouchSessionStatusRequest;
import org.accells.api.model.response.AccellsResponse;
import org.accells.api.model.response.body.ActivateUserResponse;
import org.accells.api.model.response.body.AddApplicationResponse;
import org.accells.api.model.response.body.AddFeatureFlaggingResponse;
import org.accells.api.model.response.body.AddOrganizationEmailTemplateResponse;
import org.accells.api.model.response.body.AddSessionDataResponse;
import org.accells.api.model.response.body.AddUserResponse;
import org.accells.api.model.response.body.AddUserSPResponse;
import org.accells.api.model.response.body.AgentAuthResponse;
import org.accells.api.model.response.body.AuthOfflineResponse;
import org.accells.api.model.response.body.AuthOnlineResponse;
import org.accells.api.model.response.body.AuthStatusResponse;
import org.accells.api.model.response.body.AuthenticatorAppStartPairingResponse;
import org.accells.api.model.response.body.BaseResponseBody;
import org.accells.api.model.response.body.BypassResponse;
import org.accells.api.model.response.body.CancelAuthenticationResponse;
import org.accells.api.model.response.body.CreateAgentResponse;
import org.accells.api.model.response.body.CreateAgentsResponse;
import org.accells.api.model.response.body.CreateBulkOrganizationLocalizationResponse;
import org.accells.api.model.response.body.CreateJobResponse;
import org.accells.api.model.response.body.CreateJwsResponse;
import org.accells.api.model.response.body.CreateOrganizationLocalizationResponse;
import org.accells.api.model.response.body.CreateOrganizationResponse;
import org.accells.api.model.response.body.CreateOrganizationTokensResponse;
import org.accells.api.model.response.body.DeleteAgentResponse;
import org.accells.api.model.response.body.DeleteAgentsResponse;
import org.accells.api.model.response.body.DeleteAllOrgLocalizationResponse;
import org.accells.api.model.response.body.DeleteApplicationsResponse;
import org.accells.api.model.response.body.DeleteBulkOrganizationAttributeResponse;
import org.accells.api.model.response.body.DeleteFeatureFlaggingResponse;
import org.accells.api.model.response.body.DeleteOrganizationAttributeResponse;
import org.accells.api.model.response.body.DeleteOrganizationLocalizationResponse;
import org.accells.api.model.response.body.DeleteOrganizationResponse;
import org.accells.api.model.response.body.DeleteOrganizationTokensResponse;
import org.accells.api.model.response.body.DeleteSessionDataResponse;
import org.accells.api.model.response.body.DeleteUserResponse;
import org.accells.api.model.response.body.DeleteUserSPResponse;
import org.accells.api.model.response.body.EditUserResponse;
import org.accells.api.model.response.body.EditUserSPResponse;
import org.accells.api.model.response.body.FinalizeOfflinePairingResponse;
import org.accells.api.model.response.body.FinalizeSmsPairingResponse;
import org.accells.api.model.response.body.GetActivationCodeResponse;
import org.accells.api.model.response.body.GetAgentResponse;
import org.accells.api.model.response.body.GetAllServiceProvidersResponse;
import org.accells.api.model.response.body.GetAppVersionsResponse;
import org.accells.api.model.response.body.GetApplicationsResponse;
import org.accells.api.model.response.body.GetBulkJobStatusResponse;
import org.accells.api.model.response.body.GetDeviceModelsResponse;
import org.accells.api.model.response.body.GetDeviceOSVersionsResponse;
import org.accells.api.model.response.body.GetJobStatusResponse;
import org.accells.api.model.response.body.GetOrgKeysResponse;
import org.accells.api.model.response.body.GetPayloadResponse;
import org.accells.api.model.response.body.GetSessionDataResponse;
import org.accells.api.model.response.body.GetUserResponse;
import org.accells.api.model.response.body.HeartbeatResponse;
import org.accells.api.model.response.body.OfflinePairingResponse;
import org.accells.api.model.response.body.OrgMigrationResponse;
import org.accells.api.model.response.body.OrgReportMigrationResponse;
import org.accells.api.model.response.body.PairMockupUserResponse;
import org.accells.api.model.response.body.PairYubiKeyResponse;
import org.accells.api.model.response.body.PairingStatusResponse;
import org.accells.api.model.response.body.PolicyMigrationResponse;
import org.accells.api.model.response.body.ReadBulkOrgLocalizationResponse;
import org.accells.api.model.response.body.ReadBulkOrganizationAttributeResponse;
import org.accells.api.model.response.body.ReadFeatureFlaggingResponse;
import org.accells.api.model.response.body.ReadOrgLocalizationResponse;
import org.accells.api.model.response.body.ReadOrganizationAttributeResponse;
import org.accells.api.model.response.body.ReadOrganizationEmailTemplateResponse;
import org.accells.api.model.response.body.ReadOrganizationResponse;
import org.accells.api.model.response.body.ReadOrganizationTokensResponse;
import org.accells.api.model.response.body.RemoveOrganizationEmailTemplateResponse;
import org.accells.api.model.response.body.ReportFraudResponse;
import org.accells.api.model.response.body.ResyncOathTokenResponse;
import org.accells.api.model.response.body.RevokeOrganizationTokensResponse;
import org.accells.api.model.response.body.SavePayloadResponse;
import org.accells.api.model.response.body.SecureDataCaptureResponse;
import org.accells.api.model.response.body.StartAuthenticationResponse;
import org.accells.api.model.response.body.StartOfflinePairingResponse;
import org.accells.api.model.response.body.StartSmsPairingResponse;
import org.accells.api.model.response.body.SuspendUserResponse;
import org.accells.api.model.response.body.UnpairDeviceResponse;
import org.accells.api.model.response.body.UnpairOrganizationUsersResponse;
import org.accells.api.model.response.body.UnpairUsersByFingerPrintResponse;
import org.accells.api.model.response.body.UpdateAgentResponse;
import org.accells.api.model.response.body.UpdateApplicationResponse;
import org.accells.api.model.response.body.UpdateBulkOrganizationAttributeResponse;
import org.accells.api.model.response.body.UpdateDeviceAttributeResponse;
import org.accells.api.model.response.body.UpdateOrganizationAttributeResponse;
import org.accells.api.model.response.body.UpdateOrganizationResponse;
import org.accells.api.model.response.body.VerifyJwtSignatureResponse;
import org.accells.api.model.response.body.VerifyOrgKeysPermissionsResponse;
import org.accells.api.model.response.body.WebAuthnFinishPairingResponse;
import org.accells.api.model.response.body.WebAuthnStartAuthResponse;
import org.accells.api.model.response.body.WebAuthnStartPairingResponse;
import org.accells.api.model.response.body.ZeroTouchSessionStatusResponse;
import org.accells.crypto.APISignature;
import org.accells.crypto.AccellsAPISignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingIdAPI
implements AuthenticationAPI,
UserAdminAPI,
AuthenticationManagedOrganizationAPI,
SuperAdminAPI,
OrganizationAPI,
UserAdminManagedOrganizationAPI,
PolicyEditorAPI,
PolicyManagedEditorAPI,
TestingAPI {
    private String token;
    private String apiUserId;
    private String orgAlias;
    private String idpUrl;
    private boolean useSignature;
    private String locale;
    private ContextLocaleGetter localeGetter;
    private Client jerseyClient;
    private Client unsignedResponseClient;
    private ObjectMapper mapper;
    private AccellsAPISignature apiSignature;
    private WebResource webResource;
    private WebResource unsignedResponseResource;
    private static final String IDP_URL = "https://idpxnyl3m.pingidentity.com/pingid";
    private static final String VERSION = "4";
    private static final String REST_URL = "/rest/4";
    private static final String AUTH_ONLINE_URL = "authonline/do";
    private static final String START_AUTHENTICATION_URL = "startauthentication/do";
    private static final String CANCEL_AUTHENTICATION_URL = "cancelauthentication/do";
    private static final String AGENT_AUTH_URL = "agentauth/do";
    private static final String AUTH_OFFLINE_URL = "authoffline/do";
    private static final String AUTH_STATUS_URL = "authstatus/do";
    private static final String HEARTBEAT_URL = "heartbeat/do";
    private static final String SECURE_DATA_CAPTURE_URL = "securedatacapture/do";
    private static final String ZERO_TOUCH_SESSION_STATUS_URL = "zerotouchsessionstatus/do";
    private static final String PAIR_MOCKUP_USER_URL = "pairmockupuser/do";
    private static final String ADD_SERVICE_URL = "addservice/do";
    private static final String EDIT_SERVICE_URL = "editservice/do";
    private static final String DELETE_SERVICE_URL = "deleteservice/do";
    private static final String UPDATE_DEVICE_ATTRIBUTE = "updatedeviceattr/do";
    private static final String ADD_USER_URL = "adduser/do";
    private static final String EDIT_USER_URL = "edituser/do";
    private static final String DELETE_USER_URL = "deleteuser/do";
    private static final String GET_USER_URL = "getuserdetails/do";
    private static final String ACTIVATE_USER_URL = "activateuser/do";
    private static final String SUSPEND_USER_URL = "suspenduser/do";
    private static final String CREATE_AGENT_URL = "createagent/do";
    private static final String UPDATE_SECRET_KEY_URL = "updateagent/do";
    private static final String DELETE_AGENT_URL = "deleteagent/do";
    private static final String LOAD_PROPERTIES_URL = "loadproperties/do";
    private static final String GET_PROPERTIES_URL = "getproperty/do";
    private static final String PAIRING_STATUS_URL = "pairingstatus/do";
    private static final String GET_SERVICE_PROVIDERS_URL = "getallserviceproviders/do";
    private static final String CREATE_ORGANIZATION_URL = "createorg/do";
    private static final String UPDATE_ORGANIZATION_URL = "updateorg/do";
    private static final String UPDATE_ORGANIZATION_ATTR_URL = "updateorgattr/do";
    private static final String UPDATE_BULK_ORGANIZATION_ATTR_URL = "updatebulkorgattr/do";
    private static final String DELETE_ORGANIZATION_ATTR_URL = "deleteorgattr/do";
    private static final String READ_ORGANIZATION_URL = "readorg/do";
    private static final String CREATE_PID_P1_MAPPING = "synchronization/linkpingone/do";
    private static final String UNLINK_PID_P1_MAPPING = "synchronization/unlinkpingone/do";
    private static final String LINK_NEW_PID_TO_P1 = "synchronization/linkpingid/do";
    private static final String READ_ORG_LOCALIZATION_URL = "readorglocalization/do";
    private static final String READ_BULK_ORG_LOCALIZATION_URL = "readbulkorglocalization/do";
    private static final String CREATE_ORG_LOCALIZATION_URL = "createorglocalization/do";
    private static final String UPDATE_ORG_LOCALIZATION_URL = "updateorglocalization/do";
    private static final String DELETE_ORG_LOCALIZATION_URL = "deleteorglocalization/do";
    private static final String UPDATE_BULK_ORG_LOCALIZATION_URL = "updatebulkorglocalization/do";
    private static final String CREATE_BULK_ORG_LOCALIZATION_URL = "createbulkorglocalization/do";
    private static final String DELETE_ALL_ORG_LOCALIZATION_URL = "deleteallorglocalization/do";
    private static final String READ_ORGANIZATION_ATTR_URL = "readorgattr/do";
    private static final String READ_BULK_ORGANIZATION_ATTR_URL = "readbulkorgattr/do";
    private static final String DELETE_ORGANIZATION_URL = "deleteorg/do";
    private static final String DELETE_BULK_ORGANIZATION_ATTR_URL = "deletebulkorgattr/do";
    private static final String POLICY_MIGRATION_URL = "policymigration/do";
    private static final String ORG_MIGRATION_URL = "orgmigration/do";
    private static final String GET_ACTIVATION_CODE_URL = "getactivationcode/do";
    private static final String USER_BYPASS_URL = "userbypass/do";
    private static final String UNPAIR_DEVICE_URL = "unpairdevice/do";
    private static final String CREATE_AUTHENTICATION_POLICY_URL = "createauthenticationpolicy/do";
    private static final String CREATE_BULK_AUTHENTICATION_POLICY_URL = "createbulkauthenticationpolicy/do";
    private static final String CREATE_DEVICE_REQUIREMENTS_URL = "createdevicerequirements/do";
    private static final String CREATE_BULK_DEVICE_REQUIREMENTS_URL = "createbulkdevicerequirements/do";
    private static final String CREATE_PAIRING_CONDITIONS_URL = "createpairingconditions/do";
    private static final String CREATE_GEO_FENCE_URL = "creategeofence/do";
    private static final String READ_GEO_FENCE_URL = "readgeofence/do";
    private static final String READ_AUTHENTICATION_POLICY_URL = "readauthenticationpolicy/do";
    private static final String READ_BULK_AUTHENTICATION_POLICY_URL = "readbulkauthenticationpolicy/do";
    private static final String READ_DEVICE_REQUIREMENTS_URL = "readdevicerequirements/do";
    private static final String READ_PAIRING_CONDITIONS_URL = "readpairingconditions/do";
    private static final String READ_APPLICATIONS_URL = "getapplications/do";
    private static final String ADD_APPLICATION_URL = "addapplication/do";
    private static final String DELETE_APPLICATIONS_URL = "deleteapplications/do";
    private static final String UPDATE_APPLICATIONS_URL = "updateapplications/do";
    private static final String UNPAIR_ORGANIZATION_USERS_URL = "unpairorganizationusers/do";
    private static final String ADD_FEATURE_FLAG_URL = "addfeatureflag/do";
    private static final String DELETE_FEATURE_FLAG_URL = "deletefeatureflag/do";
    private static final String READ_FEATURE_FLAG_URL = "readfeatureflag/do";
    private static final String START_SMS_PAIRING_URL = "startsmspairing/do";
    private static final String FINALIZING_SMS_PAIRING_URL = "finalizesmspairing/do";
    private static final String START_OFFLINE_PAIRING_URL = "startofflinepairing/do";
    private static final String FINALIZING_OFFLINE_PAIRING_URL = "finalizeofflinepairing/do";
    private static final String FINALIZING_AUTHENTICATOR_APP_PAIRING_URL = "authenticatorappfinishpairing/do";
    private static final String OFFLINE_PAIRING_URL = "offlinepairing/do";
    private static final String RESYNC_OATH_TOKEN_URL = "resyncoathtoken/do";
    private static final String START_AUTHENTICATOR_APP_PAIRING_URL = "authenticatorappstartpairing/do";
    private static final String PAIR_YUBIKEY_URL = "pairyubikey/do";
    private static final String GET_DEVICE_MODELS_URL = "getdevicemodels/do";
    private static final String GET_DEVICE_OS_VERSIONS_URL = "getdeviceosversions/do";
    private static final String GET_APP_VERSIONS_URL = "getappversions/do";
    private static final String ADD_ORGANIZATION_EMAIL_TEMPLATE_URL = "addorgemailtemplate/do";
    private static final String REMOVE_ORGANIZATION_EMAIL_TEMPLATE_URL = "removeorgemailtemplate/do";
    private static final String READ_ORGANIZATION_EMAIL_TEMPLATE_URL = "readorgemailtemplate/do";
    private static final String GET_USER_SESSION_DATA = "getuserseesiondata/do";
    private static final String ADD_USER_SESSION_DATA = "adduserseesiondata/do";
    private static final String DELETE_USER_SESSION_DATA = "deleteuserseesiondata/do";
    private static final String REPORT_FRAUD = "reportfraud/do";
    private static final String CREATE_ORG_REPORT_JOB_URL = "createjob/do";
    private static final String GET_ORG_REPORT_JOB_STATUS_URL = "getjobstatus/do";
    private static final String GET_BULK_JOB_STATUS = "getbulkjobstatus/do";
    private static final String GET_ORG_REPORT_URL = "getorgreport/do";
    private static final String ORG_REPORT_MIGRATION = "orgreportmigration/do";
    private static final String SEND_MAIL_DOWNLOAD_PAIR = "senddownloadandpairmail/do";
    private static final String SEND_MAIL_AUTHENTICATION = "sendauthenticationmail/do";
    private static final String SEND_MAIL_ON_BOARDING = "sendonboardingmail/do";
    private static final String SEND_MAIL_FRAUD = "sendfraudmail/do";
    private static final String VERIFY_ORGKEYS_PERMISSIONS = "verifyorgkeyspermissions/do";
    private static final String VERIFY_JWT_SIGNATURE = "verifyjwtsignature/do";
    private static final String CREATE_JWS = "createjws/do";
    private static final String GET_ORGKEYS = "getorgkeys/do";
    private static final String CREATE_AGENTS = "createagents/do";
    private static final String DELETE_AGENTS = "deleteagents/do";
    private static final String GET_AGENT = "getagent/do";
    private static final String SAVE_PAYLOAD = "savepayload/do";
    private static final String GET_PAYLOAD = "getpayload/do";
    private static final String START_WEBAUTHN_PAIRING_URL = "webauthnstartpairing/do";
    private static final String FINISH_WEBAUTHN_PAIRING_URL = "webauthnfinishpairing/do";
    private static final String START_WEBAUTHN_AUTH_URL = "webauthnstartauth/do";
    private static final String FINISH_WEBAUTHN_AUTH_URL = "webauthnfinishauth/do";
    private static final String START_WEBAUTHN_PASSWORDLESS_AUTH_URL = "startwebauthnpasswordlessauth/do";
    private static final String FINISH_WEBAUTHN_PASSWORDLESS_AUTH_URL = "finishwebauthnpasswordlessauth/do";
    private static final String CREATE_ORG_TOKENS = "createorgtokens/do";
    private static final String READ_ORG_TOKENS = "readorgtokens/do";
    private static final String DELETE_ORG_TOKENS = "deleteorgtokens/do";
    private static final String UNPAIR_USERS_BY_FP = "unpairusersbyfingerprint/do";
    private static final String REVOKE_ORG_TOKENS = "revokeorgtokens/do";
    private static final String ISSUE_WIN_SIGNON_CSR = "issuewinsignoncsr/do";
    private static final String READ_KERBEROS_CREDENTIALS = "readkerberoscredentials/do";
    private static final Logger logger = LoggerFactory.getLogger(PingIdAPI.class);

    protected PingIdAPI(PingIdAPIConstructorParams params) throws IOException, AccellsAPIException {
        this.initParameters(params);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        this.jerseyClient = Client.create((ClientConfig)clientConfig);
        this.unsignedResponseClient = Client.create((ClientConfig)clientConfig);
        if (this.useSignature) {
            this.jerseyClient.addFilter((ClientFilter)new APISignatureClientFilter(this.apiSignature));
            this.unsignedResponseClient.addFilter((ClientFilter)new APIRequestSignatureClientFilter(this.apiSignature));
        }
        for (ClientFilter clientFilter : params.getClientFilterList()) {
            this.jerseyClient.addFilter(clientFilter);
        }
        this.jerseyClient.setConnectTimeout(Integer.valueOf(10000));
        this.mapper = new ObjectMapper();
        logger.debug("sending all requests to: " + this.idpUrl + REST_URL);
        this.webResource = this.jerseyClient.resource(this.idpUrl + REST_URL);
        this.unsignedResponseResource = this.unsignedResponseClient.resource(this.idpUrl + REST_URL);
    }

    private void initParameters(PingIdAPIConstructorParams params) throws IOException, AccellsAPIException {
        if (params.getAccellsPropertiesPath() != null && !params.getAccellsPropertiesPath().equals("")) {
            logger.debug("initializing parameters from properties file");
            this.initParametersFromPropertiesFile(params);
        } else {
            logger.debug("initializing parameters from Constractor parameters");
            this.useSignature = true;
            this.initParametersFromInputObject(params);
        }
    }

    private void initParametersFromInputObject(PingIdAPIConstructorParams params) throws AccellsAPIException {
        if (params.getApiUserName() != null) {
            this.apiUserId = params.getApiUserName();
        }
        if (params.getToken() == null || params.getToken().equals("")) {
            logger.error("missing client token");
            throw new AccellsAPIException("missing Token");
        }
        this.token = params.getToken();
        if (params.getOrgAlias() == null || params.getOrgAlias().equals("")) {
            logger.error("missing api user");
            throw new AccellsAPIException("missing api user");
        }
        this.orgAlias = params.getOrgAlias();
        if (params.getIdpUrl() != null && !params.getIdpUrl().equals("")) {
            this.idpUrl = params.getIdpUrl();
        }
        if (params.getBase64EncodedSecretKey() != null && !params.getBase64EncodedSecretKey().equals("")) {
            this.apiSignature = new APISignature(params.getBase64EncodedSecretKey(), this.orgAlias, this.token);
        } else if (params.getKeystorePath() != null && !params.getKeystorePath().equals("")) {
            String keyStorePath = params.getKeystorePath();
            if (params.getKeyStorePassword() == null || params.getKeyStorePassword().equals("")) {
                logger.error("missing keyStore Password");
                throw new AccellsAPIException("missing keyStore Password");
            }
            String keyStorePassword = params.getKeyStorePassword();
            if (params.getSecretKeyAlias() == null || params.getSecretKeyAlias().equals("")) {
                logger.error("missing secret key alias");
                throw new AccellsAPIException("missing secret key alias");
            }
            String secretKeyAlias = params.getSecretKeyAlias();
            if (params.getSecretKeyPassword() == null || params.getSecretKeyPassword().equals("")) {
                logger.error("missing secret key password");
                throw new AccellsAPIException("missing secret key password");
            }
            String secretKeyPassword = params.getSecretKeyPassword();
            this.initAccellsAPISignatureFromKeystore(keyStorePath, keyStorePassword, secretKeyAlias, secretKeyPassword, this.orgAlias, this.token);
        } else if (params.getSignKey() != null) {
            SecretKey key = params.getSignKey();
            this.apiSignature = new APISignature(key, this.orgAlias, this.token);
        } else if (params.getApiSignature() != null) {
            this.apiSignature = params.getApiSignature();
        } else {
            throw new AccellsAPIException("missing Signature Key Information");
        }
        if (params.getLocale() != null && !params.getLocale().equals("")) {
            this.locale = params.getLocale();
        }
    }

    private void initAccellsAPISignatureFromKeystore(String keyStorePath, String keyStorePassword, String secretKeyAlias, String secretKeyPassword, String orgAlias, String token) throws AccellsAPIException {
        try {
            KeyStore keyStore = KeyStore.getInstance("JCEKS");
            keyStore.load(new FileInputStream(new File(keyStorePath)), keyStorePassword.toCharArray());
            SecretKey key = (SecretKey)keyStore.getKey(secretKeyAlias, secretKeyPassword.toCharArray());
            this.apiSignature = new APISignature(key, orgAlias, token);
        }
        catch (KeyStoreException e) {
            throw new AccellsAPIException("failed to init the keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AccellsAPIException("failed to init the keystore", e);
        }
        catch (CertificateException e) {
            throw new AccellsAPIException("failed to init the keystore", e);
        }
        catch (FileNotFoundException e) {
            throw new AccellsAPIException("failed to init the keystore", e);
        }
        catch (IOException e) {
            throw new AccellsAPIException("failed to init the keystore", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new AccellsAPIException("failed to get the key from the keystore", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParametersFromPropertiesFile(PingIdAPIConstructorParams params) throws IOException, AccellsAPIException {
        try (InputStream stream = null;){
            String key;
            Properties prop = new Properties();
            if (params.getAccellsPropertiesPath().equals("UseClasLoader")) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                stream = loader.getResourceAsStream("accells.properties");
            } else {
                stream = new FileInputStream(new File(params.getAccellsPropertiesPath()));
            }
            prop.load(stream);
            this.locale = prop.getProperty("locale");
            this.token = prop.getProperty("token");
            this.apiUserId = prop.getProperty("api_user_id");
            this.orgAlias = prop.getProperty("org_alias");
            this.idpUrl = prop.getProperty("idp_url");
            if (this.idpUrl == null || this.idpUrl.equalsIgnoreCase("")) {
                this.idpUrl = prop.getProperty("accells_url");
                if (this.idpUrl == null || this.idpUrl.equalsIgnoreCase("")) {
                    this.idpUrl = IDP_URL;
                }
            }
            this.useSignature = true;
            String tmp = prop.getProperty("use_signature");
            if (tmp == null || tmp.equalsIgnoreCase("")) {
                this.useSignature = Boolean.parseBoolean(tmp);
            }
            if ((key = prop.getProperty("use_base64_key")) != null && !key.equalsIgnoreCase("")) {
                this.apiSignature = new APISignature(key, this.orgAlias, this.token);
                return;
            }
            String keyStorePath = prop.getProperty("key_store");
            String keyStorePassword = prop.getProperty("key_store_password");
            String secretKeyAlias = prop.getProperty("key_alias");
            String secretKeyPassword = prop.getProperty("key_password_password");
            this.initAccellsAPISignatureFromKeystore(keyStorePath, keyStorePassword, secretKeyAlias, secretKeyPassword, this.orgAlias, this.token);
        }
    }

    @Override
    public AuthOnlineResponse authOnline(AuthOnlineRequest request) throws IOException, SignatureException {
        return this.authOnline(null, request);
    }

    @Override
    public AuthOnlineResponse authOnline(String managedOrgAlias, AuthOnlineRequest request) throws IOException, SignatureException {
        AccellsRequest<AuthOnlineRequest> reqObj = new AccellsRequest<AuthOnlineRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(AUTH_ONLINE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AuthOnlineResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AuthOnlineResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AuthOnlineResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AuthOnlineResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public StartAuthenticationResponse startAuthentication(StartAuthenticationRequest request) throws IOException, SignatureException {
        return this.startAuthentication(null, request);
    }

    @Override
    public StartAuthenticationResponse startAuthentication(String managedOrgAlias, StartAuthenticationRequest request) throws IOException, SignatureException {
        AccellsRequest<StartAuthenticationRequest> reqObj = new AccellsRequest<StartAuthenticationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_AUTHENTICATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<StartAuthenticationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (StartAuthenticationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (StartAuthenticationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<StartAuthenticationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CancelAuthenticationResponse cancelAuthentication(CancelAuthenticationRequest request) throws IOException, SignatureException {
        return this.cancelAuthentication(null, request);
    }

    @Override
    public CancelAuthenticationResponse cancelAuthentication(String managedOrgAlias, CancelAuthenticationRequest request) throws IOException, SignatureException {
        AccellsRequest<CancelAuthenticationRequest> reqObj = new AccellsRequest<CancelAuthenticationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CANCEL_AUTHENTICATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CancelAuthenticationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CancelAuthenticationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CancelAuthenticationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CancelAuthenticationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public PairMockupUserResponse pairMockupUser(PairMockupUserRequest request) throws IOException, SignatureException {
        return this.pairMockupUser(null, request);
    }

    @Override
    public PairMockupUserResponse pairMockupUser(String managedOrgAlias, PairMockupUserRequest request) throws IOException, SignatureException {
        AccellsRequest<PairMockupUserRequest> reqObj = new AccellsRequest<PairMockupUserRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(PAIR_MOCKUP_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<PairMockupUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (PairMockupUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (PairMockupUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<PairMockupUserResponse>>(){})).getResponseBody();
        }
    }

    public ZeroTouchSessionStatusResponse zeroTouchSessionStatus(ZeroTouchSessionStatusRequest request) throws IOException, SignatureException {
        AccellsRequest<ZeroTouchSessionStatusRequest> reqObj = new AccellsRequest<ZeroTouchSessionStatusRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ZERO_TOUCH_SESSION_STATUS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ZeroTouchSessionStatusResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ZeroTouchSessionStatusResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ZeroTouchSessionStatusResponse)e.getResponse().getEntity(ZeroTouchSessionStatusResponse.class);
        }
    }

    public SecureDataCaptureResponse secureDataCapture(SecureDataCaptureRequest request) throws IOException, SignatureException {
        AccellsRequest<SecureDataCaptureRequest> reqObj = new AccellsRequest<SecureDataCaptureRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SECURE_DATA_CAPTURE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<SecureDataCaptureResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (SecureDataCaptureResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SecureDataCaptureResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SecureDataCaptureResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AuthOfflineResponse authOffline(AuthOfflineRequest request) throws IOException {
        return this.authOffline(null, request);
    }

    @Override
    public AuthOfflineResponse authOffline(String managedOrgAlias, AuthOfflineRequest request) throws IOException {
        AccellsRequest<AuthOfflineRequest> reqObj = new AccellsRequest<AuthOfflineRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(AUTH_OFFLINE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AuthOfflineResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AuthOfflineResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AuthOfflineResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AuthOfflineResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AuthStatusResponse authStatus(AuthStatusRequest request) throws IOException {
        return this.authStatus(null, request);
    }

    @Override
    public AuthStatusResponse authStatus(String managedOrgAlias, AuthStatusRequest request) throws IOException {
        AccellsRequest<AuthStatusRequest> reqObj = new AccellsRequest<AuthStatusRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(AUTH_STATUS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AuthStatusResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AuthStatusResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AuthStatusResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AuthStatusResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public EditUserSPResponse editUserSP(EditUserSPRequest request) throws IOException, SignatureException {
        return this.editUserSP(null, request);
    }

    @Override
    public EditUserSPResponse editUserSP(String managedOrgAlias, EditUserSPRequest request) throws IOException, SignatureException {
        AccellsRequest<EditUserSPRequest> reqObj = new AccellsRequest<EditUserSPRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(EDIT_SERVICE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<EditUserSPResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (EditUserSPResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (EditUserSPResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<EditUserSPResponse>>(){})).getResponseBody();
        }
    }

    private RequestHeader initRequestHeader() {
        RequestHeader reqHeader = new RequestHeader();
        reqHeader.setApiUserId(this.apiUserId);
        reqHeader.setOrgAlias(this.orgAlias);
        reqHeader.setSecretKey(this.token);
        reqHeader.setTimestamp(this.getTimeStamp(System.currentTimeMillis()));
        reqHeader.setVersion("4.11.0");
        if (this.localeGetter != null) {
            reqHeader.setLocale(this.localeGetter.getLocale().toLanguageTag());
        } else {
            reqHeader.setLocale(this.locale);
        }
        return reqHeader;
    }

    @Override
    public AddUserSPResponse addUserSP(AddUserSPRequest request) throws IOException, SignatureException {
        return this.addUserSP(null, request);
    }

    @Override
    public AddUserSPResponse addUserSP(String managedOrgAlias, AddUserSPRequest request) throws IOException, SignatureException {
        AccellsRequest<AddUserSPRequest> reqObj = new AccellsRequest<AddUserSPRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_SERVICE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddUserSPResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddUserSPResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddUserSPResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddUserSPResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteUserSPResponse deleteUserSP(DeleteUserSPRequest request) throws IOException, SignatureException {
        return this.deleteUserSP(null, request);
    }

    @Override
    public DeleteUserSPResponse deleteUserSP(String managedOrgAlias, DeleteUserSPRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteUserSPRequest> reqObj = new AccellsRequest<DeleteUserSPRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_SERVICE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteUserSPResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteUserSPResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteUserSPResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteUserSPResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateAgentResponse CreateAgent(CreateAgentRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateAgentRequest> reqObj = new AccellsRequest<CreateAgentRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_AGENT_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateAgentResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateAgentResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateAgentResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateAgentResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateAgentResponse updateAgent(UpdateAgentRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateAgentRequest> reqObj = new AccellsRequest<UpdateAgentRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_SECRET_KEY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateAgentResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateAgentResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateAgentResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateAgentResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SuspendUserResponse suspendUser(SuspendUserRequest request) throws IOException, SignatureException {
        return this.suspendUser(null, request);
    }

    @Override
    public SuspendUserResponse suspendUser(String managedOrgAlias, SuspendUserRequest request) throws IOException, SignatureException {
        AccellsRequest<SuspendUserRequest> reqObj = new AccellsRequest<SuspendUserRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SUSPEND_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<SuspendUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (SuspendUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SuspendUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SuspendUserResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ActivateUserResponse activateUser(ActivateUserRequest request) throws IOException, SignatureException {
        return this.activateUser(null, request);
    }

    @Override
    public ActivateUserResponse activateUser(String managedOrgAlias, ActivateUserRequest request) throws IOException, SignatureException {
        AccellsRequest<ActivateUserRequest> reqObj = new AccellsRequest<ActivateUserRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ACTIVATE_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ActivateUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ActivateUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ActivateUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ActivateUserResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest request) throws IOException, SignatureException {
        return this.deleteUser(null, request);
    }

    @Override
    public DeleteUserResponse deleteUser(String managedOrgAlias, DeleteUserRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteUserRequest> reqObj = new AccellsRequest<DeleteUserRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteUserResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetUserResponse getUserDetails(GetUserRequest request) throws IOException, SignatureException {
        return this.getUserDetails(null, request);
    }

    @Override
    public GetUserResponse getUserDetails(String managedOrgAlias, GetUserRequest request) throws IOException, SignatureException {
        AccellsRequest<GetUserRequest> reqObj = new AccellsRequest<GetUserRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetUserResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateDeviceAttributeResponse updateDeviceAttribute(UpdateDeviceAttributeRequest request) throws IOException, SignatureException {
        return this.updateDeviceAttribute(null, request);
    }

    @Override
    public GetJobStatusResponse getJobStatus(GetJobStatusRequest request) throws IOException, SignatureException {
        return this.getJobStatus(null, request);
    }

    @Override
    public GetBulkJobStatusResponse getBulkJobStatus(GetBulkJobStatusRequest request) throws IOException, SignatureException {
        return this.getBulkJobStatus(null, request);
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) throws IOException, SignatureException {
        return this.createJob(null, request);
    }

    @Override
    public UpdateDeviceAttributeResponse updateDeviceAttribute(String managedOrgAlias, UpdateDeviceAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateDeviceAttributeRequest> reqObj = new AccellsRequest<UpdateDeviceAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_DEVICE_ATTRIBUTE).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateDeviceAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateDeviceAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateDeviceAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateDeviceAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public EditUserResponse editUser(Object request) throws IOException {
        return this.editUser(null, request);
    }

    @Override
    public EditUserResponse editUser(String managedOrgAlias, Object request) throws IOException {
        return this.invokeEditUser(managedOrgAlias, request, new AccellsRequest());
    }

    @Override
    public EditUserResponse editUser(EditUserRequest request) throws IOException, SignatureException {
        return this.editUser(null, request);
    }

    @Override
    public EditUserResponse editUser(String managedOrgAlias, EditUserRequest request) throws IOException, SignatureException {
        return this.invokeEditUser(managedOrgAlias, request, new AccellsRequest());
    }

    private EditUserResponse invokeEditUser(String managedOrgAlias, Object request, AccellsRequest reqObj) throws JsonProcessingException {
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(EDIT_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<EditUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (EditUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (EditUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<EditUserResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AddUserResponse addUser(Object request) throws IOException, SignatureException {
        return this.addUser(null, request);
    }

    @Override
    public AddUserResponse addUser(String managedOrgAlias, Object request) throws IOException {
        return this.invokeAddUser(managedOrgAlias, request, new AccellsRequest());
    }

    @Override
    public AddUserResponse addUser(AddUserRequest request) throws IOException, SignatureException {
        return this.addUser(null, request);
    }

    @Override
    public AddUserResponse addUser(String managedOrgAlias, AddUserRequest request) throws IOException, SignatureException {
        return this.invokeAddUser(managedOrgAlias, request, new AccellsRequest());
    }

    private AddUserResponse invokeAddUser(String managedOrgAlias, Object request, AccellsRequest reqObj) throws JsonProcessingException {
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        if (request instanceof AddUserRequest) {
            this.prepareAddUserServiceReq((AddUserRequest)request);
        }
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_USER_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddUserResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddUserResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddUserResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddUserResponse>>(){})).getResponseBody();
        }
    }

    private void prepareAddUserServiceReq(AddUserRequest request) {
        if (request.getUserServices() != null) {
            for (AddUserSPRequest addUserReq : request.getUserServices()) {
                addUserReq.setUserName(request.getUserName());
            }
        }
    }

    @Override
    public LoadPropertiesResponse loadProperties(LoadPropertiesRequest request) throws IOException, SignatureException {
        AccellsRequest<LoadPropertiesRequest> reqObj = new AccellsRequest<LoadPropertiesRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(LOAD_PROPERTIES_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<LoadPropertiesResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (LoadPropertiesResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (LoadPropertiesResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<LoadPropertiesResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetPropertiesResponse getProperties(GetPropertiesRequest request) throws IOException, SignatureException {
        request.setClientData("aaa");
        AccellsRequest<GetPropertiesRequest> reqObj = new AccellsRequest<GetPropertiesRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_PROPERTIES_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetPropertiesResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetPropertiesResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetPropertiesResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetPropertiesResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetAllServiceProvidersResponse getAllServiceProviders() throws IOException, SignatureException {
        return this.getAllServiceProviders(null);
    }

    @Override
    public GetAllServiceProvidersResponse getAllServiceProviders(String managedOrgAlias) throws IOException, SignatureException {
        GetAllServiceProvidersRequest request = new GetAllServiceProvidersRequest();
        request.setClientData("aaa");
        AccellsRequest<GetAllServiceProvidersRequest> reqObj = new AccellsRequest<GetAllServiceProvidersRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_SERVICE_PROVIDERS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetAllServiceProvidersResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetAllServiceProvidersResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetAllServiceProvidersResponse)e.getResponse().getEntity(GetAllServiceProvidersResponse.class);
        }
    }

    @Override
    public String getQRString(String activationCode) {
        return String.format("%s/QRRedirection?%s", this.idpUrl, new String(Base64.encode((String)new String("act_code=" + activationCode))));
    }

    @Override
    public CreateOrganizationTokensResponse createOrgTokens(CreateOrganizationTokensRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateOrganizationTokensRequest> reqObj = new AccellsRequest<CreateOrganizationTokensRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_ORG_TOKENS).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateOrganizationTokensResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateOrganizationTokensResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateOrganizationTokensResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateOrganizationTokensResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadOrganizationTokensResponse readOrgTokens(ReadOrganizationTokensRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadOrganizationTokensRequest> reqObj = new AccellsRequest<ReadOrganizationTokensRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_ORG_TOKENS).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadOrganizationTokensResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadOrganizationTokensResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadOrganizationTokensResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadOrganizationTokensResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteOrganizationTokensResponse deleteOrgTokens(DeleteOrganizationTokensRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteOrganizationTokensRequest> reqObj = new AccellsRequest<DeleteOrganizationTokensRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_ORG_TOKENS).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteOrganizationTokensResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteOrganizationTokensResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteOrganizationTokensResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteOrganizationTokensResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UnpairUsersByFingerPrintResponse unpairUsersByFp(UnpairUsersByFingerPrintRequest request) throws IOException, SignatureException {
        AccellsRequest<UnpairUsersByFingerPrintRequest> reqObj = new AccellsRequest<UnpairUsersByFingerPrintRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UNPAIR_USERS_BY_FP).type("application/json").post((GenericType)new GenericType<AccellsResponse<UnpairUsersByFingerPrintResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UnpairUsersByFingerPrintResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UnpairUsersByFingerPrintResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UnpairUsersByFingerPrintResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public RevokeOrganizationTokensResponse revokeOrgTokens(RevokeOrganizationTokensRequest request) throws IOException, SignatureException {
        AccellsRequest<RevokeOrganizationTokensRequest> reqObj = new AccellsRequest<RevokeOrganizationTokensRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(REVOKE_ORG_TOKENS).type("application/json").post((GenericType)new GenericType<AccellsResponse<RevokeOrganizationTokensResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (RevokeOrganizationTokensResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (RevokeOrganizationTokensResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<RevokeOrganizationTokensResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadOrgLocalizationResponse readOrgLocalization(ReadOrgLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadOrgLocalizationRequest> reqObj = new AccellsRequest<ReadOrgLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadOrgLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadOrgLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadOrgLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadOrgLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadBulkOrgLocalizationResponse readBulkOrgLocalization(ReadBulkOrgLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadBulkOrgLocalizationRequest> reqObj = new AccellsRequest<ReadBulkOrgLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_BULK_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadBulkOrgLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadBulkOrgLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadBulkOrgLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadBulkOrgLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateOrganizationLocalizationResponse createOrganizationLocalization(CreateOrganizationLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateOrganizationLocalizationRequest> reqObj = new AccellsRequest<CreateOrganizationLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateOrganizationLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateOrganizationLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateOrganizationLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateOrganizationLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateOrganizationLocalizationResponse updateOrganizationLocalization(CreateOrganizationLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateOrganizationLocalizationRequest> reqObj = new AccellsRequest<CreateOrganizationLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateOrganizationLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateOrganizationLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateOrganizationLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateOrganizationLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteOrganizationLocalizationResponse deleteOrganizationLocalization(DeleteOrganizationLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteOrganizationLocalizationRequest> reqObj = new AccellsRequest<DeleteOrganizationLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteOrganizationLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteOrganizationLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteOrganizationLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteOrganizationLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateBulkOrganizationLocalizationResponse updateBulkOrganizationLocalization(CreateBulkOrganizationLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateBulkOrganizationLocalizationRequest> reqObj = new AccellsRequest<CreateBulkOrganizationLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_BULK_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateBulkOrganizationLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateBulkOrganizationLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateBulkOrganizationLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateBulkOrganizationLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateBulkOrganizationLocalizationResponse createBulkOrganizationLocalization(CreateBulkOrganizationLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateBulkOrganizationLocalizationRequest> reqObj = new AccellsRequest<CreateBulkOrganizationLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_BULK_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateBulkOrganizationLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateBulkOrganizationLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateBulkOrganizationLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateBulkOrganizationLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteAllOrgLocalizationResponse deleteAllOrganizationLocalization(DeleteAllOrgLocalizationRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteAllOrgLocalizationRequest> reqObj = new AccellsRequest<DeleteAllOrgLocalizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_ALL_ORG_LOCALIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteAllOrgLocalizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteAllOrgLocalizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteAllOrgLocalizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteAllOrgLocalizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateOrganizationResponse createOrganization(CreateOrganizationRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateOrganizationRequest> reqObj = new AccellsRequest<CreateOrganizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_ORGANIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateOrganizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateOrganizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateOrganizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateOrganizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public BaseResponseBody createPingOnePingIdMapping(LinkNewPingOneToPingIDRequest request) throws IOException, SignatureException {
        AccellsRequest<LinkNewPingOneToPingIDRequest> reqObj = new AccellsRequest<LinkNewPingOneToPingIDRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_PID_P1_MAPPING).type("application/json").post((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (BaseResponseBody)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (BaseResponseBody)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){})).getResponseBody();
        }
    }

    @Override
    public BaseResponseBody unlinkPingOnePingIdMapping(UnlinkPingOneToPingIDRequest request) throws IOException, SignatureException {
        AccellsRequest<UnlinkPingOneToPingIDRequest> reqObj = new AccellsRequest<UnlinkPingOneToPingIDRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UNLINK_PID_P1_MAPPING).type("application/json").post((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (BaseResponseBody)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (BaseResponseBody)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){})).getResponseBody();
        }
    }

    @Override
    public BaseResponseBody linkNewPingIDToPingOne(LinkNewPingIDToPingOneRequest request) throws IOException {
        AccellsRequest<LinkNewPingIDToPingOneRequest> reqObj = new AccellsRequest<LinkNewPingIDToPingOneRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(LINK_NEW_PID_TO_P1).type("application/json").post((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (BaseResponseBody)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (BaseResponseBody)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<BaseResponseBody>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateOrganizationResponse updateOrganization(UpdateOrganizationRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateOrganizationRequest> reqObj = new AccellsRequest<UpdateOrganizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_ORGANIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateOrganizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateOrganizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateOrganizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateOrganizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateOrganizationAttributeResponse updateOrganizationAttribute(UpdateOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateOrganizationAttributeRequest> reqObj = new AccellsRequest<UpdateOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateBulkOrganizationAttributeResponse updateBulkOrganizationAttribute(UpdateBulkOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateBulkOrganizationAttributeRequest> reqObj = new AccellsRequest<UpdateBulkOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_BULK_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateBulkOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateBulkOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateBulkOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateBulkOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteOrganizationAttributeResponse deleteOrganizationAttribute(DeleteOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteOrganizationAttributeRequest> reqObj = new AccellsRequest<DeleteOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteBulkOrganizationAttributeResponse deleteBulkOrganizationAttribute(DeleteBulkOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteBulkOrganizationAttributeRequest> reqObj = new AccellsRequest<DeleteBulkOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_BULK_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteBulkOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteBulkOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteBulkOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteBulkOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadOrganizationResponse readOrganization(ReadOrganizationRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadOrganizationRequest> reqObj = new AccellsRequest<ReadOrganizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_ORGANIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadOrganizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadOrganizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            AccellsResponse response = (AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadOrganizationResponse>>(){});
            return (ReadOrganizationResponse)response.getResponseBody();
        }
    }

    @Override
    public ReadOrganizationAttributeResponse readOrganizationAttribute(ReadOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadOrganizationAttributeRequest> reqObj = new AccellsRequest<ReadOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadBulkOrganizationAttributeResponse readBulkOrganizationAttribute(ReadBulkOrganizationAttributeRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadBulkOrganizationAttributeRequest> reqObj = new AccellsRequest<ReadBulkOrganizationAttributeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_BULK_ORGANIZATION_ATTR_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadBulkOrganizationAttributeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadBulkOrganizationAttributeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadBulkOrganizationAttributeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadBulkOrganizationAttributeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetActivationCodeResponse getActivationCode(GetActivationCodeRequest request) throws IOException, SignatureException {
        return this.getActivationCode(null, request);
    }

    @Override
    public GetActivationCodeResponse getActivationCode(String managedOrgAlias, GetActivationCodeRequest request) throws IOException, SignatureException {
        AccellsRequest<GetActivationCodeRequest> reqObj = new AccellsRequest<GetActivationCodeRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_ACTIVATION_CODE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetActivationCodeResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetActivationCodeResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetActivationCodeResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetActivationCodeResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public BypassResponse userBypass(String managedOrgAlias, BypassRequest request) throws IOException, SignatureException {
        AccellsRequest<BypassRequest> reqObj = new AccellsRequest<BypassRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(USER_BYPASS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<BypassResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (BypassResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (BypassResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<BypassResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public BypassResponse userBypass(BypassRequest request) throws IOException, SignatureException {
        return this.userBypass(null, request);
    }

    @Override
    public PairingStatusResponse getPairingStatus(PairingStatusRequest request) throws IOException, SignatureException {
        return this.getPairingStatus(null, request);
    }

    @Override
    public PairingStatusResponse getPairingStatus(String managedOrgAlias, PairingStatusRequest request) throws IOException, SignatureException {
        AccellsRequest<PairingStatusRequest> reqObj = new AccellsRequest<PairingStatusRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(PAIRING_STATUS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<PairingStatusResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (PairingStatusResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (PairingStatusResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<PairingStatusResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public BypassResponse removeUserBypass(String managedOrgAlias, RemoveBypassRequest request) throws IOException, SignatureException {
        return this.userBypass(managedOrgAlias, new BypassRequest(request.getUserName(), request.getSpAliases(), null, request.getAdminId()));
    }

    @Override
    public BypassResponse removeUserBypass(RemoveBypassRequest request) throws IOException, SignatureException {
        return this.removeUserBypass(null, request);
    }

    @Override
    public UnpairDeviceResponse unpairDevice(String managedOrgAlias, UnpairDeviceRequest request) throws IOException, SignatureException {
        AccellsRequest<UnpairDeviceRequest> reqObj = new AccellsRequest<UnpairDeviceRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UNPAIR_DEVICE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UnpairDeviceResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UnpairDeviceResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UnpairDeviceResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UnpairDeviceResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UnpairDeviceResponse unpairDevice(UnpairDeviceRequest request) throws IOException, SignatureException {
        return this.unpairDevice(null, request);
    }

    @Override
    public StartSmsPairingResponse startSmsPairing(StartSmsPairingRequest request) throws IOException, SignatureException {
        return this.startSmsPairing(null, request);
    }

    @Override
    public StartSmsPairingResponse startSmsPairing(String managedOrgAlias, StartSmsPairingRequest request) throws IOException, SignatureException {
        AccellsRequest<StartSmsPairingRequest> reqObj = new AccellsRequest<StartSmsPairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_SMS_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<StartSmsPairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (StartSmsPairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (StartSmsPairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<StartSmsPairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public StartOfflinePairingResponse startOfflinePairing(StartOfflinePairingRequest request) throws IOException, SignatureException {
        return this.startOfflinePairing(null, request);
    }

    @Override
    public AuthenticatorAppStartPairingResponse startAuthenticatorAppPairing(AuthenticatorAppStartPairingRequest request) throws IOException, SignatureException {
        return this.startAuthenticatorAppPairing(null, request);
    }

    @Override
    public AuthenticatorAppStartPairingResponse startAuthenticatorAppPairing(String managedOrgAlias, AuthenticatorAppStartPairingRequest request) throws IOException, SignatureException {
        AccellsRequest<AuthenticatorAppStartPairingRequest> reqObj = new AccellsRequest<AuthenticatorAppStartPairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_AUTHENTICATOR_APP_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AuthenticatorAppStartPairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AuthenticatorAppStartPairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AuthenticatorAppStartPairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AuthenticatorAppStartPairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public StartOfflinePairingResponse startOfflinePairing(String managedOrgAlias, StartOfflinePairingRequest request) throws IOException, SignatureException {
        AccellsRequest<StartOfflinePairingRequest> reqObj = new AccellsRequest<StartOfflinePairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_OFFLINE_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<StartOfflinePairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (StartOfflinePairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (StartOfflinePairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<StartOfflinePairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public OfflinePairingResponse offlinePairing(OfflinePairingRequest request) throws IOException, SignatureException {
        return this.offlinePairing(null, request);
    }

    @Override
    public OfflinePairingResponse offlinePairing(String managedOrgAlias, OfflinePairingRequest request) throws IOException, SignatureException {
        AccellsRequest<OfflinePairingRequest> reqObj = new AccellsRequest<OfflinePairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(OFFLINE_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<OfflinePairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (OfflinePairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (OfflinePairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<OfflinePairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public FinalizeSmsPairingResponse finalizeSmsPairing(FinalizeSmsPairingRequest request) throws IOException, SignatureException {
        return this.finalizeSmsPairing(null, request);
    }

    @Override
    public FinalizeSmsPairingResponse finalizeSmsPairing(String managedOrgAlias, FinalizeSmsPairingRequest request) throws IOException, SignatureException {
        AccellsRequest<FinalizeSmsPairingRequest> reqObj = new AccellsRequest<FinalizeSmsPairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINALIZING_SMS_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<FinalizeSmsPairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (FinalizeSmsPairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (FinalizeSmsPairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<FinalizeSmsPairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public FinalizeOfflinePairingResponse finalizeOfflinePairing(FinalizeOfflinePairingRequest request) throws IOException, SignatureException {
        return this.finalizeOfflinePairing(null, request);
    }

    @Override
    public FinalizeOfflinePairingResponse finalizeAuthenticatorAppPairing(FinalizeOfflinePairingRequest request) throws IOException, SignatureException {
        return this.finalizeAuthenticatorAppPairing(null, request);
    }

    @Override
    public FinalizeOfflinePairingResponse finalizeAuthenticatorAppPairing(String managedOrgAlias, FinalizeOfflinePairingRequest request) throws IOException, SignatureException {
        AccellsRequest<FinalizeOfflinePairingRequest> reqObj = new AccellsRequest<FinalizeOfflinePairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINALIZING_AUTHENTICATOR_APP_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<FinalizeOfflinePairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (FinalizeOfflinePairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (FinalizeOfflinePairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<FinalizeOfflinePairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public FinalizeOfflinePairingResponse finalizeOfflinePairing(String managedOrgAlias, FinalizeOfflinePairingRequest request) throws IOException, SignatureException {
        AccellsRequest<FinalizeOfflinePairingRequest> reqObj = new AccellsRequest<FinalizeOfflinePairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINALIZING_OFFLINE_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<FinalizeOfflinePairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (FinalizeOfflinePairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (FinalizeOfflinePairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<FinalizeOfflinePairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    @Deprecated
    public void destory() {
        this.destroy();
    }

    public void destroy() {
        if (this.jerseyClient != null) {
            this.jerseyClient.destroy();
        }
        if (this.unsignedResponseClient != null) {
            this.unsignedResponseClient.destroy();
        }
    }

    @Override
    public DeleteAgentResponse deleteAgent(DeleteAgentRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteAgentRequest> reqObj = new AccellsRequest<DeleteAgentRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_AGENT_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteAgentResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteAgentResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteAgentResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteAgentResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UnpairOrganizationUsersResponse unpairOrganizationUsers(UnpairOrganizationUsersRequest request) throws IOException, SignatureException {
        AccellsRequest<UnpairOrganizationUsersRequest> reqObj = new AccellsRequest<UnpairOrganizationUsersRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UNPAIR_ORGANIZATION_USERS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UnpairOrganizationUsersResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UnpairOrganizationUsersResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UnpairOrganizationUsersResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UnpairOrganizationUsersResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AddFeatureFlaggingResponse addFeatureFlagging(AddFeatureFlaggingRequest request) throws IOException, SignatureException {
        AccellsRequest<AddFeatureFlaggingRequest> reqObj = new AccellsRequest<AddFeatureFlaggingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_FEATURE_FLAG_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddFeatureFlaggingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddFeatureFlaggingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddFeatureFlaggingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddFeatureFlaggingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadFeatureFlaggingResponse readFeatureFlagging(ReadFeatureFlaggingRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadFeatureFlaggingRequest> reqObj = new AccellsRequest<ReadFeatureFlaggingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_FEATURE_FLAG_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadFeatureFlaggingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadFeatureFlaggingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadFeatureFlaggingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadFeatureFlaggingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteFeatureFlaggingResponse deleteFeatureFlagging(DeleteFeatureFlaggingRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteFeatureFlaggingRequest> reqObj = new AccellsRequest<DeleteFeatureFlaggingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_FEATURE_FLAG_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteFeatureFlaggingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteFeatureFlaggingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteFeatureFlaggingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteFeatureFlaggingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public HeartbeatResponse sendHeartbeat(HeartbeatRequest request) throws IOException {
        AccellsRequest<HeartbeatRequest> reqObj = new AccellsRequest<HeartbeatRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(HEARTBEAT_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<HeartbeatResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (HeartbeatResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (HeartbeatResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<HeartbeatResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AgentAuthResponse agentAuth(AgentAuthRequest request) throws IOException {
        AccellsRequest<AgentAuthRequest> reqObj = new AccellsRequest<AgentAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        String header = this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(AGENT_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AgentAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AgentAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AgentAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AgentAuthResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public PairYubiKeyResponse pairYubiKey(PairYubiKeyRequest request) throws IOException {
        return this.pairYubiKey(null, request);
    }

    @Override
    public PairYubiKeyResponse pairYubiKey(String managedOrgAlias, PairYubiKeyRequest request) throws IOException {
        AccellsRequest<PairYubiKeyRequest> reqObj = new AccellsRequest<PairYubiKeyRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(PAIR_YUBIKEY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<PairYubiKeyResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (PairYubiKeyResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (PairYubiKeyResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<PairYubiKeyResponse>>(){})).getResponseBody();
        }
    }

    private String getTimeStamp(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        return sdf.format(new Date(time));
    }

    @Override
    public DeleteOrganizationResponse deleteOrganization(DeleteOrganizationRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteOrganizationRequest> reqObj = new AccellsRequest<DeleteOrganizationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_ORGANIZATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteOrganizationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteOrganizationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteOrganizationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteOrganizationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateAuthenticationPolicyResponse createAuthenticationPolicy(String managedOrgAlias, CreateAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<CreateAuthenticationPolicyRequest> reqObj = new AccellsRequest<CreateAuthenticationPolicyRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_AUTHENTICATION_POLICY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateAuthenticationPolicyResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateAuthenticationPolicyResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateAuthenticationPolicyResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateAuthenticationPolicyResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateBulkAuthenticationPolicyResponse createBulkAuthenticationPolicy(String managedOrgAlias, CreateBulkAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<CreateBulkAuthenticationPolicyRequest> reqObj = new AccellsRequest<CreateBulkAuthenticationPolicyRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_BULK_AUTHENTICATION_POLICY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateBulkAuthenticationPolicyResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateBulkAuthenticationPolicyResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateBulkAuthenticationPolicyResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateBulkAuthenticationPolicyResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateBulkAuthenticationPolicyResponse createBulkAuthenticationPolicy(CreateBulkAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        return this.createBulkAuthenticationPolicy(null, policyRequest);
    }

    @Override
    public ReadBulkAuthenticationPolicyResponse readBulkAuthenticationPolicy(ReadBulkAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        return this.readBulkAuthenticationPolicy(null, policyRequest);
    }

    @Override
    public GetDeviceModelsResponse getDeviceModels(String managedOrgAlias, GetDeviceModelsRequest request) throws IOException, SignatureException {
        AccellsRequest<GetDeviceModelsRequest> reqObj = new AccellsRequest<GetDeviceModelsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_DEVICE_MODELS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetDeviceModelsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetDeviceModelsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetDeviceModelsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetDeviceModelsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetDeviceModelsResponse getDeviceModels(GetDeviceModelsRequest request) throws IOException, SignatureException {
        return this.getDeviceModels(null, request);
    }

    @Override
    public CreateAuthenticationPolicyResponse createAuthenticationPolicy(CreateAuthenticationPolicyRequest policyRequest) throws JsonGenerationException, JsonMappingException, IOException, SignatureException {
        return this.createAuthenticationPolicy(null, policyRequest);
    }

    @Override
    public ReadAuthenticationPolicyResponse readAuthenticationPolicy(String managedOrgAlias, ReadAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<ReadAuthenticationPolicyRequest> reqObj = new AccellsRequest<ReadAuthenticationPolicyRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_AUTHENTICATION_POLICY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadAuthenticationPolicyResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadAuthenticationPolicyResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadAuthenticationPolicyResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadAuthenticationPolicyResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadBulkAuthenticationPolicyResponse readBulkAuthenticationPolicy(String managedOrgAlias, ReadBulkAuthenticationPolicyRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<ReadBulkAuthenticationPolicyRequest> reqObj = new AccellsRequest<ReadBulkAuthenticationPolicyRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_BULK_AUTHENTICATION_POLICY_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadBulkAuthenticationPolicyResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadBulkAuthenticationPolicyResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadBulkAuthenticationPolicyResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadBulkAuthenticationPolicyResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadAuthenticationPolicyResponse readAuthenticationPolicy(ReadAuthenticationPolicyRequest policyRequest) throws JsonGenerationException, JsonMappingException, IOException, SignatureException {
        return this.readAuthenticationPolicy(null, policyRequest);
    }

    @Override
    public CreateGeoFenceResponse createGeoFence(String managedOrgAlias, CreateGeoFenceRequest geoFenceRequest) throws IOException, SignatureException {
        AccellsRequest<CreateGeoFenceRequest> reqObj = new AccellsRequest<CreateGeoFenceRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(geoFenceRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_GEO_FENCE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateGeoFenceResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateGeoFenceResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateGeoFenceResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateGeoFenceResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateGeoFenceResponse createGeoFence(CreateGeoFenceRequest geoFenceRequest) throws IOException, SignatureException {
        return this.createGeoFence(null, geoFenceRequest);
    }

    @Override
    public CreateDeviceRequirementsResponse createDeviceRequirements(String managedOrgAlias, CreateDeviceRequirementsRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<CreateDeviceRequirementsRequest> reqObj = new AccellsRequest<CreateDeviceRequirementsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_DEVICE_REQUIREMENTS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateDeviceRequirementsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateDeviceRequirementsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateDeviceRequirementsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateDeviceRequirementsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateDeviceRequirementsResponse createDeviceRequirements(CreateDeviceRequirementsRequest policyRequest) throws IOException, SignatureException {
        return this.createDeviceRequirements(null, policyRequest);
    }

    @Override
    public CreateBulkDeviceRequirementsResponse createBulkDeviceRequirements(String managedOrgAlias, CreateBulkDeviceRequirementsRequest policyRequest) throws IOException, SignatureException {
        AccellsRequest<CreateBulkDeviceRequirementsRequest> reqObj = new AccellsRequest<CreateBulkDeviceRequirementsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(policyRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_BULK_DEVICE_REQUIREMENTS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateBulkDeviceRequirementsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreateBulkDeviceRequirementsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateBulkDeviceRequirementsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateBulkDeviceRequirementsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadDeviceRequirementsResponse readDeviceRequirements(String managedOrgAlias, ReadDeviceRequirementsRequest readDeviceRequirementsRequest) throws IOException, SignatureException {
        AccellsRequest<ReadDeviceRequirementsRequest> reqObj = new AccellsRequest<ReadDeviceRequirementsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(readDeviceRequirementsRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_DEVICE_REQUIREMENTS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadDeviceRequirementsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadDeviceRequirementsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadDeviceRequirementsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadDeviceRequirementsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadDeviceRequirementsResponse readDeviceRequirements(ReadDeviceRequirementsRequest policyRequest) throws IOException, SignatureException {
        return this.readDeviceRequirements(null, policyRequest);
    }

    @Override
    public ReadGeoFenceResponse readGeoFence(String managedOrgAlias, ReadGeoFenceRequest geoFenceRequest) throws IOException, SignatureException {
        AccellsRequest<ReadGeoFenceRequest> reqObj = new AccellsRequest<ReadGeoFenceRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(geoFenceRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_GEO_FENCE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadGeoFenceResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadGeoFenceResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadGeoFenceResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadGeoFenceResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadGeoFenceResponse readGeoFence(ReadGeoFenceRequest geoFenceRequest) throws IOException, SignatureException {
        return this.readGeoFence(null, geoFenceRequest);
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public PolicyMigrationResponse policyMigration(PolicyMigrationRequest request) throws IOException, SignatureException {
        AccellsRequest<PolicyMigrationRequest> reqObj = new AccellsRequest<PolicyMigrationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(POLICY_MIGRATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<PolicyMigrationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (PolicyMigrationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (PolicyMigrationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<PolicyMigrationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public OrgMigrationResponse orgMigration(OrgMigrationRequest request) throws IOException, SignatureException {
        AccellsRequest<OrgMigrationRequest> reqObj = new AccellsRequest<OrgMigrationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ORG_MIGRATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<OrgMigrationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (OrgMigrationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (OrgMigrationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<OrgMigrationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreatePairingConditionsResponse createPairingConditions(String managedOrgAlias, CreatePairingConditionsRequest createPairingConditionsRequest) throws IOException, SignatureException {
        AccellsRequest<CreatePairingConditionsRequest> reqObj = new AccellsRequest<CreatePairingConditionsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(createPairingConditionsRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_PAIRING_CONDITIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreatePairingConditionsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (CreatePairingConditionsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreatePairingConditionsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreatePairingConditionsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadPairingConditionsResponse readPairingConditions(String managedOrgAlias, ReadPairingConditionsRequest readPairingConditionsRequest) throws IOException, SignatureException {
        AccellsRequest<ReadPairingConditionsRequest> reqObj = new AccellsRequest<ReadPairingConditionsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(readPairingConditionsRequest);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_PAIRING_CONDITIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadPairingConditionsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadPairingConditionsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code =" + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadPairingConditionsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadPairingConditionsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreatePairingConditionsResponse createPairingConditions(CreatePairingConditionsRequest createPairingConditionsRequest) throws IOException, SignatureException {
        return this.createPairingConditions(null, createPairingConditionsRequest);
    }

    @Override
    public ReadPairingConditionsResponse readPairingConditions(ReadPairingConditionsRequest readPairingConditionsRequest) throws IOException, SignatureException {
        return this.readPairingConditions(null, readPairingConditionsRequest);
    }

    @Override
    public GetDeviceOSVersionsResponse getDeviceOSVersions(String managedOrgAlias, GetDeviceOSVersionsRequest request) throws IOException, SignatureException {
        AccellsRequest<GetDeviceOSVersionsRequest> reqObj = new AccellsRequest<GetDeviceOSVersionsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_DEVICE_OS_VERSIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetDeviceOSVersionsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetDeviceOSVersionsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetDeviceOSVersionsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetDeviceOSVersionsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetAppVersionsResponse getAppVersions(String managedOrgAlias, GetAppVersionsRequest request) throws IOException {
        AccellsRequest<GetAppVersionsRequest> reqObj = new AccellsRequest<GetAppVersionsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_APP_VERSIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetAppVersionsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetAppVersionsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetAppVersionsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetAppVersionsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetApplicationsResponse getApplications(String managedOrgAlias, GetApplicationsRequest request) throws IOException, SignatureException {
        AccellsRequest<GetApplicationsRequest> reqObj = new AccellsRequest<GetApplicationsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_APPLICATIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetApplicationsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetApplicationsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetApplicationsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetApplicationsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetDeviceOSVersionsResponse getDeviceOSVersions(GetDeviceOSVersionsRequest request) throws IOException, SignatureException {
        return this.getDeviceOSVersions(null, request);
    }

    @Override
    public GetAppVersionsResponse getAppVersions(GetAppVersionsRequest request) throws IOException {
        return this.getAppVersions(null, request);
    }

    @Override
    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws IOException, SignatureException {
        return this.getApplications(null, request);
    }

    @Override
    public AddApplicationResponse addApplication(AddApplicationRequest request) throws IOException, SignatureException {
        return this.addApplication(null, request);
    }

    @Override
    public DeleteApplicationsResponse deleteApplications(DeleteApplicationsRequest request) throws IOException, SignatureException {
        return this.deleteApplications(null, request);
    }

    @Override
    public UpdateApplicationResponse updateApplications(UpdateApplicationsRequest request) throws IOException, SignatureException {
        return this.updateApplications(null, request);
    }

    @Override
    public AddApplicationResponse addApplication(String managedOrgAlias, AddApplicationRequest request) throws IOException, SignatureException {
        AccellsRequest<AddApplicationRequest> reqObj = new AccellsRequest<AddApplicationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_APPLICATION_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddApplicationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddApplicationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddApplicationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddApplicationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteApplicationsResponse deleteApplications(String managedOrgAlias, DeleteApplicationsRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteApplicationsRequest> reqObj = new AccellsRequest<DeleteApplicationsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_APPLICATIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteApplicationsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteApplicationsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteApplicationsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteApplicationsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public UpdateApplicationResponse updateApplications(String managedOrgAlias, UpdateApplicationsRequest request) throws IOException, SignatureException {
        AccellsRequest<UpdateApplicationsRequest> reqObj = new AccellsRequest<UpdateApplicationsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(UPDATE_APPLICATIONS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<UpdateApplicationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (UpdateApplicationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (UpdateApplicationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<UpdateApplicationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AddOrganizationEmailTemplateResponse addOrganizationEmailTemplate(AddOrganizationEmailTemplateRequest request) throws IOException, SignatureException {
        AccellsRequest<AddOrganizationEmailTemplateRequest> reqObj = new AccellsRequest<AddOrganizationEmailTemplateRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            this.webResource.path(ADD_ORGANIZATION_EMAIL_TEMPLATE_URL);
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_ORGANIZATION_EMAIL_TEMPLATE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddOrganizationEmailTemplateResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddOrganizationEmailTemplateResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddOrganizationEmailTemplateResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddOrganizationEmailTemplateResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public RemoveOrganizationEmailTemplateResponse removeOrganizationEmailTemplate(RemoveOrganizationEmailTemplateRequest request) throws IOException, SignatureException {
        AccellsRequest<RemoveOrganizationEmailTemplateRequest> reqObj = new AccellsRequest<RemoveOrganizationEmailTemplateRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(REMOVE_ORGANIZATION_EMAIL_TEMPLATE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<RemoveOrganizationEmailTemplateResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (RemoveOrganizationEmailTemplateResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (RemoveOrganizationEmailTemplateResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<RemoveOrganizationEmailTemplateResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadOrganizationEmailTemplateResponse readOrganizationEmailTemplate(ReadOrganizationEmailTemplateRequest request) throws IOException, SignatureException {
        AccellsRequest<ReadOrganizationEmailTemplateRequest> reqObj = new AccellsRequest<ReadOrganizationEmailTemplateRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_ORGANIZATION_EMAIL_TEMPLATE_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadOrganizationEmailTemplateResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadOrganizationEmailTemplateResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadOrganizationEmailTemplateResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadOrganizationEmailTemplateResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public AddSessionDataResponse addSessionData(AddSessionDataRequest request) throws IOException, SignatureException {
        AccellsRequest<AddSessionDataRequest> reqObj = new AccellsRequest<AddSessionDataRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ADD_USER_SESSION_DATA).type("application/json").post((GenericType)new GenericType<AccellsResponse<AddSessionDataResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (AddSessionDataResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (AddSessionDataResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<AddSessionDataResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetSessionDataResponse getSessionData(GetSessionDataRequest request) throws IOException, SignatureException {
        AccellsRequest<GetSessionDataRequest> reqObj = new AccellsRequest<GetSessionDataRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_USER_SESSION_DATA).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetSessionDataResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (GetSessionDataResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetSessionDataResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetSessionDataResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteSessionDataResponse deleteSessionData(DeleteSessionDataRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteSessionDataRequest> reqObj = new AccellsRequest<DeleteSessionDataRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_USER_SESSION_DATA).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteSessionDataResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (DeleteSessionDataResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteSessionDataResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteSessionDataResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReportFraudResponse reportFraud(ReportFraudRequest request) throws IOException, SignatureException {
        AccellsRequest<ReportFraudRequest> reqObj = new AccellsRequest<ReportFraudRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(REPORT_FRAUD).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReportFraudResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReportFraudResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReportFraudResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReportFraudResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public InputStream getOrgReport(String orgAlias, GetOrgReportRequest request) throws IOException {
        AccellsRequest<GetOrgReportRequest> reqObj = new AccellsRequest<GetOrgReportRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setBehalfOfOrgAlias(orgAlias);
        reqObj.setReqBody(request);
        InputStream response = (InputStream)((WebResource.Builder)this.unsignedResponseResource.path(GET_ORG_REPORT_URL).type("application/json").accept(new String[]{"application/octet-stream"})).post(InputStream.class, (Object)this.mapper.writeValueAsString(reqObj));
        return response;
    }

    @Override
    public InputStream getOrgReport(GetOrgReportRequest request) throws IOException {
        return this.getOrgReport(null, request);
    }

    @Override
    public ResyncOathTokenResponse resyncOathToken(ResyncOathTokenRequest request) throws IOException {
        return this.resyncOathToken(null, request);
    }

    @Override
    public ResyncOathTokenResponse resyncOathToken(String managedOrgAlias, ResyncOathTokenRequest request) throws IOException {
        AccellsRequest<ResyncOathTokenRequest> reqObj = new AccellsRequest<ResyncOathTokenRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        this.mapper.writeValueAsString(reqObj.getReqHeader());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(RESYNC_OATH_TOKEN_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<ResyncOathTokenResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ResyncOathTokenResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ResyncOathTokenResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ResyncOathTokenResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateJobResponse createJob(String orgAlias, CreateJobRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateJobRequest> jobRequest = new AccellsRequest<CreateJobRequest>();
        jobRequest.setReqHeader(this.initRequestHeader());
        jobRequest.setReqBody(request);
        jobRequest.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse createJonResponse = (AccellsResponse)this.webResource.path(CREATE_ORG_REPORT_JOB_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateJobResponse>>(){}, (Object)this.mapper.writeValueAsString(jobRequest));
            return (CreateJobResponse)createJonResponse.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateJobResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateJobResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public OrgReportMigrationResponse orgReportMigration(OrgReportMigrationRequest request) throws IOException, SignatureException {
        AccellsRequest<OrgReportMigrationRequest> reqObj = new AccellsRequest<OrgReportMigrationRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ORG_REPORT_MIGRATION).type("application/json").post((GenericType)new GenericType<AccellsResponse<OrgReportMigrationResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (OrgReportMigrationResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (OrgReportMigrationResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<OrgReportMigrationResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetJobStatusResponse getJobStatus(String orgAlias, GetJobStatusRequest request) throws IOException, SignatureException {
        AccellsRequest<GetJobStatusRequest> req = new AccellsRequest<GetJobStatusRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        req.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_ORG_REPORT_JOB_STATUS_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetJobStatusResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (GetJobStatusResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetJobStatusResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetJobStatusResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetBulkJobStatusResponse getBulkJobStatus(String orgAlias, GetBulkJobStatusRequest request) throws IOException, SignatureException {
        AccellsRequest<GetBulkJobStatusRequest> req = new AccellsRequest<GetBulkJobStatusRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        req.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_BULK_JOB_STATUS).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetBulkJobStatusResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (GetBulkJobStatusResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetBulkJobStatusResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetBulkJobStatusResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SendDownloadAndPairMailResponse sendDownloadAndPairMail(SendDownloadAndPairMailRequest request) throws IOException, SignatureException {
        AccellsRequest<SendDownloadAndPairMailRequest> req = new AccellsRequest<SendDownloadAndPairMailRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SEND_MAIL_DOWNLOAD_PAIR).type("application/json").post((GenericType)new GenericType<AccellsResponse<SendDownloadAndPairMailResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (SendDownloadAndPairMailResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SendDownloadAndPairMailResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SendDownloadAndPairMailResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SendAuthenticationMailResponse sendAuthenticationMail(SendAuthenticationMailRequest request) throws IOException, SignatureException {
        AccellsRequest<SendAuthenticationMailRequest> req = new AccellsRequest<SendAuthenticationMailRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SEND_MAIL_AUTHENTICATION).type("application/json").post((GenericType)new GenericType<AccellsResponse<SendAuthenticationMailResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (SendAuthenticationMailResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SendAuthenticationMailResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SendAuthenticationMailResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SendOnBoardingMailResponse sendOnBoardingMail(SendOnBoardingMailRequest request) throws IOException, SignatureException {
        AccellsRequest<SendOnBoardingMailRequest> req = new AccellsRequest<SendOnBoardingMailRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SEND_MAIL_ON_BOARDING).type("application/json").post((GenericType)new GenericType<AccellsResponse<SendOnBoardingMailResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (SendOnBoardingMailResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SendOnBoardingMailResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SendOnBoardingMailResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SendFraudMailResponse sendFraudMail(SendFraudMailRequest request) throws IOException, SignatureException {
        AccellsRequest<SendFraudMailRequest> req = new AccellsRequest<SendFraudMailRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SEND_MAIL_FRAUD).type("application/json").post((GenericType)new GenericType<AccellsResponse<SendFraudMailResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (SendFraudMailResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SendFraudMailResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SendFraudMailResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public VerifyOrgKeysPermissionsResponse verifyOrgKeysPermissions(VerifyOrgKeysPermissionsRequest request) throws IOException, SignatureException {
        AccellsRequest<VerifyOrgKeysPermissionsRequest> req = new AccellsRequest<VerifyOrgKeysPermissionsRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(VERIFY_ORGKEYS_PERMISSIONS).type("application/json").post((GenericType)new GenericType<AccellsResponse<VerifyOrgKeysPermissionsResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (VerifyOrgKeysPermissionsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (VerifyOrgKeysPermissionsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<VerifyOrgKeysPermissionsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public VerifyJwtSignatureResponse verifyJwtSignature(VerifyJwtSignatureRequest request) throws IOException, SignatureException {
        AccellsRequest<VerifyJwtSignatureRequest> req = new AccellsRequest<VerifyJwtSignatureRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(VERIFY_JWT_SIGNATURE).type("application/json").post((GenericType)new GenericType<AccellsResponse<VerifyJwtSignatureResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (VerifyJwtSignatureResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (VerifyJwtSignatureResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<VerifyJwtSignatureResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateJwsResponse createJws(CreateJwsRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateJwsRequest> req = new AccellsRequest<CreateJwsRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_JWS).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateJwsResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (CreateJwsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateJwsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateJwsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetOrgKeysResponse getOrgKeys(GetOrgKeysRequest request) throws IOException, SignatureException {
        AccellsRequest<GetOrgKeysRequest> req = new AccellsRequest<GetOrgKeysRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_ORGKEYS).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetOrgKeysResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (GetOrgKeysResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetOrgKeysResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetOrgKeysResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public CreateAgentsResponse createAgents(CreateAgentsRequest request) throws IOException, SignatureException {
        AccellsRequest<CreateAgentsRequest> req = new AccellsRequest<CreateAgentsRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(CREATE_AGENTS).type("application/json").post((GenericType)new GenericType<AccellsResponse<CreateAgentsResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (CreateAgentsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (CreateAgentsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<CreateAgentsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public DeleteAgentsResponse deleteAgents(DeleteAgentsRequest request) throws IOException, SignatureException {
        AccellsRequest<DeleteAgentsRequest> req = new AccellsRequest<DeleteAgentsRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(DELETE_AGENTS).type("application/json").post((GenericType)new GenericType<AccellsResponse<DeleteAgentsResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (DeleteAgentsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (DeleteAgentsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<DeleteAgentsResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetAgentResponse getAgent(GetAgentRequest request) throws IOException, SignatureException {
        AccellsRequest<GetAgentRequest> req = new AccellsRequest<GetAgentRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_AGENT).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetAgentResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (GetAgentResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetAgentResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetAgentResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public SavePayloadResponse savePayload(SavePayloadRequest request) throws IOException, SignatureException {
        AccellsRequest<SavePayloadRequest> req = new AccellsRequest<SavePayloadRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        req.setBehalfOfOrgAlias(request.getOrgAlias());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(SAVE_PAYLOAD).type("application/json").post((GenericType)new GenericType<AccellsResponse<SavePayloadResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (SavePayloadResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (SavePayloadResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<SavePayloadResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public GetPayloadResponse getPayload(GetPayloadRequest request) throws IOException, SignatureException {
        AccellsRequest<GetPayloadRequest> req = new AccellsRequest<GetPayloadRequest>();
        req.setReqHeader(this.initRequestHeader());
        req.setReqBody(request);
        req.setBehalfOfOrgAlias(request.getOrgAlias());
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(GET_PAYLOAD).type("application/json").post((GenericType)new GenericType<AccellsResponse<GetPayloadResponse>>(){}, (Object)this.mapper.writeValueAsString(req));
            return (GetPayloadResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (GetPayloadResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<GetPayloadResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public WebAuthnStartPairingResponse startWebAuthnPairing(String orgAlias, WebAuthnStartPairingRequest request) throws IOException {
        AccellsRequest<WebAuthnStartPairingRequest> reqObj = new AccellsRequest<WebAuthnStartPairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_WEBAUTHN_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<WebAuthnStartPairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (WebAuthnStartPairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (WebAuthnStartPairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<WebAuthnStartPairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public WebAuthnFinishPairingResponse finishWebAuthnPairing(String orgAlias, WebAuthnFinishPairingRequest request) throws IOException {
        AccellsRequest<WebAuthnFinishPairingRequest> reqObj = new AccellsRequest<WebAuthnFinishPairingRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINISH_WEBAUTHN_PAIRING_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<WebAuthnFinishPairingResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (WebAuthnFinishPairingResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (WebAuthnFinishPairingResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<WebAuthnFinishPairingResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public WebAuthnStartAuthResponse startWebAuthnAuth(String orgAlias, WebAuthnStartAuthRequest request) throws IOException {
        AccellsRequest<WebAuthnStartAuthRequest> reqObj = new AccellsRequest<WebAuthnStartAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_WEBAUTHN_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<WebAuthnStartAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (WebAuthnStartAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (WebAuthnStartAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<WebAuthnStartAuthResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public StartWebAuthnPasswordlessAuthResponse startWebAuthnPasswordlessAuthentication(String managedOrgAlias, StartWebAuthnPasswordlessAuthRequest request) throws IOException {
        AccellsRequest<StartWebAuthnPasswordlessAuthRequest> reqObj = new AccellsRequest<StartWebAuthnPasswordlessAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_WEBAUTHN_PASSWORDLESS_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<StartWebAuthnPasswordlessAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (StartWebAuthnPasswordlessAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (StartWebAuthnPasswordlessAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<StartWebAuthnPasswordlessAuthResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public FinishWebAuthnPasswordlessAuthResponse finishWebAuthnPasswordlessAuthentication(String managedOrgAlias, FinishWebAuthnPasswordlessAuthRequest request) throws IOException {
        AccellsRequest<FinishWebAuthnPasswordlessAuthRequest> reqObj = new AccellsRequest<FinishWebAuthnPasswordlessAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(managedOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINISH_WEBAUTHN_PASSWORDLESS_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<FinishWebAuthnPasswordlessAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (FinishWebAuthnPasswordlessAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (FinishWebAuthnPasswordlessAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<FinishWebAuthnPasswordlessAuthResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public StartWebAuthnPasswordlessAuthResponse startWebAuthnPasswordlessAuthentication(StartWebAuthnPasswordlessAuthRequest request) throws IOException {
        AccellsRequest<StartWebAuthnPasswordlessAuthRequest> reqObj = new AccellsRequest<StartWebAuthnPasswordlessAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(this.orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(START_WEBAUTHN_PASSWORDLESS_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<StartWebAuthnPasswordlessAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (StartWebAuthnPasswordlessAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (StartWebAuthnPasswordlessAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<StartWebAuthnPasswordlessAuthResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public FinishWebAuthnPasswordlessAuthResponse finishWebAuthnPasswordlessAuthentication(FinishWebAuthnPasswordlessAuthRequest request) throws IOException {
        AccellsRequest<FinishWebAuthnPasswordlessAuthRequest> reqObj = new AccellsRequest<FinishWebAuthnPasswordlessAuthRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(this.orgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(FINISH_WEBAUTHN_PASSWORDLESS_AUTH_URL).type("application/json").post((GenericType)new GenericType<AccellsResponse<FinishWebAuthnPasswordlessAuthResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (FinishWebAuthnPasswordlessAuthResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (FinishWebAuthnPasswordlessAuthResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<FinishWebAuthnPasswordlessAuthResponse>>(){})).getResponseBody();
        }
    }

    public void setLocaleContextGetter(ContextLocaleGetter contextLocaleGetter) {
        this.localeGetter = contextLocaleGetter;
    }

    @Override
    public IssueWinSignOnCsrResponse issueWinSignOnCsr(String behalfOfOrgAlias, IssueWinSignOnCsrRequest request) throws IOException {
        AccellsRequest<IssueWinSignOnCsrRequest> reqObj = new AccellsRequest<IssueWinSignOnCsrRequest>();
        reqObj.setBehalfOfOrgAlias(behalfOfOrgAlias);
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(ISSUE_WIN_SIGNON_CSR).type("application/json").post((GenericType)new GenericType<AccellsResponse<IssueWinSignOnCsrResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (IssueWinSignOnCsrResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (IssueWinSignOnCsrResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<IssueWinSignOnCsrResponse>>(){})).getResponseBody();
        }
    }

    @Override
    public ReadKerberosCredentialsResponse readKerberosCredentials(String behalfOfOrgAlias, ReadKerberosCredentialsRequest request) throws IOException {
        AccellsRequest<ReadKerberosCredentialsRequest> reqObj = new AccellsRequest<ReadKerberosCredentialsRequest>();
        reqObj.setReqHeader(this.initRequestHeader());
        reqObj.setReqBody(request);
        reqObj.setBehalfOfOrgAlias(behalfOfOrgAlias);
        try {
            AccellsResponse response = (AccellsResponse)this.webResource.path(READ_KERBEROS_CREDENTIALS).type("application/json").post((GenericType)new GenericType<AccellsResponse<ReadKerberosCredentialsResponse>>(){}, (Object)this.mapper.writeValueAsString(reqObj));
            return (ReadKerberosCredentialsResponse)response.getResponseBody();
        }
        catch (UniformInterfaceException e) {
            logger.debug("transaction finished with error code = " + e.getResponse().getStatus() + " and error message " + e.getMessage());
            return (ReadKerberosCredentialsResponse)((AccellsResponse)e.getResponse().getEntity((GenericType)new GenericType<AccellsResponse<ReadKerberosCredentialsResponse>>(){})).getResponseBody();
        }
    }
}

