/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.accells.api.model.AccountType;
import org.accells.api.model.AdditionalAuthenticationMethod;
import org.accells.api.model.ClientHeader;
import org.accells.api.model.OrganizationType;
import org.accells.api.model.PairingType;
import org.accells.api.model.SPAliasString;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrganizationBean
extends ClientHeader {
    @NotEmpty
    @Size(max=100)
    @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE})
    @NotEmpty @Size(max=100) @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE}) String orgAlias;
    @NotEmpty
    @Size(max=100)
    @NotEmpty @Size(max=100) String orgName;
    @Size(max=4096)
    @Size(max=4096) String logoURL;
    @Valid
    List<SPAliasString> spAliasNames;
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    @Min(value=0L) @Max(value=0x7FFFFFFFL) int maxUsers;
    Date gracePeroid;
    String helpString;
    PairingType pairingType;
    OrganizationType organizationType;
    @NotNull
    AccountType accountType;
    boolean smsEnabled = false;
    boolean yubikeyEnabled = false;
    AdditionalAuthenticationMethod additionalAuthenticationMethod;
    String v2PingOneEnvId;

    public OrganizationBean() {
    }

    public OrganizationBean(String orgAlias, String orgName, int maxUsers, Date gracePeroid, String helpString, AccountType accountType) {
        this.orgAlias = orgAlias;
        this.orgName = orgName;
        this.maxUsers = maxUsers;
        this.gracePeroid = gracePeroid;
        this.helpString = helpString;
        this.organizationType = OrganizationType.REGULAR;
        this.pairingType = PairingType.NICKNAME;
        this.accountType = accountType;
    }

    public String getOrgAlias() {
        return this.orgAlias;
    }

    public void setOrgAlias(String orgAlias) {
        this.orgAlias = orgAlias;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getLogoURL() {
        return this.logoURL;
    }

    public void setLogoURL(String logoURL) {
        this.logoURL = logoURL;
    }

    public List<SPAliasString> getSpAliasNames() {
        return this.spAliasNames;
    }

    public void setSpAliasNames(List<SPAliasString> spAliasNames) {
        this.spAliasNames = spAliasNames;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
    }

    public Date getGracePeroid() {
        return this.gracePeroid;
    }

    public void setGracePeroid(Date gracePeroid) {
        this.gracePeroid = gracePeroid;
    }

    public String getHelpString() {
        return this.helpString;
    }

    public void setHelpString(String helpString) {
        this.helpString = helpString;
    }

    public PairingType getPairingType() {
        return this.pairingType;
    }

    public void setPairingType(PairingType pairingType) {
        this.pairingType = pairingType;
    }

    public OrganizationType getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(OrganizationType organizationType) {
        this.organizationType = organizationType;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public boolean isSmsEnabled() {
        return this.smsEnabled;
    }

    public void setSmsEnabled(boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
    }

    public boolean isYubikeyEnabled() {
        return this.yubikeyEnabled;
    }

    public void setYubikeyEnabled(boolean yubikeyEnabled) {
        this.yubikeyEnabled = yubikeyEnabled;
    }

    public AdditionalAuthenticationMethod getAdditionalAuthenticationMethod() {
        return this.additionalAuthenticationMethod;
    }

    public void setAdditionalAuthenticationMethod(AdditionalAuthenticationMethod additionalAuthenticationMethod) {
        this.additionalAuthenticationMethod = additionalAuthenticationMethod;
    }

    public String getV2PingOneEnvId() {
        return this.v2PingOneEnvId;
    }

    public void setV2PingOneEnvId(String v2PingOneEnvId) {
        this.v2PingOneEnvId = v2PingOneEnvId;
    }

    @Override
    public String toString() {
        return super.toString() + "orgAlias=" + this.orgAlias + "\n" + "orgName=" + this.orgName + "\n" + "logoURL=" + this.logoURL + "\n" + "spAliasNames=" + this.spAliasNames + "\n" + "maxUsers=" + this.maxUsers + "\n" + "gracePeroid=" + this.gracePeroid + "\n" + "pairingType=" + (Object)((Object)this.pairingType) + "\n" + "organizationType=" + (Object)((Object)this.organizationType) + "\n" + "accountType=" + (Object)((Object)this.accountType) + "\n" + "helpString=" + this.helpString + "\n" + "smsEnabled=" + this.smsEnabled + "\n" + "yubikeyEnabled=" + this.yubikeyEnabled + "\n" + "additionalAuthenticationMethod=" + (Object)((Object)this.additionalAuthenticationMethod) + "\n" + "v2PingOneEnvId=" + this.v2PingOneEnvId + "\n";
    }
}

