/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public enum PolicyActions {
    APPROVE("Approve", false),
    DENY("Deny", false),
    OTP("OTP", false),
    SWIPE("Swipe", false),
    FINGERPRINT("Fingerprint", false),
    NESTINGSET("NestingSet", false),
    SMS("SMS", true),
    VOICE("Voice", true),
    YUBIKEY("YubiKey", true),
    EMAIL("Email", true),
    DESKTOP("Desktop", true),
    AUTHENTICATE("Authenticate", false),
    OTP_ONLY("OTP_Only", true),
    SWIPE_ONLY("Swipe_Only", true),
    FINGERPRINT_ONLY("Fingerprint_Only", true),
    WEBAUTHN("WebAuthn", true),
    WEBAUTHN_PLATFORM("WebAuthn_Platform", true),
    OATHTOKEN("OathToken", true),
    AUTHENTICATOR_APP("AUTHENTICATOR_APP", true);

    private String action;
    private boolean allowedWithOtherActions;
    private static Map<String, PolicyActions> actions;
    private static final Set<PolicyActions> WEB_AUTHN_POLICY_ACTIONS;
    public static final String DELIMITER = ",";

    private PolicyActions(String action, boolean allowedWithOtherActions) {
        this.action = action;
        this.allowedWithOtherActions = allowedWithOtherActions;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isAllowedWithOtherActions() {
        return this.allowedWithOtherActions;
    }

    public static List<PolicyActions> getAsList(String policyActionsList) {
        ArrayList<PolicyActions> policyActionList = new ArrayList<PolicyActions>();
        if (policyActionsList == null) {
            return policyActionList;
        }
        List<String> actionList = Arrays.asList(policyActionsList.split(DELIMITER));
        Collections.sort(actionList);
        for (String action : actionList) {
            PolicyActions policyAction;
            if (StringUtils.isBlank(action) || (policyAction = PolicyActions.get(action.trim())) == null) continue;
            policyActionList.add(policyAction);
        }
        return policyActionList;
    }

    public static PolicyActions get(String policyActions) {
        if (policyActions == null) {
            return null;
        }
        return actions.get(policyActions.toLowerCase());
    }

    public static Set<PolicyActions> getWebAuthnPolicyActions() {
        return WEB_AUTHN_POLICY_ACTIONS;
    }

    static {
        actions = new HashMap<String, PolicyActions>();
        WEB_AUTHN_POLICY_ACTIONS = Collections.unmodifiableSet(EnumSet.of(WEBAUTHN, WEBAUTHN_PLATFORM));
        for (PolicyActions policyActions : PolicyActions.values()) {
            actions.put(policyActions.getAction().toLowerCase(), policyActions);
        }
    }
}

