/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.policy.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.accells.api.model.policy.PolicyActions;
import org.accells.api.model.policy.PolicyBase;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticationMethodsPolicy
extends PolicyBase {
    List<AuthenticationMethod> authenticationMethods;

    public AuthenticationMethodsPolicy() {
        this.policyAction = PolicyActions.DENY.getAction();
        this.priority = 1;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = 1;
    }

    @Override
    public Integer getPriority() {
        return 1;
    }

    @Override
    public void setPolicyAction(String policyAction) {
        policyAction = PolicyActions.DENY.getAction();
    }

    public List<AuthenticationMethod> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    public void setAuthenticationMethods(List<AuthenticationMethod> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.getAuthenticationMethods() == null || this.getAuthenticationMethods().isEmpty();
    }

    @Override
    public String getName() {
        return "authentication_methods_policy";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationMethodsPolicy that = (AuthenticationMethodsPolicy)o;
        return Objects.equals(this.getAuthenticationMethods(), that.getAuthenticationMethods());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAuthenticationMethods());
    }

    public static enum AuthenticationMethod {
        SWIPE("Swipe"),
        FINGERPRINT("Mobile App Biometrics"),
        SMS("SMS"),
        VOICE("Voice"),
        YUBIKEY("YubiKey"),
        EMAIL("Email"),
        OTP("One-time passcode"),
        DESKTOP("Desktop"),
        RESCUE("Rescue Code"),
        WEBAUTHN("Security Key"),
        WEBAUTHN_PLATFORM("FIDO2 Biometrics"),
        OATHTOKEN("Oath Token"),
        AUTHENTICATOR_APP("Authenticator App");

        private String displayName;
        private static final Set<AuthenticationMethod> WEB_AUTHN_AUTHENTICATION_METHODS;

        private AuthenticationMethod(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static AuthenticationMethod get(String authMethod) {
            if (authMethod == null) {
                return null;
            }
            for (AuthenticationMethod method : AuthenticationMethod.values()) {
                if (!method.name().equalsIgnoreCase(authMethod)) continue;
                return method;
            }
            return null;
        }

        public static Set<AuthenticationMethod> getWebAuthnAuthenticationMethods() {
            return WEB_AUTHN_AUTHENTICATION_METHODS;
        }

        static {
            WEB_AUTHN_AUTHENTICATION_METHODS = Collections.unmodifiableSet(EnumSet.of(WEBAUTHN, WEBAUTHN_PLATFORM));
        }
    }
}

