/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.policy.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.accells.api.model.policy.PolicyBase;
import org.accells.api.model.policy.authentication.AbstractNestedPolicy;
import org.accells.api.model.policy.authentication.IPRiskPolicy;

public class IPReputationPolicy
extends AbstractNestedPolicy {
    private List<IPRiskPolicy> ipRiskPolicies = new ArrayList<IPRiskPolicy>();
    private List<String> whitelistIpRanges = new ArrayList<String>();

    public IPReputationPolicy() {
    }

    public IPReputationPolicy(List<IPRiskPolicy> ipRiskPolicies) {
        this.ipRiskPolicies = ipRiskPolicies;
    }

    @Override
    public List<PolicyBase> getPolicies() {
        ArrayList<PolicyBase> basePolicies = new ArrayList<PolicyBase>();
        basePolicies.addAll(this.ipRiskPolicies);
        return basePolicies;
    }

    public List<IPRiskPolicy> getIpRiskPolicies() {
        return this.ipRiskPolicies;
    }

    public void setIpRiskPolicies(List<IPRiskPolicy> ipRiskPolicies) {
        this.ipRiskPolicies = ipRiskPolicies;
    }

    public void addIpRiskPolicy(IPRiskPolicy ipRiskPolicy) {
        this.ipRiskPolicies.add(ipRiskPolicy);
    }

    public List<String> getWhitelistIpRanges() {
        return this.whitelistIpRanges;
    }

    public void setWhitelistIpRanges(List<String> whitelistIpRanges) {
        this.whitelistIpRanges = whitelistIpRanges;
    }

    @Override
    public String getName() {
        return "ip_reputation_policy";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPReputationPolicy that = (IPReputationPolicy)o;
        return Objects.equals(this.getIpRiskPolicies(), that.getIpRiskPolicies()) && Objects.equals(this.getWhitelistIpRanges(), that.getWhitelistIpRanges());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getIpRiskPolicies(), this.getWhitelistIpRanges());
    }
}

