/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.request.body;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.accells.api.model.UserRole;
import org.accells.api.model.request.body.AddUserSPRequest;
import org.accells.api.model.request.body.OnBehalfOfRequest;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AddUserRequest
extends OnBehalfOfRequest {
    @Size(max=64)
    @Size(max=64) String fName;
    @Size(max=64)
    @Size(max=64) String lname;
    @Size(max=250)
    @Email
    @Size(max=250) @Email String email;
    @NotEmpty
    @Size(max=100)
    @NotEmpty @Size(max=100) String username;
    @Size(max=100)
    @Size(max=100) String picUrl;
    boolean activateUser = false;
    @Valid
    List<AddUserSPRequest> userServices = null;
    @NotNull
    UserRole role;
    String deviceType;
    String v2UserId;

    public AddUserRequest() {
    }

    public AddUserRequest(String fName, String lname, String username, String picUrl, boolean activateUser, UserRole role) {
        this.fName = fName;
        this.lname = lname;
        this.username = username;
        this.picUrl = picUrl;
        this.activateUser = activateUser;
        this.role = role;
    }

    public String getfName() {
        return this.fName;
    }

    @JsonAlias(value={"fName", "fname"})
    public void setfName(String fName) {
        this.fName = fName;
    }

    public String getLname() {
        return this.lname == null ? "" : this.lname;
    }

    @JsonAlias(value={"lName", "lname"})
    public void setLname(String lname) {
        this.lname = lname;
    }

    public String getUserName() {
        return this.username;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    @Deprecated
    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public boolean isActivateUser() {
        return this.activateUser;
    }

    public void setActivateUser(boolean activateUser) {
        this.activateUser = activateUser;
    }

    public List<AddUserSPRequest> getUserServices() {
        return this.userServices;
    }

    public void setUserServices(List<AddUserSPRequest> services) {
        this.userServices = services;
    }

    @Deprecated
    public void addUserService(String spAlias, String spUserName) {
        this.addUserService(spAlias);
    }

    public void addUserService(String spAlias) {
        if (this.userServices == null) {
            this.userServices = new ArrayList<AddUserSPRequest>();
        }
        AddUserSPRequest usp = new AddUserSPRequest();
        usp.setSpAlias(spAlias);
        usp.setUserName(this.username);
        this.userServices.add(usp);
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getV2UserId() {
        return this.v2UserId;
    }

    public void setV2UserId(String v2UserId) {
        this.v2UserId = v2UserId;
    }

    @Override
    public String toString() {
        return "AddUserRequest [fName=" + this.fName + ", lname=" + this.lname + ", email=" + this.email + ", username=" + this.username + ", picUrl=" + this.picUrl + ", activateUser=" + this.activateUser + ", userServices=" + this.userServices + ", role=" + (Object)((Object)this.role) + ", deviceType=" + this.deviceType + ", v2UserId=" + this.v2UserId + "]";
    }
}

