/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.request.body;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.accells.api.ApiConstants;
import org.accells.api.model.request.body.BaseRequestBody;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateBulkOrganizationLocalizationRequest
extends BaseRequestBody {
    @NotEmpty
    @Size(max=100)
    @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE})
    private @NotEmpty @Size(max=100) @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE}) String orgAlias;
    private Map<String, Map<String, String>> localizedTextsPerLocale;
    private boolean replaceExisting;

    public CreateBulkOrganizationLocalizationRequest(String orgAlias, Map<String, Map<String, String>> localizedTextsPerLocale) {
        this(orgAlias, localizedTextsPerLocale, false);
    }

    public CreateBulkOrganizationLocalizationRequest(String orgAlias, Map<String, Map<String, String>> localizedTextsPerLocale, boolean replaceExisting) {
        this.orgAlias = orgAlias;
        this.localizedTextsPerLocale = localizedTextsPerLocale;
        this.replaceExisting = replaceExisting;
    }

    public CreateBulkOrganizationLocalizationRequest() {
    }

    @AssertTrue
    public boolean isValidLocale() {
        if (this.localizedTextsPerLocale == null || this.localizedTextsPerLocale.size() == 0) {
            return false;
        }
        for (String locale : this.localizedTextsPerLocale.keySet()) {
            if (ApiConstants.isValidLocale(locale)) continue;
            return false;
        }
        return true;
    }

    @AssertTrue
    public boolean isValidLocalizationKey() {
        if (this.localizedTextsPerLocale == null || this.localizedTextsPerLocale.size() == 0) {
            return false;
        }
        for (Map.Entry<String, Map<String, String>> perLocale : this.localizedTextsPerLocale.entrySet()) {
            Map<String, String> localizedTexts = perLocale.getValue();
            if (localizedTexts == null) continue;
            for (Map.Entry<String, String> property : localizedTexts.entrySet()) {
                String value = property.getValue();
                if (ApiConstants.LocalizationKeys.isValidLocalizationKey(property.getKey(), value)) continue;
                return false;
            }
        }
        return true;
    }

    public String getOrgAlias() {
        return this.orgAlias;
    }

    public void setOrgAlias(String orgAlias) {
        this.orgAlias = orgAlias;
    }

    public Map<String, Map<String, String>> getLocalizedTextsPerLocale() {
        return this.localizedTextsPerLocale;
    }

    public void setLocalizedTextsPerLocale(Map<String, Map<String, String>> localizedTextsPerLocale) {
        this.localizedTextsPerLocale = localizedTextsPerLocale;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CreateBulkOrganizationLocalizationRequest{");
        sb.append(super.toString());
        sb.append("orgAlias='").append(this.orgAlias).append('\'');
        sb.append("replaceExisting='").append(this.replaceExisting).append('\'');
        sb.append(", localizedTextsPerLocale=").append(this.localizedTextsPerLocale);
        sb.append(", clientData='").append(this.clientData).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isReplaceExisting() {
        return this.replaceExisting;
    }

    public void setReplaceExisting(boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }
}

