/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.request.body;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.accells.api.model.request.body.OnBehalfOfRequest;
import org.apache.commons.lang.BooleanUtils;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OfflinePairingRequest
extends OnBehalfOfRequest {
    @NotNull
    OfflinePairingType type;
    @NotEmpty
    @Size(max=100)
    @NotEmpty @Size(max=100) String username;
    @NotEmpty
    @Size(max=1024)
    @NotEmpty @Size(max=1024) String pairingData;
    Boolean validateUniqueDevice = Boolean.FALSE;

    public OfflinePairingRequest() {
    }

    public OfflinePairingRequest(OfflinePairingType type, String username, String pairingData) {
        this.type = type;
        this.username = username;
        this.pairingData = pairingData;
    }

    public OfflinePairingType getType() {
        return this.type;
    }

    public void setType(OfflinePairingType type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPairingData() {
        return this.pairingData;
    }

    public void setPairingData(String pairingData) {
        this.pairingData = pairingData;
    }

    public Boolean getValidateUniqueDevice() {
        return this.validateUniqueDevice;
    }

    public void setValidateUniqueDevice(Boolean validateUniqueDevice) {
        this.validateUniqueDevice = BooleanUtils.isTrue(validateUniqueDevice);
    }

    @Override
    public String toString() {
        return "OfflinePairingRequest [userName=" + this.username + ", type=" + (Object)((Object)this.type) + ", pairing data=" + this.pairingData + ", getAdminId()=" + this.getAdminId() + ", validateUniqueDevice=" + this.validateUniqueDevice + ", getClientData()=" + this.getClientData();
    }

    public static enum OfflinePairingType {
        EMAIL("Email"),
        SMS("SMS"),
        VOICE("Voice"),
        Yubikey("Yubikey"),
        TOKEN("Token");

        private String name;

        private OfflinePairingType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static OfflinePairingType getType(String name) {
            for (OfflinePairingType type : OfflinePairingType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

