/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.request.body;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.accells.api.ApiConstants;
import org.accells.api.model.request.body.BaseRequestBody;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReadOrgLocalizationRequest
extends BaseRequestBody {
    @NotEmpty
    @Size(max=100)
    @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE})
    @NotEmpty @Size(max=100) @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE}) String orgAlias;
    private String locale;
    private List<String> properties;

    @AssertTrue
    public boolean isValidLocale() {
        return ApiConstants.isValidLocale(this.locale);
    }

    public ReadOrgLocalizationRequest() {
    }

    public ReadOrgLocalizationRequest(String orgAlias, String locale, List<String> properties) {
        this();
        this.orgAlias = orgAlias;
        this.locale = locale;
        this.properties = properties;
    }

    public ReadOrgLocalizationRequest(String orgAlias, String locale) {
        this(orgAlias, locale, null);
    }

    public String getOrgAlias() {
        return this.orgAlias;
    }

    public void setOrgAlias(String orgAlias) {
        this.orgAlias = orgAlias;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOrgLocalizationRequest{");
        sb.append(super.toString());
        sb.append("orgAlias='").append(this.orgAlias).append('\'');
        sb.append(", locale='").append(this.locale).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append(", clientData='").append(this.clientData).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }
}

