/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.request.body;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.accells.api.model.request.body.OnBehalfOfRequest;
import org.accells.api.model.request.body.WinLoginPasswordlessAuthenticationRequest;
import org.accells.api.model.request.body.WinLoginPasswordlessEnrollmentRequest;
import org.accells.api.util.json.JsonPrinter;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class StartAuthenticationBaseRequest
extends OnBehalfOfRequest {
    public static final String BAG_PARAM_LOCAL_FALLBACK_PARAMS = "localFallbackParams";
    @NotEmpty
    @Size(max=100)
    @NotEmpty @Size(max=100) String userName;
    @Pattern(regexp="^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$|^$", flags={Pattern.Flag.CASE_INSENSITIVE})
    @Pattern(regexp="^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$|^$", flags={Pattern.Flag.CASE_INSENSITIVE}) String ipAddr;
    @Size(max=50000)
    @Size(max=50000) String reqDevFP;
    @Size(max=5000)
    @Size(max=5000) String cookie;
    @Size(max=500)
    @Size(max=500) String application;
    @Size(max=64)
    @Size(max=64) String firstName;
    @Size(max=64)
    @Size(max=64) String lastName;
    @Size(max=64)
    @Size(max=64) String riskLevel;
    @Size(max=100)
    @Size(max=100) String resourceId;
    @Min(value=1L)
    @Min(value=1L) Long deviceId;
    String deviceUuid;
    @Size(max=100)
    @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE})
    @Size(max=100) @Pattern(regexp="^\\\"+[a-zA-Z:?&@_0-9/\\%+='.\\s]+\\\"+$|^[a-zA-Z0-9:?&_@/\\+='.%\\-~\\s]+$|^$", flags={Pattern.Flag.CASE_INSENSITIVE}) String sessionId;
    @Size(max=1000)
    @Size(max=1000) Set<String> memberOf;
    Map<String, String> formParameters;
    boolean enforcePolicy;
    boolean isAsync = false;
    WinLoginPasswordlessEnrollmentRequest winLoginPasswordlessEnrollmentRequest;
    WinLoginPasswordlessAuthenticationRequest winLoginPasswordlessAuthenticationRequest;

    public StartAuthenticationBaseRequest(String spAlias, String userName) {
        this.setSpAlias(spAlias);
        this.userName = userName;
    }

    public StartAuthenticationBaseRequest() {
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceUuid() {
        return this.deviceUuid;
    }

    public void setDeviceUuid(String deviceUuid) {
        this.deviceUuid = deviceUuid;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getRiskLevel() {
        return this.riskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        this.riskLevel = riskLevel;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getReqDevFP() {
        return this.reqDevFP;
    }

    public void setReqDevFP(String reqDevFP) {
        this.reqDevFP = reqDevFP;
    }

    private Map<String, String> getParamsBag() {
        if (this.formParameters == null) {
            this.formParameters = new HashMap<String, String>();
        }
        return this.formParameters;
    }

    public void addBagParam(String key, String value) {
        this.getParamsBag().put(key, value);
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public String getBagParam(String key) {
        return this.getBagParam(key, false);
    }

    public String getBagParam(String key, boolean remove) {
        return remove ? this.getParamsBag().remove(key) : this.getParamsBag().get(key);
    }

    public void clearBagParam() {
        this.getParamsBag().clear();
    }

    public Map<String, String> getFormParameters() {
        return this.getParamsBag();
    }

    public Set<String> getMemberOf() {
        return this.memberOf;
    }

    public void setMemberOf(Set<String> memberOf) {
        this.memberOf = memberOf;
    }

    public boolean isEnforcePolicy() {
        return this.enforcePolicy;
    }

    public void setEnforcePolicy(boolean enforcePolicy) {
        this.enforcePolicy = enforcePolicy;
    }

    public WinLoginPasswordlessEnrollmentRequest getWinLoginPasswordlessEnrollmentRequest() {
        return this.winLoginPasswordlessEnrollmentRequest;
    }

    public void setWinLoginPasswordlessEnrollmentRequest(WinLoginPasswordlessEnrollmentRequest winLoginPasswordlessEnrollmentRequest) {
        this.winLoginPasswordlessEnrollmentRequest = winLoginPasswordlessEnrollmentRequest;
    }

    public WinLoginPasswordlessAuthenticationRequest getWinLoginPasswordlessAuthenticationRequest() {
        return this.winLoginPasswordlessAuthenticationRequest;
    }

    public void setWinLoginPasswordlessAuthenticationRequest(WinLoginPasswordlessAuthenticationRequest winLoginPasswordlessAuthenticationRequest) {
        this.winLoginPasswordlessAuthenticationRequest = winLoginPasswordlessAuthenticationRequest;
    }

    @Override
    public String toString() {
        return String.format("StartAuthenticationBaseRequest [userName=%s, ipAddr=%s, reqDevFP=%s, cookie=%s, application=%s, firstName=%s, groups=%s, lastName=%s, deviceId=%s, isAsync=%s, sessionId=%s, formParameters=%s, enforcePolicy=%s, super=%s]", this.userName, this.ipAddr, JsonPrinter.tryConvertJson(this.reqDevFP), this.cookie, this.application, this.firstName, this.memberOf, this.lastName, this.deviceId, this.isAsync, this.sessionId, this.formParameters, this.enforcePolicy, super.toString());
    }
}

