/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.model.response.body;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.accells.api.model.AccountType;
import org.accells.api.model.AdditionalAuthenticationMethod;
import org.accells.api.model.OrganizationAttributes;
import org.accells.api.model.OrganizationBean;
import org.accells.api.model.OrganizationType;
import org.accells.api.model.PairingType;
import org.accells.api.model.SPAliasString;
import org.accells.api.model.response.body.BaseResponseBody;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReadOrganizationResponse
extends BaseResponseBody {
    @Valid
    private OrganizationBean organizationBean;
    private int maxPairingSmsMessages;
    private int sentPairingSmsMessages = -1;
    private int availablePairingSmsMessages;
    Map<OrganizationAttributes, String> attrs = new HashMap<OrganizationAttributes, String>();

    public ReadOrganizationResponse(OrganizationBean organizationBean) {
        this.organizationBean = organizationBean;
    }

    public ReadOrganizationResponse() {
        this.organizationBean = new OrganizationBean();
    }

    public ReadOrganizationResponse(String orgAlias, String orgName, int maxUsers, Date gracePeroid, String helpString, OrganizationType orgType, PairingType pairingType, boolean smsEnabled, boolean yubikeyEnabled) {
        this.organizationBean = new OrganizationBean();
        this.organizationBean.setOrgAlias(orgAlias);
        this.organizationBean.setOrgName(orgName);
        this.organizationBean.setMaxUsers(maxUsers);
        this.organizationBean.setGracePeroid(gracePeroid);
        this.organizationBean.setHelpString(helpString);
        this.organizationBean.setOrganizationType(orgType);
        this.organizationBean.setPairingType(pairingType);
        this.organizationBean.setSmsEnabled(smsEnabled);
        this.organizationBean.setYubikeyEnabled(yubikeyEnabled);
    }

    @Override
    public String getClientData() {
        return this.organizationBean.getClientData();
    }

    @Override
    public void setClientData(String clientData) {
        this.organizationBean.setClientData(clientData);
    }

    @Override
    public String toString() {
        return this.organizationBean.toString();
    }

    public String getOrgAlias() {
        return this.organizationBean.getOrgAlias();
    }

    public void setOrgAlias(String orgAlias) {
        this.organizationBean.setOrgAlias(orgAlias);
    }

    public String getOrgName() {
        return this.organizationBean.getOrgName();
    }

    public void setOrgName(String orgName) {
        this.organizationBean.setOrgName(orgName);
    }

    public String getLogoURL() {
        return this.organizationBean.getLogoURL();
    }

    public void setLogoURL(String logoURL) {
        this.organizationBean.setLogoURL(logoURL);
    }

    public List<SPAliasString> getSpAliasNames() {
        return this.organizationBean.getSpAliasNames();
    }

    public void setSpAliasNames(List<SPAliasString> spAliasNames) {
        this.organizationBean.setSpAliasNames(spAliasNames);
    }

    public int getMaxUsers() {
        return this.organizationBean.getMaxUsers();
    }

    public void setMaxUsers(int maxUsers) {
        this.organizationBean.setMaxUsers(maxUsers);
    }

    public Date getGracePeroid() {
        return this.organizationBean.getGracePeroid();
    }

    public void setGracePeroid(Date gracePeroid) {
        this.organizationBean.setGracePeroid(gracePeroid);
    }

    public String getHelpString() {
        return this.organizationBean.getHelpString();
    }

    public void setHelpString(String helpString) {
        this.organizationBean.setHelpString(helpString);
    }

    public PairingType getPairingType() {
        return this.organizationBean.getPairingType();
    }

    public void setPairingType(PairingType pairingType) {
        this.organizationBean.setPairingType(pairingType);
    }

    public OrganizationType getOrganizationType() {
        return this.organizationBean.getOrganizationType();
    }

    public void setOrganizationType(OrganizationType organizationType) {
        this.organizationBean.setOrganizationType(organizationType);
    }

    public AccountType getAccountType() {
        return this.organizationBean.getAccountType();
    }

    public void setAccountType(AccountType accountType) {
        this.organizationBean.setAccountType(accountType);
    }

    public int getMaxPairingSmsMessages() {
        return this.maxPairingSmsMessages;
    }

    public void setMaxPairingSmsMessages(int maxPairingSmsMessages) {
        this.maxPairingSmsMessages = maxPairingSmsMessages;
    }

    public void setV2PingOneEnvId(String id) {
        this.organizationBean.setV2PingOneEnvId(id);
    }

    public String getV2PingOneEnvId() {
        return this.organizationBean.getV2PingOneEnvId();
    }

    @Deprecated
    public int getSentPairingSmsMessages() {
        return this.sentPairingSmsMessages;
    }

    public int getAvailablePairingSmsMessages() {
        return this.availablePairingSmsMessages;
    }

    public void setAvailablePairingSmsMessages(int availablePairingSmsMessages) {
        this.availablePairingSmsMessages = availablePairingSmsMessages;
    }

    public boolean isSmsEnabled() {
        return this.organizationBean.isSmsEnabled();
    }

    public void setSmsEnabled(boolean smsEnabled) {
        this.organizationBean.setSmsEnabled(smsEnabled);
    }

    public boolean isYubikeyEnabled() {
        return this.organizationBean.isYubikeyEnabled();
    }

    public void setYubikeyEnabled(boolean yubikeyEnabled) {
        this.organizationBean.setYubikeyEnabled(yubikeyEnabled);
    }

    public AdditionalAuthenticationMethod getAdditionalAuthenticationMethod() {
        return this.organizationBean.getAdditionalAuthenticationMethod();
    }

    public void setAdditionalAuthenticationMethod(AdditionalAuthenticationMethod additionalAuthenticationMethod) {
        this.organizationBean.setAdditionalAuthenticationMethod(additionalAuthenticationMethod);
    }

    public Map<OrganizationAttributes, String> getAttributes() {
        return this.attrs;
    }

    public void addAttribute(String nameStr, String value) {
        OrganizationAttributes name = OrganizationAttributes.valueOf(nameStr.toUpperCase());
        if (name == OrganizationAttributes.SMS_ENABLED || name == OrganizationAttributes.YUBIKEY_ENABLED || name == OrganizationAttributes.ADDITIONAL_AUTHENTICATION_METHOD) {
            return;
        }
        this.attrs.put(name, value);
    }
}

