/*
 * Decompiled with CFR 0.152.
 */
package org.accells.api.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.sun.jersey.core.util.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class QRCodeMgr {
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 200;
    private static final String DEFAULT_DELIM = "&";
    private static final QRCodeMgr _instance = new QRCodeMgr();
    private static Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();

    private QRCodeMgr() {
    }

    public static final QRCodeMgr get() {
        return _instance;
    }

    public BufferedImage createImage(String messagePrefix, String key, String value) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put(key, value);
        return this.createImage(messagePrefix, valuesMap, DEFAULT_DELIM, 200, 200);
    }

    public BufferedImage createImage(String messagePrefix, Map<String, String> valuesMap) {
        return this.createImage(messagePrefix, valuesMap, DEFAULT_DELIM, 200, 200);
    }

    public BufferedImage createImage(String messagePrefix, Map<String, String> values, String delim, int width, int height) {
        BitMatrix bitMatrix = null;
        StringBuilder sb = new StringBuilder();
        for (String key : values.keySet()) {
            sb.append(key).append("=").append(values.get(key)).append(delim);
        }
        sb.deleteCharAt(sb.length() - 1);
        try {
            String qrCodeParamsEncoded = new String(Base64.encode((byte[])sb.toString().getBytes(StandardCharsets.UTF_8)));
            bitMatrix = new QRCodeWriter().encode(messagePrefix + qrCodeParamsEncoded, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MatrixToImageWriter.toBufferedImage(bitMatrix);
    }

    public BufferedImage createImage(String message) {
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new QRCodeWriter().encode(message, BarcodeFormat.QR_CODE, 200, 200, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MatrixToImageWriter.toBufferedImage(bitMatrix);
    }

    public String createBase64Image(String message) {
        return this.createBase64Image(message, null);
    }

    public String createBase64Image(String messagePrefix, String key, String value) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put(key, value);
        return this.createBase64Image(messagePrefix, valuesMap);
    }

    public String createBase64Image(String messagePrefix, Map<String, String> valuesMap) {
        try {
            BufferedImage bi = valuesMap == null ? this.createImage(messagePrefix) : this.createImage(messagePrefix, valuesMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "PNG", out);
            byte[] bytes = out.toByteArray();
            String base64bytes = new String(Base64.encode((byte[])bytes));
            String src = "data:image/png;base64," + base64bytes;
            return src;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
    }
}

