/*
 * Decompiled with CFR 0.152.
 */
package org.newtinyradius.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.newtinyradius.attribute.IntegerAttribute;
import org.newtinyradius.attribute.IpAttribute;
import org.newtinyradius.attribute.RadiusAttribute;
import org.newtinyradius.attribute.StringAttribute;
import org.newtinyradius.attribute.VendorSpecificAttribute;
import org.newtinyradius.dictionary.AttributeType;
import org.newtinyradius.dictionary.Dictionary;
import org.newtinyradius.dictionary.MemoryDictionary;
import org.newtinyradius.dictionary.WritableDictionary;

public class DictionaryParser {
    public static Dictionary parseDictionary(InputStream source) throws IOException {
        MemoryDictionary d = new MemoryDictionary();
        DictionaryParser.parseDictionary(source, d);
        return d;
    }

    public static void parseDictionary(InputStream source, WritableDictionary dictionary) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(source));
        int lineNum = -1;
        while ((line = in.readLine()) != null) {
            StringTokenizer tok;
            ++lineNum;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || !(tok = new StringTokenizer(line)).hasMoreTokens()) continue;
            String lineType = tok.nextToken().trim();
            if (lineType.equalsIgnoreCase("ATTRIBUTE")) {
                DictionaryParser.parseAttributeLine(dictionary, tok, lineNum);
                continue;
            }
            if (lineType.equalsIgnoreCase("VALUE")) {
                DictionaryParser.parseValueLine(dictionary, tok, lineNum);
                continue;
            }
            if (lineType.equalsIgnoreCase("$INCLUDE")) {
                DictionaryParser.includeDictionaryFile(dictionary, tok, lineNum);
                continue;
            }
            if (lineType.equalsIgnoreCase("VENDORATTR")) {
                DictionaryParser.parseVendorAttributeLine(dictionary, tok, lineNum);
                continue;
            }
            if (lineType.equals("VENDOR")) {
                DictionaryParser.parseVendorLine(dictionary, tok, lineNum);
                continue;
            }
            throw new IOException("unknown line type: " + lineType + " line: " + lineNum);
        }
    }

    private static void parseAttributeLine(WritableDictionary dictionary, StringTokenizer tok, int lineNum) throws IOException {
        if (tok.countTokens() != 3) {
            throw new IOException("syntax error on line " + lineNum);
        }
        String name = tok.nextToken().trim();
        int code = Integer.parseInt(tok.nextToken());
        String typeStr = tok.nextToken().trim();
        Class type = code == 26 ? VendorSpecificAttribute.class : DictionaryParser.getAttributeTypeClass(code, typeStr);
        dictionary.addAttributeType(new AttributeType(code, name, type));
    }

    private static void parseValueLine(WritableDictionary dictionary, StringTokenizer tok, int lineNum) throws IOException {
        if (tok.countTokens() != 3) {
            throw new IOException("syntax error on line " + lineNum);
        }
        String typeName = tok.nextToken().trim();
        String enumName = tok.nextToken().trim();
        String valStr = tok.nextToken().trim();
        AttributeType at = dictionary.getAttributeTypeByName(typeName);
        if (at == null) {
            throw new IOException("unknown attribute type: " + typeName + ", line: " + lineNum);
        }
        at.addEnumerationValue(Integer.parseInt(valStr), enumName);
    }

    public static void parseVendorAttributeLine(WritableDictionary dictionary, StringTokenizer tok, int lineNum) throws IOException {
        if (tok.countTokens() != 4) {
            throw new IOException("syntax error on line " + lineNum);
        }
        String vendor = tok.nextToken().trim();
        String name = tok.nextToken().trim();
        int code = Integer.parseInt(tok.nextToken().trim());
        String typeStr = tok.nextToken().trim();
        Class type = DictionaryParser.getAttributeTypeClass(code, typeStr);
        AttributeType at = new AttributeType(Integer.parseInt(vendor), code, name, type);
        dictionary.addAttributeType(at);
    }

    private static void parseVendorLine(WritableDictionary dictionary, StringTokenizer tok, int lineNum) throws IOException {
        if (tok.countTokens() != 2) {
            throw new IOException("syntax error on line " + lineNum);
        }
        int vendorId = Integer.parseInt(tok.nextToken().trim());
        String vendorName = tok.nextToken().trim();
        dictionary.addVendor(vendorId, vendorName);
    }

    private static void includeDictionaryFile(WritableDictionary dictionary, StringTokenizer tok, int lineNum) throws IOException {
        if (tok.countTokens() != 1) {
            throw new IOException("syntax error on line " + lineNum);
        }
        String includeFile = tok.nextToken();
        File incf = new File(includeFile);
        if (!incf.exists()) {
            throw new IOException("inclueded file '" + includeFile + "' not found, line " + lineNum);
        }
        FileInputStream fis = new FileInputStream(incf);
        DictionaryParser.parseDictionary(fis, dictionary);
    }

    public static Class getAttributeTypeClass(int attributeType, String typeStr) {
        Class<RadiusAttribute> type = RadiusAttribute.class;
        if (typeStr.equalsIgnoreCase("string")) {
            type = StringAttribute.class;
        } else if (typeStr.equalsIgnoreCase("octets")) {
            type = RadiusAttribute.class;
        } else if (typeStr.equalsIgnoreCase("integer") || typeStr.equalsIgnoreCase("date")) {
            type = IntegerAttribute.class;
        } else if (typeStr.equalsIgnoreCase("ipaddr")) {
            type = IpAttribute.class;
        }
        return type;
    }
}

