/*
 * Decompiled with CFR 0.152.
 */
package org.newtinyradius.packet;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.newtinyradius.attribute.RadiusAttribute;
import org.newtinyradius.attribute.StringAttribute;
import org.newtinyradius.packet.RadiusPacket;
import org.newtinyradius.util.RadiusException;
import org.newtinyradius.util.RadiusUtil;

public class AccessRequest
extends RadiusPacket {
    public static final String AUTH_PAP = "pap";
    public static final String AUTH_CHAP = "chap";
    public static final String AUTH_MSCHAP = "ms-chap";
    private String password;
    private String authProtocol = "pap";
    private byte[] chapPassword;
    private byte[] chapChallenge;
    private static SecureRandom random = new SecureRandom();
    private static final int USER_NAME = 1;
    private static final int USER_PASSWORD = 2;
    private static final int CHAP_PASSWORD = 3;
    private static final int CHAP_CHALLENGE = 60;
    private static Log logger = LogFactory.getLog(AccessRequest.class);

    public AccessRequest() {
    }

    public AccessRequest(String userName, String userPassword) {
        super(1, AccessRequest.getNextPacketIdentifier());
        this.setUserName(userName);
        this.setUserPassword(userPassword);
    }

    public void setUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("user name not set");
        }
        if (userName.length() == 0) {
            throw new IllegalArgumentException("empty user name not allowed");
        }
        this.removeAttributes(1);
        this.addAttribute(new StringAttribute(1, userName));
    }

    public void setUserPassword(String userPassword) {
        if (userPassword == null || userPassword.length() == 0) {
            throw new IllegalArgumentException("password is empty");
        }
        this.password = userPassword;
    }

    public String getUserPassword() {
        return this.password;
    }

    public String getUserName() {
        List attrs = this.getAttributes(1);
        if (attrs.size() < 1 || attrs.size() > 1) {
            throw new RuntimeException("exactly one User-Name attribute required");
        }
        RadiusAttribute ra = (RadiusAttribute)attrs.get(0);
        return ((StringAttribute)ra).getAttributeValue();
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        if (authProtocol == null || !authProtocol.equals(AUTH_PAP) && !authProtocol.equals(AUTH_CHAP) && !authProtocol.equals(AUTH_MSCHAP)) {
            throw new IllegalArgumentException("protocol must be pap or chap");
        }
        this.authProtocol = authProtocol;
    }

    public boolean verifyPassword(String plaintext) throws RadiusException {
        if (plaintext == null || plaintext.length() == 0) {
            throw new IllegalArgumentException("password is empty");
        }
        if (this.getAuthProtocol().equals(AUTH_CHAP)) {
            return this.verifyChapPassword(plaintext);
        }
        return this.getUserPassword().equals(plaintext);
    }

    @Override
    protected void decodeRequestAttributes(String sharedSecret) throws RadiusException {
        RadiusAttribute userPassword = this.getAttribute(2);
        RadiusAttribute chapPassword = this.getAttribute(3);
        RadiusAttribute chapChallenge = this.getAttribute(60);
        if (userPassword != null) {
            this.setAuthProtocol(AUTH_PAP);
            this.password = this.decodePapPassword(userPassword.getAttributeData(), RadiusUtil.getUtf8Bytes(sharedSecret));
            userPassword.setAttributeData(RadiusUtil.getUtf8Bytes(this.password));
        } else if (chapPassword != null && chapChallenge != null) {
            this.setAuthProtocol(AUTH_CHAP);
            this.chapPassword = chapPassword.getAttributeData();
            this.chapChallenge = chapChallenge.getAttributeData();
        } else if (chapPassword != null && this.getAuthenticator().length == 16) {
            this.setAuthProtocol(AUTH_CHAP);
            this.chapPassword = chapPassword.getAttributeData();
            this.chapChallenge = this.getAuthenticator();
        } else {
            this.setAuthProtocol(AUTH_MSCHAP);
        }
    }

    @Override
    protected void encodeRequestAttributes(String sharedSecret) {
        if (this.password == null || this.password.length() == 0) {
            return;
        }
        if (this.getAuthProtocol().equals(AUTH_PAP)) {
            byte[] pass = this.encodePapPassword(RadiusUtil.getUtf8Bytes(this.password), RadiusUtil.getUtf8Bytes(sharedSecret));
            this.removeAttributes(2);
            this.addAttribute(new RadiusAttribute(2, pass));
        } else if (this.getAuthProtocol().equals(AUTH_CHAP)) {
            byte[] challenge = this.createChapChallenge();
            byte[] pass = this.encodeChapPassword(this.password, challenge);
            this.removeAttributes(3);
            this.removeAttributes(60);
            this.addAttribute(new RadiusAttribute(3, pass));
            this.addAttribute(new RadiusAttribute(60, challenge));
        }
    }

    private byte[] encodePapPassword(byte[] userPass, byte[] sharedSecret) {
        byte[] userPassBytes = null;
        if (userPass.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPass, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPass;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i = userPassBytes.length; i < encryptedPass.length; ++i) {
            encryptedPass[i] = 0;
        }
        MessageDigest md5 = this.getMd5Digest();
        byte[] lastBlock = new byte[16];
        for (int i = 0; i < encryptedPass.length; i += 16) {
            md5.reset();
            md5.update(sharedSecret);
            md5.update(i == 0 ? this.getAuthenticator() : lastBlock);
            byte[] bn = md5.digest();
            for (int j = 0; j < 16; ++j) {
                encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
            }
            System.arraycopy(encryptedPass, i, lastBlock, 0, 16);
        }
        return encryptedPass;
    }

    private String decodePapPassword(byte[] encryptedPass, byte[] sharedSecret) throws RadiusException {
        int len;
        if (encryptedPass == null || encryptedPass.length < 16) {
            logger.warn("invalid Radius packet: User-Password attribute with malformed PAP password, length = " + (encryptedPass == null ? 0 : encryptedPass.length) + ", but length must be greater than 15");
            throw new RadiusException("malformed User-Password attribute");
        }
        MessageDigest md5 = this.getMd5Digest();
        byte[] lastBlock = new byte[16];
        for (int i = 0; i < encryptedPass.length; i += 16) {
            md5.reset();
            md5.update(sharedSecret);
            md5.update(i == 0 ? this.getAuthenticator() : lastBlock);
            byte[] bn = md5.digest();
            System.arraycopy(encryptedPass, i, lastBlock, 0, 16);
            for (int j = 0; j < 16; ++j) {
                encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
            }
        }
        for (len = encryptedPass.length; len > 0 && encryptedPass[len - 1] == 0; --len) {
        }
        byte[] passtrunc = new byte[len];
        System.arraycopy(encryptedPass, 0, passtrunc, 0, len);
        return RadiusUtil.getStringFromUtf8(passtrunc);
    }

    private byte[] createChapChallenge() {
        byte[] challenge = new byte[16];
        random.nextBytes(challenge);
        return challenge;
    }

    private byte[] encodeChapPassword(String plaintext, byte[] chapChallenge) {
        byte chapIdentifier = (byte)random.nextInt(256);
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update(chapIdentifier);
        md5.update(RadiusUtil.getUtf8Bytes(plaintext));
        byte[] chapHash = md5.digest(chapChallenge);
        System.arraycopy(chapHash, 0, chapPassword, 1, 16);
        return chapPassword;
    }

    private boolean verifyChapPassword(String plaintext) throws RadiusException {
        if (plaintext == null || plaintext.length() == 0) {
            throw new IllegalArgumentException("plaintext must not be empty");
        }
        if (this.chapChallenge == null || this.chapChallenge.length != 16) {
            throw new RadiusException("CHAP challenge must be 16 bytes");
        }
        if (this.chapPassword == null || this.chapPassword.length != 17) {
            throw new RadiusException("CHAP password must be 17 bytes");
        }
        byte chapIdentifier = this.chapPassword[0];
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update(chapIdentifier);
        md5.update(RadiusUtil.getUtf8Bytes(plaintext));
        byte[] chapHash = md5.digest(this.chapChallenge);
        for (int i = 0; i < 16; ++i) {
            if (chapHash[i] == this.chapPassword[i + 1]) continue;
            return false;
        }
        return true;
    }
}

