/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.common;

import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.model.Device;
import com.pingidentity.sdk.api.authn.model.User;
import com.pingidentity.sdk.api.authn.model.state.AccountLinkingFailed;
import com.pingidentity.sdk.api.authn.model.state.AccountRecoveryUsernameRequired;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationRequired;
import com.pingidentity.sdk.api.authn.model.state.Canceled;
import com.pingidentity.sdk.api.authn.model.state.ChallengeResponseRequired;
import com.pingidentity.sdk.api.authn.model.state.ChangePasswordExternal;
import com.pingidentity.sdk.api.authn.model.state.Completed;
import com.pingidentity.sdk.api.authn.model.state.CurrentCredentialsRequired;
import com.pingidentity.sdk.api.authn.model.state.DeviceProfileRequired;
import com.pingidentity.sdk.api.authn.model.state.DeviceProfileSessionIdRequired;
import com.pingidentity.sdk.api.authn.model.state.DeviceSelectionRequired;
import com.pingidentity.sdk.api.authn.model.state.EmailVerificationRequired;
import com.pingidentity.sdk.api.authn.model.state.ExternalAuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.ExternalAuthenticationRequired;
import com.pingidentity.sdk.api.authn.model.state.IdentifierRequired;
import com.pingidentity.sdk.api.authn.model.state.MfaCompleted;
import com.pingidentity.sdk.api.authn.model.state.MfaFailed;
import com.pingidentity.sdk.api.authn.model.state.MobilePairingRequired;
import com.pingidentity.sdk.api.authn.model.state.NewPasswordRecommended;
import com.pingidentity.sdk.api.authn.model.state.NewPasswordRequired;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceCompleted;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceUserCodeConfirmationRequired;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceUserCodeRequired;
import com.pingidentity.sdk.api.authn.model.state.OneTimeLinkVerificationRequired;
import com.pingidentity.sdk.api.authn.model.state.OtpRequired;
import com.pingidentity.sdk.api.authn.model.state.OtpVerified;
import com.pingidentity.sdk.api.authn.model.state.PasswordResetRequired;
import com.pingidentity.sdk.api.authn.model.state.PushConfirmationRejected;
import com.pingidentity.sdk.api.authn.model.state.PushConfirmationTimedOut;
import com.pingidentity.sdk.api.authn.model.state.PushConfirmationWaiting;
import com.pingidentity.sdk.api.authn.model.state.RecoveryCodeRequired;
import com.pingidentity.sdk.api.authn.model.state.RegistrationRequired;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.api.authn.model.state.SuccessfulAccountUnlock;
import com.pingidentity.sdk.api.authn.model.state.SuccessfulPasswordChange;
import com.pingidentity.sdk.api.authn.model.state.SuccessfulPasswordReset;
import com.pingidentity.sdk.api.authn.model.state.UsernamePasswordRequired;
import com.pingidentity.sdk.api.authn.model.state.UsernameRecoveryEmailRequired;
import com.pingidentity.sdk.api.authn.model.state.UsernameRecoveryEmailSent;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;

public class CommonStateSpec {
    public static final AuthnStateSpec<Resume> RESUME = new AuthnStateSpec.Builder().status("RESUME").description("The API client must redirect to PingFederate to continue processing.").modelClass(Resume.class).build();
    public static final AuthnStateSpec<AuthenticationFailed> FAILED = new AuthnStateSpec.Builder().status("FAILED").description("A state indicating that an error occurred that terminated the authentication flow.").modelClass(AuthenticationFailed.class).build();
    public static final AuthnStateSpec<UsernamePasswordRequired> USERNAME_PASSWORD_REQUIRED = new AuthnStateSpec.Builder().status("USERNAME_PASSWORD_REQUIRED").description("The user's username and password are required.").modelClass(UsernamePasswordRequired.class).action(CommonActionSpec.CHECK_USERNAME_PASSWORD).action(CommonActionSpec.RECOVER_USERNAME).action(CommonActionSpec.INITIATE_PASSWORD_CHANGE).action(CommonActionSpec.INITIATE_ACCOUNT_RECOVERY).action(CommonActionSpec.ALTERNATIVE_AUTHENTICATION).action(CommonActionSpec.INITIATE_REGISTRATION).build();
    public static final AuthnStateSpec<ChallengeResponseRequired> CHALLENGE_RESPONSE_REQUIRED = new AuthnStateSpec.Builder().status("CHALLENGE_RESPONSE_REQUIRED").description("The user's challenge response is required.").modelClass(ChallengeResponseRequired.class).action(CommonActionSpec.CHECK_CHALLENGE_RESPONSE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<NewPasswordRequired> MUST_CHANGE_PASSWORD = new AuthnStateSpec.Builder().status("MUST_CHANGE_PASSWORD").description("The user's password is no longer valid and must be changed.").modelClass(NewPasswordRequired.class).action(CommonActionSpec.CHECK_NEW_PASSWORD).action(CommonActionSpec.CANCEL_PASSWORD_CHANGE).build();
    public static final AuthnStateSpec<ChangePasswordExternal> CHANGE_PASSWORD_EXTERNAL = new AuthnStateSpec.Builder().status("CHANGE_PASSWORD_EXTERNAL").description("The user's password must be changed at an external password management system.").modelClass(ChangePasswordExternal.class).action(CommonActionSpec.CANCEL_PASSWORD_CHANGE).build();
    public static final AuthnStateSpec<NewPasswordRecommended> NEW_PASSWORD_RECOMMENDED = new AuthnStateSpec.Builder().status("NEW_PASSWORD_RECOMMENDED").description("The user's password is going to expire soon and it is recommended that they change their password.").modelClass(NewPasswordRecommended.class).action(CommonActionSpec.INITIATE_PASSWORD_CHANGE).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<NewPasswordRequired> NEW_PASSWORD_REQUIRED = new AuthnStateSpec.Builder().status("NEW_PASSWORD_REQUIRED").description("The user has selected to change their password and must now provide a new one.").modelClass(NewPasswordRequired.class).action(CommonActionSpec.CHECK_NEW_PASSWORD).action(CommonActionSpec.CANCEL_PASSWORD_CHANGE).build();
    public static final AuthnStateSpec<SuccessfulPasswordChange> SUCCESSFUL_PASSWORD_CHANGE = new AuthnStateSpec.Builder().status("SUCCESSFUL_PASSWORD_CHANGE").description("The user has successfully changed their password.").modelClass(SuccessfulPasswordChange.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<AccountRecoveryUsernameRequired> ACCOUNT_RECOVERY_USERNAME_REQUIRED = new AuthnStateSpec.Builder().status("ACCOUNT_RECOVERY_USERNAME_REQUIRED").description("The user has selected to perform account recovery and the username of an existing account is required.").modelClass(AccountRecoveryUsernameRequired.class).action(CommonActionSpec.CHECK_ACCOUNT_RECOVERY_USERNAME).action(CommonActionSpec.RECOVER_USERNAME).action(CommonActionSpec.CANCEL_ACCOUNT_RECOVERY).build();
    public static final AuthnStateSpec<OneTimeLinkVerificationRequired> ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED = new AuthnStateSpec.Builder().status("ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED").description("The user has selected to perform account recovery and one-time link user verification is required.").modelClass(OneTimeLinkVerificationRequired.class).build();
    public static final AuthnStateSpec<RecoveryCodeRequired> RECOVERY_CODE_REQUIRED = new AuthnStateSpec.Builder().status("RECOVERY_CODE_REQUIRED").description("The user has selected to perform account recovery and a security code is required.").modelClass(RecoveryCodeRequired.class).action(CommonActionSpec.CHECK_RECOVERY_CODE).action(CommonActionSpec.CANCEL_ACCOUNT_RECOVERY).build();
    public static final AuthnStateSpec<UsernameRecoveryEmailRequired> USERNAME_RECOVERY_EMAIL_REQUIRED = new AuthnStateSpec.Builder().status("USERNAME_RECOVERY_EMAIL_REQUIRED").description("The email address of an associated user account is required for username recovery to proceed.").modelClass(UsernameRecoveryEmailRequired.class).action(CommonActionSpec.CHECK_USERNAME_RECOVERY_EMAIL).action(CommonActionSpec.CANCEL_USERNAME_RECOVERY).build();
    public static final AuthnStateSpec<UsernameRecoveryEmailSent> USERNAME_RECOVERY_EMAIL_SENT = new AuthnStateSpec.Builder().status("USERNAME_RECOVERY_EMAIL_SENT").description("The username was sent to its associated email.").modelClass(UsernameRecoveryEmailSent.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<PasswordResetRequired> PASSWORD_RESET_REQUIRED = new AuthnStateSpec.Builder().status("PASSWORD_RESET_REQUIRED").description("The user has selected to perform password reset and a new password is required.").modelClass(PasswordResetRequired.class).action(CommonActionSpec.CHECK_PASSWORD_RESET).action(CommonActionSpec.CANCEL_ACCOUNT_RECOVERY).build();
    public static final AuthnStateSpec<SuccessfulPasswordReset> SUCCESSFUL_PASSWORD_RESET = new AuthnStateSpec.Builder().status("SUCCESSFUL_PASSWORD_RESET").description("The user has successfully reset their password.").modelClass(SuccessfulPasswordReset.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<SuccessfulAccountUnlock> SUCCESSFUL_ACCOUNT_UNLOCK = new AuthnStateSpec.Builder().status("SUCCESSFUL_ACCOUNT_UNLOCK").description("The user has successfully unlocked their account.").modelClass(SuccessfulAccountUnlock.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).action(CommonActionSpec.CONTINUE_ACCOUNT_RECOVERY).build();
    public static final AuthnStateSpec<IdentifierRequired> IDENTIFIER_REQUIRED = new AuthnStateSpec.Builder().status("IDENTIFIER_REQUIRED").description("An identifier is required for authentication to proceed.").modelClass(IdentifierRequired.class).action(CommonActionSpec.SUBMIT_IDENTIFIER).action(CommonActionSpec.CLEAR_IDENTIFIER).action(CommonActionSpec.CANCEL_IDENTIFIER_SUBMISSION).build();
    public static final AuthnStateSpec<Completed> COMPLETED = new AuthnStateSpec.Builder().status("COMPLETED").description("The state indicating that the authentication flow has completed successfully.").modelClass(Completed.class).build();
    public static final AuthnStateSpec<Canceled> CANCELED = new AuthnStateSpec.Builder().status("CANCELED").description("The state indicating that the authentication flow was canceled.").modelClass(Canceled.class).build();
    public static final AuthnStateSpec<RegistrationRequired> REGISTRATION_REQUIRED_AUTHN_STATE_SPEC = new AuthnStateSpec.Builder().status("REGISTRATION_REQUIRED").description("A state where registration is required before continuing.").modelClass(RegistrationRequired.class).action(CommonActionSpec.REGISTER_USER).action(CommonActionSpec.CANCEL).action(CommonActionSpec.ALTERNATIVE_AUTHENTICATION).build();
    public static final AuthnStateSpec<DeviceSelectionRequired<Device, User>> DEVICE_SELECTION_REQUIRED = new AuthnStateSpec.Builder().status("DEVICE_SELECTION_REQUIRED").description("The user must select a device for multi-factor authentication.").modelClass(DeviceSelectionRequired.class).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<OtpRequired<Device, User>> OTP_REQUIRED = new AuthnStateSpec.Builder().status("OTP_REQUIRED").description("The user must complete multi-factor authentication via an OTP (one-time passcode).").modelClass(OtpRequired.class).action(CommonActionSpec.CHECK_OTP).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<OtpVerified> OTP_VERIFIED = new AuthnStateSpec.Builder().status("OTP_VERIFIED").description("The user has completed multi-factor authentication via an OTP (one-time passcode).").modelClass(OtpVerified.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<MfaFailed> MFA_FAILED = new AuthnStateSpec.Builder().status("MFA_FAILED").description("The user has failed multi-factor authentication.").modelClass(MfaFailed.class).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<AuthenticationRequired<Device, User>> AUTHENTICATION_REQUIRED = new AuthnStateSpec.Builder().status("AUTHENTICATION_REQUIRED").description("The user must start the multi-factor authentication.").modelClass(AuthenticationRequired.class).action(CommonActionSpec.AUTHENTICATE).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<PushConfirmationWaiting<Device, User>> PUSH_CONFIRMATION_WAITING = new AuthnStateSpec.Builder().status("PUSH_CONFIRMATION_WAITING").description("Waiting for the user to confirm the push multi-factor authentication request.").modelClass(PushConfirmationWaiting.class).action(CommonActionSpec.POLL).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<PushConfirmationTimedOut<Device, User>> PUSH_CONFIRMATION_TIMED_OUT = new AuthnStateSpec.Builder().status("PUSH_CONFIRMATION_TIMED_OUT").description("Mobile push confirmation timed out.").modelClass(PushConfirmationTimedOut.class).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<PushConfirmationRejected<Device, User>> PUSH_CONFIRMATION_REJECTED = new AuthnStateSpec.Builder().status("PUSH_CONFIRMATION_REJECTED").description("Mobile push confirmation was rejected.").modelClass(PushConfirmationRejected.class).action(CommonActionSpec.SELECT_DEVICE).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<MfaCompleted> MFA_COMPLETED = new AuthnStateSpec.Builder().status("MFA_COMPLETED").description("The user has passed multi-factor authentication.").modelClass(MfaCompleted.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<DeviceProfileRequired> DEVICE_PROFILE_REQUIRED = new AuthnStateSpec.Builder().status("DEVICE_PROFILE_REQUIRED").description("The user's device must be profiled.").modelClass(DeviceProfileRequired.class).build();
    public static final AuthnStateSpec<MobilePairingRequired> MOBILE_PAIRING_REQUIRED = new AuthnStateSpec.Builder().status("MOBILE_PAIRING_REQUIRED").description("Mobile pairing is required.").modelClass(MobilePairingRequired.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<ExternalAuthenticationRequired> EXTERNAL_AUTHENTICATION_REQUIRED = new AuthnStateSpec.Builder().status("EXTERNAL_AUTHENTICATION_REQUIRED").description("External authentication required via an authentication URL.").modelClass(ExternalAuthenticationRequired.class).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<Void> EXTERNAL_AUTHENTICATION_COMPLETED = new AuthnStateSpec.Builder().status("EXTERNAL_AUTHENTICATION_COMPLETED").description("External authentication completed.").modelClass(Void.class).action(CommonActionSpec.CONTINUE_AUTHENTICATION).build();
    public static final AuthnStateSpec<ExternalAuthenticationFailed> EXTERNAL_AUTHENTICATION_FAILED = new AuthnStateSpec.Builder().status("EXTERNAL_AUTHENTICATION_FAILED").description("External authentication failed.").modelClass(ExternalAuthenticationFailed.class).action(CommonActionSpec.CANCEL_AUTHENTICATION).build();
    public static final AuthnStateSpec<CurrentCredentialsRequired> CURRENT_CREDENTIALS_REQUIRED = new AuthnStateSpec.Builder().status("CURRENT_CREDENTIALS_REQUIRED").description("Current credentials of the user are required before allowing them to proceed with other authentication factors for password change.").modelClass(CurrentCredentialsRequired.class).action(CommonActionSpec.CHECK_CURRENT_CREDENTIALS).action(CommonActionSpec.CANCEL_PASSWORD_CHANGE).build();
    public static final AuthnStateSpec<AccountLinkingFailed> ACCOUNT_LINKING_FAILED = new AuthnStateSpec.Builder().status("ACCOUNT_LINKING_FAILED").description("Account linking failed.").modelClass(AccountLinkingFailed.class).action(CommonActionSpec.CONTINUE).action(CommonActionSpec.RESTART).build();
    public static final AuthnStateSpec<DeviceProfileSessionIdRequired> DEVICE_PROFILE_SESSION_ID_REQUIRED = new AuthnStateSpec.Builder().status("DEVICE_PROFILE_SESSION_ID_REQUIRED").description("The session identifier from device profiling is required.").modelClass(DeviceProfileSessionIdRequired.class).action(CommonActionSpec.SUBMIT_DEVICE_PROFILE_SESSION_ID).build();
    public static final AuthnStateSpec<EmailVerificationRequired> EMAIL_VERIFICATION_REQUIRED = new AuthnStateSpec.Builder().status("EMAIL_VERIFICATION_REQUIRED").description("Email verification is required.").modelClass(EmailVerificationRequired.class).action(CommonActionSpec.POLL).action(CommonActionSpec.CANCEL).action(CommonActionSpec.SEND_EMAIL_VERIFICATION_OTL).build();
    public static final AuthnStateSpec<EmailVerificationRequired> EMAIL_VERIFICATION_OTP_REQUIRED = new AuthnStateSpec.Builder().status("EMAIL_VERIFICATION_OTP_REQUIRED").description("Email verification via OTP is required.").modelClass(EmailVerificationRequired.class).action(CommonActionSpec.CHECK_OTP).action(CommonActionSpec.RESEND_OTP).action(CommonActionSpec.SKIP_OTP).action(CommonActionSpec.CANCEL).build();
    public static final AuthnStateSpec<OAuthDeviceUserCodeRequired> OAUTH_DEVICE_USER_CODE_REQUIRED = new AuthnStateSpec.Builder().status("OAUTH_DEVICE_USER_CODE_REQUIRED").description("In the device authorization flow, the user must provide a code to authorize the device.").modelClass(OAuthDeviceUserCodeRequired.class).action(CommonActionSpec.SUBMIT_USER_CODE).build();
    public static final AuthnStateSpec<OAuthDeviceUserCodeConfirmationRequired> OAUTH_DEVICE_USER_CODE_CONFIRMATION_REQUIRED = new AuthnStateSpec.Builder().status("OAUTH_DEVICE_USER_CODE_CONFIRMATION_REQUIRED").description("In the device authorization flow, the user must confirm that the code presented matches the one on the device.").modelClass(OAuthDeviceUserCodeConfirmationRequired.class).action(CommonActionSpec.CONFIRM_USER_CODE).build();
    public static final AuthnStateSpec<OAuthDeviceCompleted> OAUTH_DEVICE_COMPLETED = new AuthnStateSpec.Builder().status("OAUTH_DEVICE_COMPLETED").description("In the device authorization flow, the user successfully authorized the device.").modelClass(OAuthDeviceCompleted.class).build();
}

