/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.pingidentity.sdk.api.authn.model.AuthnAction;
import com.pingidentity.sdk.api.authn.model.HalLink;
import com.pingidentity.sdk.api.authn.model.RequestContext;
import com.pingidentity.sdk.api.authn.model.WithStateAttributeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthnState<ModelType>
implements WithStateAttributeSupport {
    private String id;
    private String pluginTypeId;
    private String url;
    private String status;
    private List<AuthnAction> actions = new ArrayList<AuthnAction>();
    private ModelType model;
    private RequestContext requestContext;
    private String state = null;

    public AuthnState(String id, String url) {
        this.id = id;
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPluginTypeId() {
        return this.pluginTypeId;
    }

    public void setPluginTypeId(String pluginTypeId) {
        this.pluginTypeId = pluginTypeId;
    }

    @JsonUnwrapped
    public ModelType getModel() {
        return this.model;
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    @JsonIgnore
    public List<AuthnAction> getActions() {
        return this.actions;
    }

    public void addAction(AuthnAction action) {
        this.removeAction(action.getId());
        this.actions.add(action);
    }

    public void removeAction(String id) {
        this.actions.removeIf(action -> action.getId().equals(id));
    }

    public void clearActions() {
        this.actions.clear();
    }

    @JsonProperty(value="_links")
    public Map<String, HalLink> getLinks() {
        HashMap<String, HalLink> result = new HashMap<String, HalLink>();
        result.put("self", new HalLink(this.getUrl()));
        for (AuthnAction action : this.getActions()) {
            result.put(action.getId(), new HalLink(this.getUrl()));
        }
        return result;
    }

    @JsonIgnore
    public String getUrl() {
        return this.url;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    @JsonProperty(value="_pf_authn_api_state")
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }
}

