/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model.state;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Schema(description="This is the definition of a field that should be displayed to the user.")
public class Field
implements Serializable {
    private final String id;
    private final String label;
    private final String type;
    private final String defaultValue;
    private final Boolean required;
    private final Boolean readonly;
    private final List<String> options;
    private final String initialValue;

    public Field(FieldBuilder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.required = builder.required;
        this.readonly = builder.readonly;
        this.options = new ArrayList<String>(builder.options);
        this.initialValue = builder.initialValue;
    }

    @Schema(description="The field's ID. This is used when submitting field values.")
    public String getId() {
        return this.id;
    }

    @Schema(description="The label of the field that should be presented. Values are localized based on the client's Locale.")
    public String getLabel() {
        return this.label;
    }

    @Schema(description="The type of the field.")
    public String getType() {
        return this.type;
    }

    @Schema(description="The default value for the field.")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Schema(description="If this field is required or not.")
    public Boolean isRequired() {
        return this.required;
    }

    @Schema(description="If this field should be presented as read-only.")
    public Boolean isReadonly() {
        return this.readonly;
    }

    @Schema(description="The options for this field. Note this is only available for Field Types that have a set of expected values.")
    public List<String> getOptions() {
        if (this.options.isEmpty()) {
            return null;
        }
        return this.options;
    }

    @Schema(description="The initial value of the field.")
    public String getInitialValue() {
        return this.initialValue;
    }

    public static class FieldBuilder {
        private String id;
        private String label;
        private String type;
        private String defaultValue;
        private Boolean required;
        private Boolean readonly;
        private List<String> options;
        private String initialValue;

        public FieldBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public FieldBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public FieldBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public FieldBuilder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public FieldBuilder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public FieldBuilder setReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public FieldBuilder setOptions(List<String> options) {
            this.options = options;
            return this;
        }

        public FieldBuilder setInitialValue(String initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }
}

