/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.spec;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.sdk.api.authn.model.AuthnError;

public class AuthnErrorSpec {
    private int httpStatus = 400;
    private String code;
    private String message;
    private String userMessageKey;

    public AuthnErrorSpec(int httpStatus, String code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    protected AuthnErrorSpec() {
    }

    public AuthnError.Builder makeInstanceBuilder() {
        return new AuthnError.Builder().httpStatus(this.httpStatus).code(this.code).message(this.message).userMessageKey(this.userMessageKey);
    }

    public AuthnError makeInstance() {
        return this.makeInstanceBuilder().build();
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    public static class Builder {
        protected AuthnErrorSpec result = new AuthnErrorSpec();

        public AuthnErrorSpec build() {
            return this.result;
        }

        public Builder httpStatus(int status) {
            this.result.httpStatus = status;
            return this;
        }

        public Builder code(String code) {
            this.result.code = code;
            return this;
        }

        public Builder message(String message) {
            this.result.message = message;
            return this;
        }

        public Builder userMessageKey(String messageKey) {
            this.result.userMessageKey = messageKey;
            return this;
        }
    }
}

