/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.spec;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class AuthnStateSpec<ModelType> {
    private String status;
    private String description;
    private List<AuthnActionSpec<?>> actions = new ArrayList();
    private Class<ModelType> modelClass;

    protected AuthnStateSpec() {
    }

    protected AuthnStateSpec(AuthnStateSpec<?> copyFrom, Class<ModelType> modelClass) {
        this.status = copyFrom.status;
        this.description = copyFrom.description;
        this.actions = new ArrayList(copyFrom.actions);
        this.modelClass = modelClass;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AuthnActionSpec<?>> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @JsonProperty(value="models")
    public Class<ModelType> getModelClass() {
        return Void.class.equals(this.modelClass) ? null : this.modelClass;
    }

    public AuthnState<ModelType> makeInstance(HttpServletRequest request, ModelType model) {
        return AuthnApiSupport.getDefault().makeAuthnState(request, this, model);
    }

    public static class Builder<ModelType> {
        protected AuthnStateSpec<ModelType> result = new AuthnStateSpec();

        public AuthnStateSpec<ModelType> build() {
            return this.result;
        }

        public Builder<ModelType> template(AuthnStateSpec<ModelType> template) {
            this.result = new AuthnStateSpec<ModelType>(template, template.getModelClass());
            return this;
        }

        public Builder<ModelType> template(AuthnStateSpec<?> template, Class<ModelType> overrideModelClass) {
            this.result = new AuthnStateSpec<ModelType>(template, overrideModelClass);
            return this;
        }

        public Builder<ModelType> status(String status) {
            ((AuthnStateSpec)this.result).status = status;
            return this;
        }

        public Builder<ModelType> description(String description) {
            ((AuthnStateSpec)this.result).description = description;
            return this;
        }

        public Builder<ModelType> modelClass(Class<?> modelClass) {
            ((AuthnStateSpec)this.result).modelClass = modelClass;
            return this;
        }

        public Builder<ModelType> action(AuthnActionSpec<?> action) {
            this.removeAction(action.getId());
            ((AuthnStateSpec)this.result).actions.add(action);
            return this;
        }

        public Builder<ModelType> clearActions() {
            ((AuthnStateSpec)this.result).actions.clear();
            return this;
        }

        public void removeAction(String id) {
            ((AuthnStateSpec)this.result).actions.removeIf(action -> action.getId().equals(id));
        }
    }
}

