/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.datastore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sources.ConfigurableDriver;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.CustomDataSourceDriverException;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONValue;
import org.sourceid.dynamo.DynamoDBClientUtil;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.dynamo.DynamoDBDatatype;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.TableColumnValuesUniqueValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.URLValidator;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;

public class DynamoDBDatasource
implements CustomDataSourceDriver {
    private static final Log log = LogFactory.getLog(DynamoDBDatasource.class);
    public static final String TABLE_NAME_FIELD = "Table Name";
    public static final String ALLOW_MULTI_VALUE_ATTRIBUTES_FIELD = "Allow Multi-value Attributes";
    public static final String ENDPOINT_OVERRIDE_FIELD = "Endpoint Override";
    public static final String API_CALL_TIMEOUT_FIELD = "API Call Timeout";
    public static final String API_CALL_ATTEMPT_TIMEOUT_FIELD = "API Call Attempt Timeout";
    private static final String ATTRIBUTES_TABLE_NAME = "Attributes";
    private static final String ATTRIBUTES_TABLE_DESC = "Define attributes to expose from this data source. Click 'Add a new row ...' to add multiple entries.";
    private static final String LOCAL_ATTRIBUTE_TABLE_HEADER = "Local Attribute";
    private static final String LOCAL_ATTRIBUTE_TABLE_HEADER_DESC = "";
    private static final String REMOTE_ATTRIBUTE_TABLE_HEADER = "DynamoDB Attribute";
    private static final String REMOTE_ATTRIBUTE_TABLE_HEADER_DESC = "Provide the Document Path that identifies the DynamoDB Attribute.";
    private static final String TABLE_NAME_DESC = "The name of the DynamoDB table.";
    private static final String ENDPOINT_OVERRIDE_DESC = "An optional custom endpoint URL for the DynamoDB queries used for testing purposes. This field should not be set in a production environment.";
    private static final String ALLOW_MULTI_VALUE_ATTR_DESC = "When selected, a query can select multiple records and return the results as a multivalued attribute.";
    private static final String API_CALL_TIMEOUT_DESC = "The amount of time(in milliseconds) to allow the client to complete the execution of an API call.";
    private static final String API_CALL_ATTEMPT_TIMEOUT_DESC = "The amount of time(in milliseconds) to wait for the HTTP request to complete before giving up and timing out.";
    private static final String FILTER_DESC = "Populate the query configuration.";
    private static final String QUERY_INDEX_FIELD_NAME = "Index";
    private static final String QUERY_INDEX_FIELD_DESC = "The name of the DynamoDB index to perform the query on. Leave blank to query the base table.";
    private static final String QUERY_KEY_CONDITION_EXPRESSION_FIELD_NAME = "Key Condition Expression";
    private static final String QUERY_KEY_CONDITION_EXPRESSION_FIELD_DESC = "The Key Condition Expression to be used for the DynamoDB Query.";
    private static final String QUERY_KEY_FILTER_EXPRESSION_FIELD_NAME = "Filter Expression";
    private static final String QUERY_KEY_FILTER_EXPRESSION_FIELD_DESC = "Optionally define a filter expression to be used in the DynamoDB Query.";
    private static final String QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_NAME = "Expression Attribute Values";
    private static final String QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_DESC = "Define the expression attribute values to be referenced in the Key Condition Expression and the Filter Expression. References to attributes in the context of the transaction can be used here.";
    private static final String QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_NAME = "Expression Attribute Names";
    private static final String QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_DESC = "Optionally define the expression attribute names to be referenced in the Key Condition Expression and the Filter Expression";
    static final String TEST_CONNECTION__ACTION_FIELD = "Test Connection";
    static final String TEST_CONNECTION_ACTION_DESC = "Tests connectivity to the AWS DynamoDB Table";
    private static final int MAX_API_TIMEOUT = 999999999;
    private static final int DEFAULT_API_CALL_TIMEOUT = 10000;
    private static final int DEFAULT_API_CALL_ATTEMPT_TIMEOUT = 1000;
    private static final String DYNAMODB_DATASOURCE_TYPE = "AWS DynamoDB";
    private static final String PLACEHOLDER_ATTR_NAME = "pfplaceholder";
    String tableName;
    boolean allowMultiValueAttributes;
    String endpointOverride;
    int apiCallTimeout;
    int apiCallAttemptTimeout;
    private AdapterConfigurationGuiDescriptor guiDescriptor;
    private CustomDataSourceDriverDescriptor sourceDescriptor;
    private FilterFieldsGuiDescriptor filterFieldsDescriptor;
    private DynamoDBClientUtil dynamoDBClientUtil;
    private Map<String, String> attributesTable = new HashMap<String, String>();
    RequiredFieldValidator requiredFieldValidator;

    public DynamoDBDatasource() {
        this.guiDescriptor = new AdapterConfigurationGuiDescriptor();
        this.requiredFieldValidator = new RequiredFieldValidator();
        this.guiDescriptor.addAction(new ActionDescriptor(TEST_CONNECTION__ACTION_FIELD, TEST_CONNECTION_ACTION_DESC, (ActionDescriptor.Action)new TestDynamoDBConnectionValidator(this)));
        TextFieldDescriptor tableNameTextFieldDescriptor = new TextFieldDescriptor(TABLE_NAME_FIELD, TABLE_NAME_DESC);
        tableNameTextFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        this.guiDescriptor.addField((FieldDescriptor)tableNameTextFieldDescriptor);
        CheckBoxFieldDescriptor allowMultiValueCheckboxDescriptor = new CheckBoxFieldDescriptor(ALLOW_MULTI_VALUE_ATTRIBUTES_FIELD, ALLOW_MULTI_VALUE_ATTR_DESC);
        allowMultiValueCheckboxDescriptor.setDefaultValue(true);
        this.guiDescriptor.addField((FieldDescriptor)allowMultiValueCheckboxDescriptor);
        TextFieldDescriptor endpointOverrideTextFieldDescriptor = new TextFieldDescriptor(ENDPOINT_OVERRIDE_FIELD, ENDPOINT_OVERRIDE_DESC);
        endpointOverrideTextFieldDescriptor.addValidator((FieldValidator & Serializable)endpointOverrideField -> {
            if (StringUtils.isNotEmpty((String)endpointOverrideField.getValue())) {
                URLValidator validator = new URLValidator();
                validator.validate(endpointOverrideField);
            }
        });
        this.guiDescriptor.addField((FieldDescriptor)endpointOverrideTextFieldDescriptor);
        TextFieldDescriptor apiCallTimeOutTextFieldDescriptor = new TextFieldDescriptor(API_CALL_TIMEOUT_FIELD, API_CALL_TIMEOUT_DESC);
        apiCallTimeOutTextFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        apiCallTimeOutTextFieldDescriptor.addValidator((FieldValidator)new IntegerValidator(0, 999999999));
        apiCallTimeOutTextFieldDescriptor.setDefaultValue(Integer.toString(10000));
        this.guiDescriptor.addField((FieldDescriptor)apiCallTimeOutTextFieldDescriptor);
        TextFieldDescriptor apiCallAttemptTimeOutTextFieldDescriptor = new TextFieldDescriptor(API_CALL_ATTEMPT_TIMEOUT_FIELD, API_CALL_ATTEMPT_TIMEOUT_DESC);
        apiCallAttemptTimeOutTextFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        apiCallAttemptTimeOutTextFieldDescriptor.addValidator((FieldValidator)new IntegerValidator(0, 999999999));
        apiCallAttemptTimeOutTextFieldDescriptor.setDefaultValue(Integer.toString(1000));
        this.guiDescriptor.addField((FieldDescriptor)apiCallAttemptTimeOutTextFieldDescriptor);
        TableDescriptor attributeMappingTable = new TableDescriptor(ATTRIBUTES_TABLE_NAME, ATTRIBUTES_TABLE_DESC);
        TextFieldDescriptor localName = new TextFieldDescriptor(LOCAL_ATTRIBUTE_TABLE_HEADER, LOCAL_ATTRIBUTE_TABLE_HEADER_DESC);
        localName.addValidator((FieldValidator)this.requiredFieldValidator);
        attributeMappingTable.addRowField((FieldDescriptor)localName);
        TextFieldDescriptor dynamoDBName = new TextFieldDescriptor(REMOTE_ATTRIBUTE_TABLE_HEADER, REMOTE_ATTRIBUTE_TABLE_HEADER_DESC);
        dynamoDBName.addValidator((FieldValidator)this.requiredFieldValidator);
        attributeMappingTable.addRowField((FieldDescriptor)dynamoDBName);
        this.guiDescriptor.addTable(attributeMappingTable);
        this.guiDescriptor.addValidator((ConfigurationValidator)new TableColumnValuesUniqueValidator(ATTRIBUTES_TABLE_NAME, LOCAL_ATTRIBUTE_TABLE_HEADER, "Duplicate local attributes names are not allowed: "));
        this.filterFieldsDescriptor = new FilterFieldsGuiDescriptor(FILTER_DESC);
        TextFieldDescriptor indexFieldDescriptor = new TextFieldDescriptor(QUERY_INDEX_FIELD_NAME, QUERY_INDEX_FIELD_DESC);
        this.filterFieldsDescriptor.addField((FieldDescriptor)indexFieldDescriptor);
        TextAreaFieldDescriptor queryKeyConditionFieldDescriptor = new TextAreaFieldDescriptor(QUERY_KEY_CONDITION_EXPRESSION_FIELD_NAME, QUERY_KEY_CONDITION_EXPRESSION_FIELD_DESC, 15, 50);
        queryKeyConditionFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        this.filterFieldsDescriptor.addField((FieldDescriptor)queryKeyConditionFieldDescriptor);
        TextAreaFieldDescriptor queryFilterExpressionFieldDescriptor = new TextAreaFieldDescriptor(QUERY_KEY_FILTER_EXPRESSION_FIELD_NAME, QUERY_KEY_FILTER_EXPRESSION_FIELD_DESC, 15, 50);
        this.filterFieldsDescriptor.addField((FieldDescriptor)queryFilterExpressionFieldDescriptor);
        TextAreaFieldDescriptor expressionAttributeValuesFieldDescriptor = new TextAreaFieldDescriptor(QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_NAME, QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_DESC, 15, 50);
        expressionAttributeValuesFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        this.filterFieldsDescriptor.addField((FieldDescriptor)expressionAttributeValuesFieldDescriptor);
        TextAreaFieldDescriptor expressionAttributeNamesFieldDescriptor = new TextAreaFieldDescriptor(QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_NAME, QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_DESC, 15, 50);
        this.filterFieldsDescriptor.addField((FieldDescriptor)expressionAttributeNamesFieldDescriptor);
        this.filterFieldsDescriptor.addValidator(this::validateExpressionValueReferences);
        this.filterFieldsDescriptor.addValidator(this::validateExpressionNameReferences);
        this.filterFieldsDescriptor.addValidator(this::validateIndexName);
        this.sourceDescriptor = new CustomDataSourceDriverDescriptor((ConfigurableDriver)this, DYNAMODB_DATASOURCE_TYPE, this.guiDescriptor, this.filterFieldsDescriptor, false);
        this.sourceDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        this.tableName = configuration.getFieldValue(TABLE_NAME_FIELD);
        this.allowMultiValueAttributes = configuration.getBooleanFieldValue(ALLOW_MULTI_VALUE_ATTRIBUTES_FIELD);
        this.endpointOverride = configuration.getFieldValue(ENDPOINT_OVERRIDE_FIELD);
        this.apiCallTimeout = configuration.getIntFieldValue(API_CALL_TIMEOUT_FIELD);
        this.apiCallAttemptTimeout = configuration.getIntFieldValue(API_CALL_ATTEMPT_TIMEOUT_FIELD);
        DynamoDBConfiguration dynamoDBClientConfiguration = new DynamoDBConfiguration(this.apiCallTimeout, this.apiCallAttemptTimeout, this.endpointOverride);
        this.dynamoDBClientUtil = DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.ATTRIBUTES, dynamoDBClientConfiguration);
        this.loadTableData(configuration, ATTRIBUTES_TABLE_NAME, LOCAL_ATTRIBUTE_TABLE_HEADER, REMOTE_ATTRIBUTE_TABLE_HEADER, this.attributesTable);
    }

    public SourceDescriptor getSourceDescriptor() {
        return this.sourceDescriptor;
    }

    private void validateIndexName(Configuration configuration) throws ValidationException {
        DescribeTableRequest describeTableRequest;
        DynamoDbClient dynamoDbClient;
        DescribeTableResponse response;
        String indexName = configuration.getFieldValue(QUERY_INDEX_FIELD_NAME);
        String tableName = configuration.getFieldValue(TABLE_NAME_FIELD);
        String endpointOverride = configuration.getFieldValue(ENDPOINT_OVERRIDE_FIELD);
        if (StringUtils.isNotEmpty((String)indexName) && (response = (dynamoDbClient = DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.ATTRIBUTES, new DynamoDBConfiguration(10000L, 1000L, endpointOverride)).getDynamoDBClient()).describeTable(describeTableRequest = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build())).table().globalSecondaryIndexes().stream().noneMatch(indexDescription -> indexDescription.indexName().equals(indexName)) && response.table().localSecondaryIndexes().stream().noneMatch(indexDescription -> indexDescription.indexName().equals(indexName))) {
            throw new ValidationException("The index " + indexName + " is not defined on the table " + tableName);
        }
    }

    private void validateExpressionValueReferences(Configuration configuration) throws ValidationException {
        Map<String, AttributeValue> expressionAttributeValuesMap;
        String keyConditionExpression = configuration.getFieldValue(QUERY_KEY_CONDITION_EXPRESSION_FIELD_NAME);
        String expressionAttributeValues = configuration.getFieldValue(QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_NAME);
        List<String> attributeValueReferences = this.getWordsStartingWithCharacter(keyConditionExpression, ":");
        try {
            expressionAttributeValuesMap = this.buildExpressionAttributeValues(expressionAttributeValues);
        }
        catch (JsonProcessingException e) {
            throw new ValidationException("The Expression Attribute Values configuration is not valid JSON.");
        }
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String attributeValueReference : attributeValueReferences) {
            if (expressionAttributeValuesMap.containsKey(attributeValueReference)) continue;
            errors.add((CallSite)((Object)("The Key Condition Expression contains an attribute value reference that is not defined in the Expression Attribute Values: " + attributeValueReference)));
        }
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    private void validateExpressionNameReferences(Configuration configuration) throws ValidationException {
        Map<String, String> expressionAttributeNamesMap;
        String keyConditionExpression = configuration.getFieldValue(QUERY_KEY_CONDITION_EXPRESSION_FIELD_NAME);
        String expressionAttributeNames = configuration.getFieldValue(QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_NAME);
        List<String> attributeNameReferences = this.getWordsStartingWithCharacter(keyConditionExpression, "#");
        try {
            expressionAttributeNamesMap = this.buildExpressionAttributeNames(expressionAttributeNames);
        }
        catch (JsonProcessingException e) {
            throw new ValidationException("The Expression Attribute Names configuration is not valid JSON.");
        }
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String attributeNameReference : attributeNameReferences) {
            if (expressionAttributeNamesMap.containsKey(attributeNameReference)) continue;
            errors.add((CallSite)((Object)("The Key Condition Expression contains an attribute name reference that is not defined in the Expression Attribute Values: " + attributeNameReference)));
        }
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    public List<String> getWordsStartingWithCharacter(String expression, String character) {
        String[] words;
        ArrayList<String> resultList = new ArrayList<String>();
        for (String word : words = expression.split("\\s+|([<>]=?|=)")) {
            if (!word.startsWith(character)) continue;
            resultList.add(word);
        }
        return resultList;
    }

    public Map<String, Object> retrieveValues(Collection<String> attributeNamesToFill, SimpleFieldList filterConfiguration) throws CustomDataSourceDriverException {
        Map<String, String> expressionAttributeNamesMap;
        Map<String, AttributeValue> expressionAttributeValuesMap;
        String index = filterConfiguration.getFieldValue(QUERY_INDEX_FIELD_NAME);
        String keyConditionExpression = filterConfiguration.getFieldValue(QUERY_KEY_CONDITION_EXPRESSION_FIELD_NAME);
        String filterExpression = filterConfiguration.getFieldValue(QUERY_KEY_FILTER_EXPRESSION_FIELD_NAME);
        String expressionAttributeValues = filterConfiguration.getFieldValue(QUERY_KEY_EXPRESSION_ATTRIBUTE_VALUES_FIELD_NAME);
        String expressionAttributeNames = filterConfiguration.getFieldValue(QUERY_KEY_EXPRESSION_ATTRIBUTE_NAMES_FIELD_NAME);
        try {
            expressionAttributeValuesMap = this.buildExpressionAttributeValues(expressionAttributeValues);
            expressionAttributeNamesMap = this.buildExpressionAttributeNames(expressionAttributeNames);
        }
        catch (JsonProcessingException e) {
            throw new CustomDataSourceDriverException("Error processing query configuration.", (Throwable)e);
        }
        Map<String, String> documentPathPlaceholders = this.buildDocumentPathPlaceholders(this.attributesTable.values());
        String projectionExpression = this.buildProjectionExpression(documentPathPlaceholders.keySet());
        expressionAttributeNamesMap.putAll(documentPathPlaceholders);
        QueryRequest.Builder queryRequestBuilder = QueryRequest.builder().tableName(this.tableName).keyConditionExpression(keyConditionExpression).expressionAttributeValues(expressionAttributeValuesMap).expressionAttributeNames(expressionAttributeNamesMap).projectionExpression(projectionExpression);
        if (StringUtils.isNotEmpty((String)index)) {
            queryRequestBuilder = queryRequestBuilder.indexName(index);
        }
        if (StringUtils.isNotEmpty((String)filterExpression)) {
            queryRequestBuilder = queryRequestBuilder.filterExpression(filterExpression);
        }
        QueryRequest queryRequest = (QueryRequest)queryRequestBuilder.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query Request:" + queryRequest.toString()));
        }
        QueryResponse queryResponse = this.dynamoDBClientUtil.getDynamoDBClient().query(queryRequest);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (queryResponse.hasItems() && !queryResponse.items().isEmpty()) {
            for (String localAttributeName : attributeNamesToFill.stream().distinct().collect(Collectors.toList())) {
                String dbAttributeName = this.attributesTable.get(localAttributeName);
                ArrayList<Object> objValues = new ArrayList<Object>();
                ListIterator responseIterator = queryResponse.items().listIterator();
                do {
                    Map dbValuesMap;
                    AttributeValue value;
                    if ((value = this.getAttrValueFromResponse(dbAttributeName, dbValuesMap = (Map)responseIterator.next())) == null) continue;
                    objValues.add(this.objFromAttributeValue(value));
                } while (responseIterator.hasNext() && this.allowMultiValueAttributes);
                if (objValues.size() > 1) {
                    results.put(localAttributeName, AttrValueSupport.make(objValues));
                    continue;
                }
                if (objValues.size() != 1) continue;
                Object theValue = objValues.get(0);
                if (theValue instanceof List) {
                    results.put(localAttributeName, AttrValueSupport.make((Collection)((List)theValue)));
                    continue;
                }
                results.put(localAttributeName, theValue);
            }
        }
        return results;
    }

    public Map<String, String> buildDocumentPathPlaceholders(Collection<String> documentPaths) {
        HashMap<String, String> documentPathPlaceholders = new HashMap<String, String>();
        int i = 0;
        for (String documentPath : documentPaths) {
            String[] parts;
            for (String part : parts = documentPath.split("\\.")) {
                String placeholder = "#pfplaceholder" + i;
                String dereference = DynamoDBDatasource.extractDereference(part);
                String attrName = dereference != null ? part.substring(0, part.indexOf("[")) : part;
                if (documentPathPlaceholders.containsValue(attrName)) continue;
                documentPathPlaceholders.put(placeholder, attrName);
                ++i;
            }
        }
        return documentPathPlaceholders;
    }

    public AttributeValue getAttrValueFromResponse(String dbAttributeName, Map<String, AttributeValue> dbValuesMap) {
        if (!dbValuesMap.containsKey(dbAttributeName)) {
            int indexOfFirstPeriod = dbAttributeName.indexOf(".");
            if (indexOfFirstPeriod > 0) {
                AttributeValue mapValue = dbValuesMap.get(dbAttributeName.substring(0, indexOfFirstPeriod));
                if (mapValue != null && mapValue.hasM()) {
                    String subAttrName = dbAttributeName.substring(indexOfFirstPeriod + 1);
                    return this.getAttrValueFromResponse(subAttrName, mapValue.m());
                }
            } else {
                AttributeValue attributeValueList;
                String attrName;
                int listIndex = DynamoDBDatasource.extractIndex(dbAttributeName);
                if (listIndex != -1 && dbValuesMap.containsKey(attrName = DynamoDBDatasource.extractAttributeName(dbAttributeName)) && (attributeValueList = dbValuesMap.get(attrName)) != null && attributeValueList.hasL()) {
                    return (AttributeValue)attributeValueList.l().get(listIndex);
                }
            }
        } else {
            return dbValuesMap.get(dbAttributeName);
        }
        return null;
    }

    public Object objFromAttributeValue(AttributeValue attributeValue) {
        if (attributeValue.hasM() && !attributeValue.m().isEmpty()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Map valueMap = attributeValue.m();
            for (Map.Entry entry : valueMap.entrySet()) {
                resultMap.put((String)entry.getKey(), this.objFromAttributeValue((AttributeValue)entry.getValue()));
            }
            return resultMap;
        }
        if (attributeValue.hasL() && !attributeValue.l().isEmpty()) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            List attributeValueList = attributeValue.l();
            for (AttributeValue value : attributeValueList) {
                resultList.add(this.objFromAttributeValue(value));
            }
            return resultList;
        }
        if (attributeValue.hasSs() && !attributeValue.ss().isEmpty()) {
            return attributeValue.ss();
        }
        if (attributeValue.hasBs() && !attributeValue.bs().isEmpty()) {
            return attributeValue.bs().stream().map(this::getStringFromBinaryAttribute).collect(Collectors.toList());
        }
        if (attributeValue.hasNs() && !attributeValue.ns().isEmpty()) {
            return attributeValue.ns();
        }
        if (StringUtils.isNotEmpty((String)attributeValue.s())) {
            return attributeValue.s();
        }
        if (attributeValue.n() != null) {
            return attributeValue.n();
        }
        if (attributeValue.b() != null) {
            return this.getStringFromBinaryAttribute(attributeValue.b());
        }
        if (attributeValue.bool() != null) {
            return attributeValue.bool();
        }
        if (attributeValue.nul() != null) {
            return attributeValue.nul();
        }
        return null;
    }

    private String getStringFromBinaryAttribute(SdkBytes binary) {
        return Base64.getEncoder().encodeToString(binary.asByteArray());
    }

    public static String extractAttributeName(String docPath) {
        Pattern pattern = Pattern.compile("^(.+?)\\[");
        Matcher matcher = pattern.matcher(docPath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return LOCAL_ATTRIBUTE_TABLE_HEADER_DESC;
    }

    public static int extractIndex(String docPath) {
        Pattern pattern = Pattern.compile("\\[(\\d+)]");
        Matcher matcher = pattern.matcher(docPath);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public static String extractDereference(String docPath) {
        String dereference = null;
        if (docPath.matches(".*\\[\\d+]$")) {
            int startIndex = docPath.lastIndexOf(91);
            int endIndex = docPath.lastIndexOf(93);
            dereference = docPath.substring(startIndex, endIndex + 1);
        }
        return dereference;
    }

    private Map<String, AttributeValue> buildExpressionAttributeValues(String expressionAttributeValuesString) throws JsonProcessingException {
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        if (StringUtils.isNotEmpty((String)expressionAttributeValuesString)) {
            ObjectMapper objectMapper = new ObjectMapper();
            Map r = (Map)objectMapper.readValue(expressionAttributeValuesString, HashMap.class);
            for (Map.Entry entry : r.entrySet()) {
                Map substitutionValueMap = (Map)entry.getValue();
                AttributeValue value = this.buildAttributeValueFromSubstitutionMap(substitutionValueMap);
                if (value == null) continue;
                expressionAttributeValues.put((String)entry.getKey(), value);
            }
        }
        return expressionAttributeValues;
    }

    private AttributeValue buildAttributeValueFromSubstitutionMap(Map<String, Object> substitutionMap) {
        AttributeValue.Builder builder = AttributeValue.builder();
        for (Map.Entry<String, Object> sub : substitutionMap.entrySet()) {
            DynamoDBDatatype attributeType = DynamoDBDatatype.fromString(sub.getKey());
            switch (attributeType) {
                case STRING: {
                    builder.s((String)sub.getValue()).build();
                    break;
                }
                case NUMBER: {
                    builder.n((String)sub.getValue());
                    break;
                }
                case STRING_SET: {
                    builder.ss((Collection)((List)sub.getValue()));
                    break;
                }
                case NUMBER_SET: {
                    builder.ns((Collection)((List)sub.getValue()));
                    break;
                }
                case BINARY: {
                    byte[] bytes = Base64.getDecoder().decode((String)sub.getValue());
                    builder.b(SdkBytes.fromByteArray((byte[])bytes));
                    break;
                }
                case BINARY_SET: {
                    List byteSet = ((List)sub.getValue()).stream().map(binaryString -> SdkBytes.fromByteArray((byte[])Base64.getDecoder().decode((String)binaryString))).collect(Collectors.toList());
                    builder.bs(byteSet);
                    break;
                }
                case BOOLEAN: {
                    builder.bool(Boolean.valueOf(Boolean.parseBoolean((String)sub.getValue())));
                    break;
                }
                case MAP: {
                    HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
                    Map innerMap = (Map)sub.getValue();
                    for (Map.Entry innerEntry : innerMap.entrySet()) {
                        attributeValueMap.put((String)innerEntry.getKey(), this.buildAttributeValueFromSubstitutionMap((Map)innerEntry.getValue()));
                    }
                    builder.m(attributeValueMap);
                    break;
                }
                case LIST: {
                    ArrayList<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
                    List innerList = (List)sub.getValue();
                    for (Map innerEntry : innerList) {
                        attributeValueList.add(this.buildAttributeValueFromSubstitutionMap(innerEntry));
                    }
                    builder.l(attributeValueList);
                    break;
                }
                case NULL: {
                    builder.nul((Boolean)sub.getValue());
                    break;
                }
            }
        }
        return (AttributeValue)builder.build();
    }

    private Map<String, String> buildExpressionAttributeNames(String expressionAttributeNamesString) throws JsonProcessingException {
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)expressionAttributeNamesString)) {
            ObjectMapper objectMapper = new ObjectMapper();
            expressionAttributeNames.putAll((Map)objectMapper.readValue(expressionAttributeNamesString, HashMap.class));
        }
        return expressionAttributeNames;
    }

    private String buildProjectionExpression(Collection<String> attributes) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String attribute : attributes) {
            joiner.add(attribute);
        }
        return joiner.toString();
    }

    public String encodeFilterFieldParam(String filterFieldName, String paramToEncode) {
        return JSONValue.escape((String)paramToEncode);
    }

    public List<String> getAvailableFields() {
        return new ArrayList<String>(this.attributesTable.keySet());
    }

    void loadTableData(Configuration configuration, String tableName, String keyColName, String valColName, Map<String, String> targetMap) {
        Table customAttrsTable = configuration.getTable(tableName);
        if (customAttrsTable != null && !customAttrsTable.getRows().isEmpty()) {
            for (Row row : customAttrsTable.getRows()) {
                if (row == null) continue;
                String localAttribute = row.getFieldValue(keyColName);
                String path = row.getFieldValue(valColName);
                if (localAttribute == null || localAttribute.isEmpty() || path == null || path.isEmpty()) continue;
                targetMap.put(localAttribute, path);
            }
        }
    }

    public boolean testConnection() {
        try {
            this.doTestConnection(this.tableName);
            return true;
        }
        catch (Exception e) {
            log.debug((Object)"Error testing connection to DynamoDB table", (Throwable)e);
            return false;
        }
    }

    private void doTestConnection(String testTableName) {
        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.DATA_STORE, (AdminAuditLogger.Event)AdminAuditLogger.Event.TEST_CONNECTION, (String)"Test connection to DynamoDB data source");
        log.debug((Object)("Testing connection to AWS DynamoDB Table: " + testTableName));
        DescribeTableRequest describeTableRequest = (DescribeTableRequest)DescribeTableRequest.builder().tableName(testTableName).build();
        this.dynamoDBClientUtil.getDynamoDBClient().describeTable(describeTableRequest);
    }

    private class TestDynamoDBConnectionValidator
    implements ActionDescriptor.Action {
        CustomDataSourceDriver dataSourceDriver;

        TestDynamoDBConnectionValidator(CustomDataSourceDriver dataSourceDriver) {
            this.dataSourceDriver = dataSourceDriver;
        }

        public String actionInvoked(Configuration configuration) {
            Object result;
            String testTableName = configuration.getFieldValue(DynamoDBDatasource.TABLE_NAME_FIELD);
            DynamoDBDatasource.this.configure(configuration);
            try {
                DynamoDBDatasource.this.doTestConnection(testTableName);
                result = "Connection test was successful";
            }
            catch (ResourceNotFoundException e) {
                result = "An error occurred while testing the connection to the DynamoDB table. The table " + DynamoDBDatasource.this.tableName + " could not be found.";
                log.debug((Object)"Error testing connection to DynamoDB table", (Throwable)e);
            }
            catch (Exception e) {
                result = "An error occurred while testing the connection to the DynamoDB table. Check the server log for more details.";
                log.debug((Object)"Error testing connection to DynamoDB table", (Throwable)e);
            }
            return result;
        }
    }
}

