/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.dynamo;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class DynamoDBClientUtil {
    private final DynamoDbClient dynamoDBClient;
    private static final ConcurrentMap<DynamoDBService, Object> instanceLocks = new ConcurrentHashMap<DynamoDBService, Object>();
    private static final ConcurrentMap<DynamoDBService, DynamoClientWrapper> clientWrapperMap = new ConcurrentHashMap<DynamoDBService, DynamoClientWrapper>();

    public DynamoDBClientUtil(DynamoDbClient dynamoDBClient) {
        this.dynamoDBClient = dynamoDBClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamoDBClientUtil getInstance(DynamoDBService dynamoDBService, DynamoDBConfiguration dynamoDBConfiguration) {
        instanceLocks.putIfAbsent(dynamoDBService, new Object());
        Object v = instanceLocks.get((Object)dynamoDBService);
        synchronized (v) {
            if (clientWrapperMap.containsKey((Object)dynamoDBService)) {
                DynamoClientWrapper wrapper = (DynamoClientWrapper)clientWrapperMap.get((Object)dynamoDBService);
                if (wrapper.dynamoDBConfiguration.equals(dynamoDBConfiguration)) {
                    return new DynamoDBClientUtil(wrapper.dynamoDBClient);
                }
                wrapper.dynamoDBClient.close();
                clientWrapperMap.remove((Object)dynamoDBService);
                DynamoDbClient client = DynamoDBClientUtil.createDynamoDBClient(dynamoDBConfiguration);
                clientWrapperMap.put(dynamoDBService, new DynamoClientWrapper(client, dynamoDBConfiguration));
                return new DynamoDBClientUtil(client);
            }
            DynamoDbClient client = DynamoDBClientUtil.createDynamoDBClient(dynamoDBConfiguration);
            clientWrapperMap.put(dynamoDBService, new DynamoClientWrapper(client, dynamoDBConfiguration));
            return new DynamoDBClientUtil(client);
        }
    }

    private static DynamoDbClient createDynamoDBClient(DynamoDBConfiguration dynamoDBConfiguration) {
        SdkHttpClient httpClient = ApacheHttpClient.builder().build();
        ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(dynamoDBConfiguration.getApiCallTimeout())).apiCallAttemptTimeout(Duration.ofMillis(dynamoDBConfiguration.getApiCallAttemptTimeout())).build();
        DynamoDbClientBuilder dbClientBuilder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClient(httpClient)).overrideConfiguration(configuration);
        if (StringUtils.isNotBlank((CharSequence)dynamoDBConfiguration.getEndpointOverride())) {
            try {
                dbClientBuilder.endpointOverride(new URI(dynamoDBConfiguration.getEndpointOverride()));
            }
            catch (URISyntaxException e) {
                throw new ProcessRuntimeException((Throwable)e);
            }
        }
        return (DynamoDbClient)dbClientBuilder.build();
    }

    public List<Map<String, AttributeValue>> doBatchGetItem(String tableName, List<Map<String, AttributeValue>> keys) {
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        requestItems.put(tableName, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build());
        BatchGetItemRequest request = (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(requestItems).build();
        BatchGetItemResponse response = this.dynamoDBClient.batchGetItem(request);
        ArrayList<Map<String, AttributeValue>> result = new ArrayList<Map<String, AttributeValue>>((Collection)response.responses().get(tableName));
        if (response.hasUnprocessedKeys() && response.unprocessedKeys().containsKey(tableName)) {
            int requestedKeysCount = keys.size();
            do {
                KeysAndAttributes unprocessedKeysToRequest;
                int unprocessedKeyCount;
                if ((unprocessedKeyCount = (unprocessedKeysToRequest = (KeysAndAttributes)response.unprocessedKeys().get(tableName)).keys().size()) == requestedKeysCount) {
                    throw new ProcessRuntimeException("Did not receive any of the requested records from DynamoDB. Record size could be greater than 16 MB.The requested keys are :" + unprocessedKeysToRequest.keys());
                }
                requestedKeysCount = unprocessedKeyCount;
                HashMap<String, KeysAndAttributes> unProcessedRequestItems = new HashMap<String, KeysAndAttributes>();
                unProcessedRequestItems.put(tableName, unprocessedKeysToRequest);
                request = (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(unProcessedRequestItems).build();
                response = this.dynamoDBClient.batchGetItem(request);
                result.addAll((Collection)response.responses().get(tableName));
            } while (response.unprocessedKeys().containsKey(tableName));
        }
        return result;
    }

    public List<Map<String, AttributeValue>> getAll(String tableName, List<Map<String, AttributeValue>> keys, int batchSize) {
        ArrayList<Map<String, AttributeValue>> responseData = new ArrayList<Map<String, AttributeValue>>();
        int i = 0;
        while (i * batchSize < keys.size()) {
            int from = i * batchSize;
            int to = Math.min(++i * batchSize, keys.size());
            responseData.addAll(this.doBatchGetItem(tableName, keys.subList(from, to)));
        }
        return responseData;
    }

    public QueryResponse queryIndex(String indexKeyName, String indexKeyVal, String indexName, String tableName, String ... attributesToGet) {
        return this.queryIndex(indexKeyName, indexKeyVal, indexName, tableName, (Integer)null, attributesToGet);
    }

    public QueryResponse queryIndex(String indexKeyName, String indexKeyVal, String indexName, String tableName, Integer limit, String ... attributesToGet) {
        Condition equalsCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(indexKeyVal).build()}).build();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put(indexKeyName, equalsCondition);
        QueryRequest.Builder queryRequestBuilder = QueryRequest.builder().tableName(tableName).keyConditions(conditionMap).indexName(indexName).attributesToGet(attributesToGet);
        if (limit != null) {
            queryRequestBuilder.limit(limit);
        }
        QueryRequest queryReq = (QueryRequest)queryRequestBuilder.build();
        return this.dynamoDBClient.query(queryReq);
    }

    public QueryResponse queryTable(String partitionKeyName, String partitionKeyValue, String tableName, ComparisonOperator comparisonOperator, String ... attributesToGet) {
        Condition equalsCondition = (Condition)Condition.builder().comparisonOperator(comparisonOperator).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(partitionKeyValue).build()}).build();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put(partitionKeyName, equalsCondition);
        QueryRequest queryReq = (QueryRequest)QueryRequest.builder().tableName(tableName).keyConditions(conditionMap).attributesToGet(attributesToGet).build();
        return this.dynamoDBClient.query(queryReq);
    }

    public DynamoDbClient getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    private static class DynamoClientWrapper {
        private final DynamoDbClient dynamoDBClient;
        private final DynamoDBConfiguration dynamoDBConfiguration;

        DynamoClientWrapper(DynamoDbClient dynamoDBClient, DynamoDBConfiguration dynamoDBConfiguration) {
            this.dynamoDBClient = dynamoDBClient;
            this.dynamoDBConfiguration = dynamoDBConfiguration;
        }
    }

    public static enum DynamoDBService {
        ACCESS_GRANTS,
        AUTHN_SESSION,
        CLIENTS,
        ATTRIBUTES,
        ACCOUNT_LINKING;

    }
}

