/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.dynamo.DynamoDBClientUtil;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientFieldsSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.oauth20.domain.DynamoDBClientAttributeNames;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class ClientManagerDynamoDBImpl
extends AbstractClientManagerImpl {
    private final ConfigStore configStore = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass());
    private static final Log log = LogFactory.getLog(ClientManagerDynamoDBImpl.class);
    private static final String CONFIG_CLIENTS_TABLE_NAME = "ClientsTableName";
    private static final String CONFIG_CLIENT_ID_INDEX = "ClientIdIndex";
    private static final String CONFIG_CLIENT_NAME_INDEX = "ClientNameIndex";
    private static final String CONFIG_LAST_MODIFIED_INDEX = "LastModifiedIndex";
    private static final String CONFIG_CREATED_INDEX = "CreationTimeIndex";
    private static final String CONFIG_QUERY_CLIENT_COUNT = "query-client-count";
    private static final String CONFIG_DEFAULT_CLIENTS_TABLE_NAME = "PingFederateOAuthClients";
    private static final String CONFIG_DEFAULT_CLIENT_ID_INDEX = "PingFederateSortedOAuthClientId-index";
    private static final String CONFIG_DEFAULT_CLIENT_NAME_INDEX = "PingFederateSortedOAuthClientName-index";
    private static final String CONFIG_DEFAULT_LAST_MODIFIED_INDEX = "PingFederateSortedOAuthClientLastModified-index";
    private static final String CONFIG_DEFAULT_CREATED_INDEX = "PingFederateSortedOAuthClientCreationTime-index";
    private static final int CONFIG_DEFAULT_QUERY_CLIENT_COUNT = 2000;
    private static final int CONFIG_DEFAULT_DYNAMO_DB_BATCH_SIZE = 50;
    private static final String CONFIG_DYNAMO_DB_BATCH_SIZE = "dynamoDbBatchSize";
    private static final String CONFIG_API_CALL_TIMEOUT = "ApiCallTimeout";
    private static final String CONFIG_API_CALL_ATTEMPT_TIMEOUT = "ApiCallAttemptTimeout";
    private static final String CONFIG_ENDPOINT_OVERRIDE = "EndpointOverride";
    private static final long CONFIG_DEFAULT_API_CALL_TIMEOUT = 10000L;
    private static final long CONFIG_DEFAULT_API_CALL_ATTEMPT_TIMEOUT = 1000L;
    private static final String SORT_KEY_VALUE = "0";
    private static final String QUERY_EXPRESSION_NAME = ":query";
    private static final String EXPRESSION_VALUE_NAME = ":val";
    private static final String EXPRESSION_ATTR_NAME = "#attrName";

    private int getBatchSize() {
        return DynamoDBConfiguration.getBatchSize(50, this.configStore.getIntValue(CONFIG_DYNAMO_DB_BATCH_SIZE, 50));
    }

    private String getClientsTableName() {
        return this.configStore.getStringValue(CONFIG_CLIENTS_TABLE_NAME, CONFIG_DEFAULT_CLIENTS_TABLE_NAME);
    }

    private String getClientIdSortIndex() {
        return this.configStore.getStringValue(CONFIG_CLIENT_ID_INDEX, CONFIG_DEFAULT_CLIENT_ID_INDEX);
    }

    private String getClientNameSortIndex() {
        return this.configStore.getStringValue(CONFIG_CLIENT_NAME_INDEX, CONFIG_DEFAULT_CLIENT_NAME_INDEX);
    }

    private String getLastModifiedSortIndex() {
        return this.configStore.getStringValue(CONFIG_LAST_MODIFIED_INDEX, CONFIG_DEFAULT_LAST_MODIFIED_INDEX);
    }

    private String getCreatedSortIndex() {
        return this.configStore.getStringValue(CONFIG_CREATED_INDEX, CONFIG_DEFAULT_CREATED_INDEX);
    }

    private int getQueryClientCount() {
        return this.configStore.getIntValue(CONFIG_QUERY_CLIENT_COUNT, 2000);
    }

    DynamoDBClientUtil getDynamoDBClientUtil() {
        DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration(this.configStore.getLongValue(CONFIG_API_CALL_TIMEOUT, 10000L), this.configStore.getLongValue(CONFIG_API_CALL_ATTEMPT_TIMEOUT, 1000L), (String)StringUtils.defaultIfEmpty((CharSequence)this.configStore.getStringValue(CONFIG_ENDPOINT_OVERRIDE, null), null));
        return DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.CLIENTS, dynamoDBConfiguration);
    }

    public void doAddClient(Client client) {
        if (this.getClient(client.getClientId()) != null) {
            throw new ClientManager.ClientManagementException("Error adding client. Client with ID " + client.getClientId() + " already exists");
        }
        Map<String, AttributeValue> attributeValueMap = this.getClientAttributeValues(client, true);
        attributeValueMap.put(DynamoDBClientAttributeNames.CLIENT_ID.getName(), (AttributeValue)AttributeValue.builder().s(client.getClientId()).build());
        PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.getClientsTableName()).item(attributeValueMap).build();
        try (DSEventTimer ignored = this.getEventTimer("put");){
            this.getDynamoDBClientUtil().getDynamoDBClient().putItem(request);
        }
        catch (SdkException e) {
            throw new ClientManager.ClientManagementException((Throwable)e);
        }
    }

    public SearchResult<Client> search(SearchCriteria searchCriteria) {
        if (this.searchRequiresScanRequest(searchCriteria)) {
            return new SearchResult(searchCriteria.getStartIndex(), this.searchWithScan(searchCriteria));
        }
        QueryRequest.Builder requestBuilder = QueryRequest.builder().tableName(this.getClientsTableName());
        if (searchCriteria.getOrderBy() != null) {
            if (AbstractClientManagerImpl.SORT_BY.Name.name().equals(searchCriteria.getOrderBy())) {
                requestBuilder.indexName(this.getClientNameSortIndex());
            } else if (AbstractClientManagerImpl.SORT_BY.Id.name().equals(searchCriteria.getOrderBy())) {
                requestBuilder.indexName(this.getClientIdSortIndex());
            } else if (AbstractClientManagerImpl.SORT_BY.ModificationTime.name().equals(searchCriteria.getOrderBy())) {
                requestBuilder.indexName(this.getLastModifiedSortIndex());
            } else if (AbstractClientManagerImpl.SORT_BY.CreationTime.name().equals(searchCriteria.getOrderBy())) {
                requestBuilder.indexName(this.getCreatedSortIndex());
            }
        } else {
            requestBuilder.indexName(this.getClientIdSortIndex());
        }
        requestBuilder.scanIndexForward(Boolean.valueOf(searchCriteria.getOrder().equals((Object)SearchCriteria.Order.ASC)));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        AttributeValue sortPK = (AttributeValue)AttributeValue.builder().s(SORT_KEY_VALUE).build();
        expressionAttributeValues.put(EXPRESSION_VALUE_NAME, sortPK);
        String keyCondition = DynamoDBClientAttributeNames.SORT_KEY.getName() + " = :val";
        StringBuilder filterExpression = new StringBuilder();
        this.generateSearchParameters(searchCriteria, filterExpression, expressionAttributeValues);
        if (StringUtils.isNotEmpty((CharSequence)filterExpression.toString())) {
            requestBuilder.filterExpression(filterExpression.toString());
        }
        requestBuilder.keyConditionExpression(keyCondition).expressionAttributeValues(expressionAttributeValues).limit(Integer.valueOf(this.getQueryClientCount()));
        int totalReturned = 0;
        ArrayList partialClients = new ArrayList();
        while (totalReturned < searchCriteria.getTargetEndIndex()) {
            QueryResponse searchResponse;
            int batchCount = searchCriteria.getStartIndex() - totalReturned;
            QueryRequest queryRequest = (QueryRequest)requestBuilder.build();
            try (DSEventTimer ignored = this.getEventTimer("query");){
                searchResponse = this.getDynamoDBClientUtil().getDynamoDBClient().query(queryRequest);
            }
            catch (SdkException e) {
                throw new ClientManager.ClientManagementException((Throwable)e);
            }
            if ((totalReturned += searchResponse.count().intValue()) >= searchCriteria.getStartIndex()) {
                partialClients.addAll(searchResponse.items().stream().skip(Math.max(batchCount, 0)).map(this::buildClientFromAttributeMap).collect(Collectors.toList()));
            }
            if (!searchResponse.hasLastEvaluatedKey()) break;
            requestBuilder.exclusiveStartKey(searchResponse.lastEvaluatedKey());
        }
        List<String> clientIds = partialClients.stream().map(Client::getClientId).limit(searchCriteria.getItemsRequested()).collect(Collectors.toList());
        List clients = this.getBatchClients(clientIds);
        clients = this.sortClients(clients, searchCriteria);
        return new SearchResult(searchCriteria.getStartIndex(), clients);
    }

    private boolean searchRequiresScanRequest(SearchCriteria searchCriteria) {
        boolean orderByNameOrId = AbstractClientManagerImpl.SORT_BY.Name.name().equals(searchCriteria.getOrderBy()) || AbstractClientManagerImpl.SORT_BY.Id.name().equals(searchCriteria.getOrderBy());
        return StringUtils.isNotBlank((CharSequence)searchCriteria.getQuery()) && orderByNameOrId || searchCriteria.getFilterBy() != null && !searchCriteria.getFilterBy().isEmpty();
    }

    private List<Client> searchWithScan(SearchCriteria searchCriteria) {
        ScanRequest.Builder requestBuilder = ScanRequest.builder().tableName(this.getClientsTableName());
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        StringBuilder filterExpression = new StringBuilder();
        this.generateSearchParameters(searchCriteria, filterExpression, expressionAttributeValues);
        if (StringUtils.isNotEmpty((CharSequence)filterExpression.toString())) {
            requestBuilder.filterExpression(filterExpression.toString());
        }
        requestBuilder.expressionAttributeValues(expressionAttributeValues);
        List<Client> clients = this.doScan(requestBuilder, null);
        List sortedClients = this.sortClients(clients, searchCriteria);
        return sortedClients.stream().skip(searchCriteria.getStartIndex()).limit(searchCriteria.getItemsRequested()).collect(Collectors.toList());
    }

    private void generateSearchParameters(SearchCriteria searchCriteria, StringBuilder filterExpression, Map<String, AttributeValue> expressionAttributeValues) {
        if (StringUtils.isNotEmpty((CharSequence)searchCriteria.getQuery())) {
            AttributeValue searchValue = (AttributeValue)AttributeValue.builder().s(searchCriteria.getQuery()).build();
            expressionAttributeValues.put(QUERY_EXPRESSION_NAME, searchValue);
            filterExpression.append(this.buildContainsFilterExpression(DynamoDBClientAttributeNames.CLIENT_ID.getName(), DynamoDBClientAttributeNames.CLIENT_NAME.getName()));
        }
        if (searchCriteria.getFilterBy() != null && !searchCriteria.getFilterBy().isEmpty()) {
            this.generateGrantTypeSearchParams(searchCriteria, filterExpression, expressionAttributeValues);
        }
    }

    private String buildContainsFilterExpression(String ... attributes) {
        StringBuilder filterExpression = new StringBuilder("(");
        filterExpression.append("contains(").append(attributes[0]).append(", ").append(QUERY_EXPRESSION_NAME).append(")");
        if (attributes.length > 1) {
            for (int i = 1; i < attributes.length; ++i) {
                filterExpression.append(" or contains( ").append(attributes[i]).append(", ").append(QUERY_EXPRESSION_NAME).append(")");
            }
        }
        filterExpression.append(")");
        return filterExpression.toString();
    }

    private void generateGrantTypeSearchParams(SearchCriteria searchCriteria, StringBuilder filterExpression, Map<String, AttributeValue> expressionAttributeValues) {
        if (StringUtils.isNotEmpty((CharSequence)filterExpression.toString())) {
            filterExpression.append(" AND ");
        }
        filterExpression.append("(");
        TreeSet targetGrantTypes = this.getTargetGrantTypeSet(searchCriteria.getFilterBy());
        Iterator iterator = targetGrantTypes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i > 0) {
                filterExpression.append(" OR ");
            }
            String placeholder = ":grantType" + i;
            filterExpression.append("contains(").append(DynamoDBClientAttributeNames.GRANT_TYPES.getName()).append(", ").append(placeholder).append(")");
            AttributeValue searchValue = (AttributeValue)AttributeValue.builder().s((String)iterator.next()).build();
            expressionAttributeValues.put(placeholder, searchValue);
            ++i;
        }
        filterExpression.append(")");
    }

    private List<Client> getBatchClients(List<String> clientIds) {
        List<Client> list;
        block8: {
            List<Map<String, AttributeValue>> keys = clientIds.stream().map(id -> Collections.singletonMap(DynamoDBClientAttributeNames.CLIENT_ID.getName(), (AttributeValue)AttributeValue.builder().s(id).build())).collect(Collectors.toList());
            DSEventTimer ignored = this.getEventTimer("get");
            try {
                List<Map<String, AttributeValue>> result = this.getDynamoDBClientUtil().getAll(this.getClientsTableName(), keys, this.getBatchSize());
                list = result.stream().map(this::buildClientFromAttributeMap).collect(Collectors.toList());
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkException e) {
                    throw new ClientManager.ClientManagementException((Throwable)e);
                }
            }
            ignored.close();
        }
        return list;
    }

    public Collection<Client> getClientsByPolicyGroupId(String policyGroupId) {
        return this.getClientsWithAttribute(DynamoDBClientAttributeNames.OIDC_POLICY_ID.getName(), policyGroupId, true);
    }

    public Collection<Client> getClientsByCIBAPolicyId(String policyId) {
        return this.getClientsWithAttribute(DynamoDBClientAttributeNames.CIBA_POLICY_ID.getName(), policyId, true);
    }

    public Collection<Client> getClientsByTeppId(String teppId) {
        return this.getClientsWithAttribute(DynamoDBClientAttributeNames.TOKEN_EXCHANGE_PROCESSOR_POLICY_ID.getName(), teppId, true);
    }

    public Collection<Client> getClientsByAtmId(String atmId) {
        return this.getClientsWithAttribute(DynamoDBClientAttributeNames.ATM_ID.getName(), atmId, true);
    }

    public Collection<Client> getClientsByTlsCertIssuer(String issuerDn) {
        return this.getClientsWithAttribute(DynamoDBClientAttributeNames.CLIENT_CERT_ISSUER_DN.getName(), issuerDn, false);
    }

    private Collection<Client> getClientsWithAttribute(String attributeName, String attributeValue, boolean supplementalInfoAttr) {
        Map<String, AttributeValue> expressionAttributeValues;
        Object filterExpression;
        Object attributeNameExpression = supplementalInfoAttr ? DynamoDBClientAttributeNames.SUPPLEMENTAL_INFO.getName() + ".#attrName" : EXPRESSION_ATTR_NAME;
        if (attributeValue == null) {
            filterExpression = "attribute_not_exists(" + (String)attributeNameExpression + ")";
            expressionAttributeValues = null;
        } else {
            filterExpression = this.buildFilterExpression((String)attributeNameExpression, EXPRESSION_VALUE_NAME);
            expressionAttributeValues = Collections.singletonMap(EXPRESSION_VALUE_NAME, (AttributeValue)AttributeValue.builder().s(attributeValue).build());
        }
        Map<String, String> expressionAttributeNames = Collections.singletonMap(EXPRESSION_ATTR_NAME, attributeName);
        return this.getClientsWithReferenceFilter((String)filterExpression, expressionAttributeNames, expressionAttributeValues);
    }

    private Collection<Client> getClientsWithReferenceFilter(String filterExpression, Map<String, String> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues) {
        ScanRequest.Builder requestBuilder = ScanRequest.builder().tableName(this.getClientsTableName()).projectionExpression(DynamoDBClientAttributeNames.CLIENT_ID.getName() + ", " + DynamoDBClientAttributeNames.CLIENT_NAME.getName());
        if (this.getQueryClientCount() > 0) {
            requestBuilder.limit(Integer.valueOf(this.getQueryClientCount()));
        }
        requestBuilder.expressionAttributeNames(expressionAttributeNames).expressionAttributeValues(expressionAttributeValues).filterExpression(filterExpression);
        return this.doScan(requestBuilder, this.getQueryClientCount());
    }

    private String buildFilterExpression(String attribute, String expressionVal) {
        return attribute + " = " + expressionVal;
    }

    protected void doAddClients(Collection<Client> clients) {
        for (Client c : clients) {
            this.doAddClient(c);
        }
    }

    protected Client doUpdateClient(Client client) {
        if (this.getClient(client.getClientId()) == null) {
            throw new ClientManager.ClientNonexistentException();
        }
        Map<String, AttributeValue> attributeValueMap = this.getClientAttributeValues(client, false);
        HashMap<String, AttributeValueUpdate> attributeValueUpdateMap = new HashMap<String, AttributeValueUpdate>();
        for (Map.Entry<String, AttributeValue> attribute : attributeValueMap.entrySet()) {
            AttributeValueUpdate attributeValueUpdate = (AttributeValueUpdate)AttributeValueUpdate.builder().value(attribute.getValue()).action(AttributeAction.PUT).build();
            attributeValueUpdateMap.put(attribute.getKey(), attributeValueUpdate);
        }
        for (int i = 0; i < DynamoDBClientAttributeNames.values().length; ++i) {
            if (attributeValueUpdateMap.containsKey(DynamoDBClientAttributeNames.values()[i].getName())) continue;
            attributeValueUpdateMap.put(DynamoDBClientAttributeNames.values()[i].getName(), (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).build());
        }
        attributeValueUpdateMap.remove(DynamoDBClientAttributeNames.CLIENT_ID.getName());
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.getClientsTableName()).key(this.getPrimaryKeyAttribute(client.getClientId())).attributeUpdates(attributeValueUpdateMap).build();
        try (DSEventTimer ignored = this.getEventTimer("update");){
            this.getDynamoDBClientUtil().getDynamoDBClient().updateItem(request);
        }
        catch (SdkException e) {
            throw new ClientManager.ClientManagementException((Throwable)e);
        }
        return this.getClient(client.getClientId());
    }

    protected Client doGetClient(String clientId) {
        GetItemResponse response;
        Map<String, AttributeValue> keyToGet = this.getPrimaryKeyAttribute(clientId);
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(this.getClientsTableName()).key(keyToGet).build();
        try (DSEventTimer ignored = this.getEventTimer("get");){
            response = this.getDynamoDBClientUtil().getDynamoDBClient().getItem(request);
        }
        catch (SdkException e) {
            throw new ClientManager.ClientManagementException((Throwable)e);
        }
        if (response.hasItem()) {
            Map valuesMap = response.item();
            return this.buildClientFromAttributeMap(valuesMap);
        }
        return null;
    }

    private List<Client> buildClientsFromScanResponse(ScanResponse response) {
        return response.items().stream().map(this::buildClientFromAttributeMap).collect(Collectors.toList());
    }

    public Collection<Client> doGetClients() {
        ScanRequest.Builder requestBuilder = ScanRequest.builder().tableName(this.getClientsTableName());
        return this.doScan(requestBuilder, null);
    }

    private List<Client> doScan(ScanRequest.Builder requestBuilder, Integer limit) {
        boolean continueScan;
        ArrayList<Client> clients = new ArrayList<Client>();
        int totalClientsReturned = 0;
        String lastEvaluated = null;
        do {
            ScanResponse response;
            continueScan = false;
            if (StringUtils.isNotEmpty(lastEvaluated)) {
                requestBuilder.exclusiveStartKey(this.getPrimaryKeyAttribute(lastEvaluated));
            }
            ScanRequest scanRequest = (ScanRequest)requestBuilder.build();
            if (log.isDebugEnabled()) {
                log.debug((Object)scanRequest.toString());
            }
            try (DSEventTimer ignored = this.getEventTimer("scan");){
                response = this.getDynamoDBClientUtil().getDynamoDBClient().scan(scanRequest);
            }
            catch (SdkException e) {
                throw new ClientManager.ClientManagementException((Throwable)e);
            }
            clients.addAll(this.buildClientsFromScanResponse(response));
            if (!response.hasLastEvaluatedKey() || limit == null || (totalClientsReturned += response.items().size()) >= limit) continue;
            lastEvaluated = ((AttributeValue)response.lastEvaluatedKey().get(DynamoDBClientAttributeNames.CLIENT_ID.getName())).s();
            continueScan = true;
        } while (continueScan);
        return clients;
    }

    protected void doDeleteClient(String clientId) {
        if (this.getClient(clientId) == null) {
            throw new ClientManager.ClientNonexistentException();
        }
        DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.getClientsTableName()).key(this.getPrimaryKeyAttribute(clientId)).build();
        try (DSEventTimer ignored = this.getEventTimer("delete");){
            this.getDynamoDBClientUtil().getDynamoDBClient().deleteItem(deleteRequest);
        }
        catch (SdkException e) {
            throw new ClientManager.ClientManagementException((Throwable)e);
        }
    }

    private Map<String, AttributeValue> getClientAttributeValues(Client client, boolean isCreate) {
        String authnTypeName;
        HashMap<String, AttributeValue> itemValues = new HashMap<String, AttributeValue>();
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CLIENT_NAME.getName(), client.getName());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.DESCRIPTION.getName(), client.getDescription());
        String currentTime = String.valueOf(System.currentTimeMillis());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.LAST_MODIFIED_TIME.getName(), currentTime);
        if (isCreate) {
            this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CREATION_TIME.getName(), currentTime);
        } else if (client.getCreationTime() != null) {
            String creationTime = String.valueOf(client.getCreationTime().getTimeInMillis());
            this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CREATION_TIME.getName(), creationTime);
        }
        ClientAuthenticationType authnType = client.getClientAuthnType();
        if (client.getClientAuthnType() != null && StringUtils.isNotEmpty((CharSequence)(authnTypeName = authnType.name()))) {
            itemValues.put(DynamoDBClientAttributeNames.CLIENT_AUTH_TYPE.getName(), (AttributeValue)AttributeValue.builder().s(authnTypeName).build());
        }
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CLIENT_SECRET.getName(), client.getEncodedSecret());
        if (client.getGrantTypes() != null) {
            this.addListAttribute(itemValues, DynamoDBClientAttributeNames.GRANT_TYPES.getName(), new ArrayList<String>(client.getGrantTypes()));
        }
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.LOGO_URL.getName(), client.getLogoUrl());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.REFRESH_ROLLING.getName(), client.getRefreshRolling());
        this.addListAttribute(itemValues, DynamoDBClientAttributeNames.REDIRECT_URIS.getName(), client.getRedirectUris());
        this.addBooleanAttribute(itemValues, DynamoDBClientAttributeNames.ENFORCE_REPLAY_PREVENTION.getName(), client.isEnforceReplayPrevention());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CLIENT_CERT_ISSUER_DN.getName(), client.getClientCertIssuerDn());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.CLIENT_CERT_SUBJECT_DN.getName(), client.getClientCertSubjectDn());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.JWKS_URL.getName(), client.getJwksUrl());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.JWKS.getName(), client.getJwks());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TYPE.getName(), client.getPersistentGrantExpirationType());
        this.addNumberAttribute(itemValues, DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TIME.getName(), client.getPersistentGrantExpirationTime());
        this.addStringAttribute(itemValues, DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_UNIT.getName(), client.getPersistentGrantExpirationTimeUnit());
        this.addBooleanAttribute(itemValues, DynamoDBClientAttributeNames.BYPASS_APPROVAL.getName(), client.isBypassApprovalPage());
        this.addBooleanAttribute(itemValues, DynamoDBClientAttributeNames.RESTRICT_SCOPES.getName(), client.isRestrictScopes());
        this.addListAttribute(itemValues, DynamoDBClientAttributeNames.RESTRICTED_SCOPES.getName(), client.getRestrictedScopes());
        this.addListAttribute(itemValues, DynamoDBClientAttributeNames.LOGOUT_URIS.getName(), client.getLogoutUris());
        if (client.getSupplementalInfo() != null) {
            HashMap<String, AttributeValue> supplementalInfoAttributes = new HashMap<String, AttributeValue>();
            for (Map.Entry supplementalAttribute : client.getSupplementalInfo().entrySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)supplementalAttribute.getValue()))) continue;
                AttributeValue attributeValue = (AttributeValue)AttributeValue.builder().s((String)supplementalAttribute.getValue()).build();
                supplementalInfoAttributes.put((String)supplementalAttribute.getKey(), attributeValue);
            }
            if (!supplementalInfoAttributes.isEmpty()) {
                itemValues.put(DynamoDBClientAttributeNames.SUPPLEMENTAL_INFO.getName(), (AttributeValue)AttributeValue.builder().m(supplementalInfoAttributes).build());
            }
        }
        if (client.getExtendedParams() != null) {
            HashMap<String, AttributeValue> extendedParams = new HashMap<String, AttributeValue>();
            for (Map.Entry entry : client.getExtendedParams().entrySet()) {
                if (entry.getValue() == null || ((ParamValues)entry.getValue()).getElements() == null) continue;
                AttributeValue value = (AttributeValue)AttributeValue.builder().ss((Collection)((ParamValues)entry.getValue()).getElements()).build();
                extendedParams.put((String)entry.getKey(), value);
            }
            if (!extendedParams.isEmpty()) {
                itemValues.put(DynamoDBClientAttributeNames.EXTENDED_PARAMS.getName(), (AttributeValue)AttributeValue.builder().m(extendedParams).build());
            }
        }
        itemValues.put(DynamoDBClientAttributeNames.SORT_KEY.getName(), (AttributeValue)AttributeValue.builder().s(SORT_KEY_VALUE).build());
        return itemValues;
    }

    private void addStringAttribute(HashMap<String, AttributeValue> itemValues, String attrName, String attrValue) {
        if (StringUtils.isNotEmpty((CharSequence)attrValue)) {
            itemValues.put(attrName, (AttributeValue)AttributeValue.builder().s(attrValue).build());
        }
    }

    private void addListAttribute(HashMap<String, AttributeValue> itemValues, String attrName, List<String> attrValues) {
        if (attrValues != null && !attrValues.isEmpty()) {
            itemValues.put(attrName, (AttributeValue)AttributeValue.builder().ss(attrValues).build());
        }
    }

    private void addBooleanAttribute(HashMap<String, AttributeValue> itemValues, String attrName, Boolean attrValue) {
        if (attrValue != null && attrValue.booleanValue()) {
            itemValues.put(attrName, (AttributeValue)AttributeValue.builder().bool(attrValue).build());
        }
    }

    private void addNumberAttribute(HashMap<String, AttributeValue> itemValues, String attrName, Long attrValue) {
        if (attrValue != null) {
            itemValues.put(attrName, (AttributeValue)AttributeValue.builder().n(String.valueOf(attrValue)).build());
        }
    }

    private Client buildClientFromAttributeMap(Map<String, AttributeValue> valuesMap) {
        String storedJWKS;
        Client client = new Client();
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_ID.getName())) {
            client.setClientId(valuesMap.get(DynamoDBClientAttributeNames.CLIENT_ID.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_NAME.getName())) {
            client.setName(valuesMap.get(DynamoDBClientAttributeNames.CLIENT_NAME.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.DESCRIPTION.getName())) {
            client.setDescription(valuesMap.get(DynamoDBClientAttributeNames.DESCRIPTION.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.LAST_MODIFIED_TIME.getName())) {
            client.setLastModified(this.translateTimestamp(valuesMap.get(DynamoDBClientAttributeNames.LAST_MODIFIED_TIME.getName()).s()));
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CREATION_TIME.getName())) {
            client.setCreationTime(this.translateTimestamp(valuesMap.get(DynamoDBClientAttributeNames.CREATION_TIME.getName()).s()));
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_AUTH_TYPE.getName())) {
            client.setClientAuthnType(ClientAuthenticationType.valueOf((String)valuesMap.get(DynamoDBClientAttributeNames.CLIENT_AUTH_TYPE.getName()).s()));
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.REDIRECT_URIS.getName())) {
            client.setRedirectUris(valuesMap.get(DynamoDBClientAttributeNames.REDIRECT_URIS.getName()).ss());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.GRANT_TYPES.getName())) {
            client.setGrantTypes(new HashSet(valuesMap.get(DynamoDBClientAttributeNames.GRANT_TYPES.getName()).ss()));
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_SECRET.getName())) {
            client.setEncodedSecret(valuesMap.get(DynamoDBClientAttributeNames.CLIENT_SECRET.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.RESTRICT_SCOPES.getName())) {
            client.setRestrictScopes(valuesMap.get(DynamoDBClientAttributeNames.RESTRICT_SCOPES.getName()).bool().booleanValue());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.RESTRICTED_SCOPES.getName())) {
            client.setRestrictedScopes(valuesMap.get(DynamoDBClientAttributeNames.RESTRICTED_SCOPES.getName()).ss());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_CERT_ISSUER_DN.getName())) {
            client.setClientCertIssuerDn(valuesMap.get(DynamoDBClientAttributeNames.CLIENT_CERT_ISSUER_DN.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.CLIENT_CERT_SUBJECT_DN.getName())) {
            client.setClientCertSubjectDn(valuesMap.get(DynamoDBClientAttributeNames.CLIENT_CERT_SUBJECT_DN.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.JWKS_URL.getName())) {
            client.setJwksUrl(valuesMap.get(DynamoDBClientAttributeNames.JWKS_URL.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.JWKS.getName()) && StringUtils.isNotEmpty((CharSequence)(storedJWKS = valuesMap.get(DynamoDBClientAttributeNames.JWKS.getName()).s()))) {
            try {
                JsonWebKeySet jsonKeySet = new JsonWebKeySet(storedJWKS);
                client.setJwks(jsonKeySet.toJson());
                client.setJsonWebKeys(jsonKeySet.getJsonWebKeys());
            }
            catch (JoseException e) {
                log.error((Object)e.getMessage());
                log.debug((Object)e.getStackTrace());
            }
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.LOGO_URL.getName())) {
            client.setLogoUrl(valuesMap.get(DynamoDBClientAttributeNames.LOGO_URL.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TYPE.getName())) {
            client.setPersistentGrantExpirationType(valuesMap.get(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TYPE.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TIME.getName())) {
            String stringValue = valuesMap.get(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_TIME.getName()).n();
            Long persistentGrantExpirationTime = Long.parseLong(stringValue);
            client.setPersistentGrantExpirationTime(persistentGrantExpirationTime);
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_UNIT.getName())) {
            client.setPersistentGrantExpirationTimeUnit(valuesMap.get(DynamoDBClientAttributeNames.PERSISTENT_GRANT_EXP_UNIT.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.REFRESH_ROLLING.getName())) {
            client.setRefreshRolling(valuesMap.get(DynamoDBClientAttributeNames.REFRESH_ROLLING.getName()).s());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.BYPASS_APPROVAL.getName())) {
            client.setBypassApprovalPage(valuesMap.get(DynamoDBClientAttributeNames.BYPASS_APPROVAL.getName()).bool().booleanValue());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.LOGOUT_URIS.getName())) {
            client.setLogoutUris(valuesMap.get(DynamoDBClientAttributeNames.LOGOUT_URIS.getName()).ss());
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.SUPPLEMENTAL_INFO.getName()) && valuesMap.get(DynamoDBClientAttributeNames.SUPPLEMENTAL_INFO.getName()).hasM()) {
            Map supplementalInfo = valuesMap.get(DynamoDBClientAttributeNames.SUPPLEMENTAL_INFO.getName()).m();
            for (Map.Entry entry : supplementalInfo.entrySet()) {
                client.setSupplementalInfo((String)entry.getKey(), ((AttributeValue)entry.getValue()).s());
            }
        }
        if (valuesMap.containsKey(DynamoDBClientAttributeNames.EXTENDED_PARAMS.getName())) {
            HashMap<String, ParamValues> extendedParams = new HashMap<String, ParamValues>();
            for (Map.Entry entry : valuesMap.get(DynamoDBClientAttributeNames.EXTENDED_PARAMS.getName()).m().entrySet()) {
                ParamValues paramValues = new ParamValues();
                paramValues.setElements(((AttributeValue)entry.getValue()).ss());
                extendedParams.put((String)entry.getKey(), paramValues);
            }
            client.setExtendedParams(extendedParams);
        }
        return this.doSanitize(client, (Sanitizer)new ClientScopeSanitizer(), new Sanitizer[]{new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer()});
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    public boolean isBackendDatabase() {
        return true;
    }

    public int getDatastoreSearchClientCount() {
        return this.getQueryClientCount();
    }

    public Client getCachedClient(String clientId) {
        try {
            return clientId != null ? (Client)((Optional)this.engineClientsCache.get((Object)clientId)).orElse(null) : null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new ClientManager.ClientManagementException(e.getCause());
        }
    }

    private Map<String, AttributeValue> getPrimaryKeyAttribute(String clientId) {
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>();
        primaryKey.put(DynamoDBClientAttributeNames.CLIENT_ID.getName(), (AttributeValue)AttributeValue.builder().s(clientId).build());
        return primaryKey;
    }

    private DSEventTimer getEventTimer(String eventType) {
        return DSEventTimer.getDynamoDBInstance((String)eventType, (ServiceInformation)this);
    }
}

