/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.dynamo.DynamoDBClientUtil;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class AccessGrantManagerDynamoDBImpl
extends BaseAccessGrantManager {
    private static final Log log = LogFactory.getLog(AccessGrantManagerDynamoDBImpl.class);
    private static final String GUID_KEY = "GUID";
    private static final String UNIQUE_USER_ID_KEY = "UniqueUserId";
    private static final String HASHED_REFRESH_TOKEN_KEY = "HashedRefreshToken";
    private static final String CLIENT_ID_KEY = "ClientId";
    private static final String ISSUED = "Issued";
    private static final String UPDATED = "Updated";
    private static final String SCOPE = "Scope";
    private static final String GRANT_TYPE = "GrantType";
    private static final String CONTEXTUAL_QUALIFIER = "ContextualQualifier";
    private static final String GRANT_ATTRIBUTES = "GrantAttributes";
    private static final String EXPIRES = "Expires";
    private static final String AUTHORIZATION_DETAILS = "AuthorizationDetails";
    private static final String CONFIG_ACCESS_GRANTS_CLIENT_ID_INDEX = "AccessGrantsClientIdIndex";
    private static final String CONFIG_ACCESS_GRANTS_HASHED_REFRESH_TOKEN_INDEX = "AccessGrantsHashedRefreshTokenIndex";
    private static final String CONFIG_ACCESS_GRANTS_UNIQUE_USER_ID_AND_CLIENT_ID_INDEX = "AccessGrantsUniqueUserIdClientIdIndex";
    private static final String CONFIG_TABLE_NAME = "TableName";
    private static final String CONFIG_ENDPOINT_OVERRIDE = "EndpointOverride";
    private static final String CONFIG_DYNAMO_DB_BATCH_SIZE = "dynamoDbBatchSize";
    private static final String CONFIG_API_CALL_TIMEOUT = "ApiCallTimeout";
    private static final String CONFIG_API_CALL_ATTEMPT_TIMEOUT = "ApiCallAttemptTimeout";
    private static final String CONFIG_DEFAULT_ACCESS_GRANTS_CLIENT_ID_INDEX = "AccessGrantsClientId-index";
    private static final String CONFIG_DEFAULT_ACCESS_GRANTS_HASHED_REFRESH_TOKEN_INDEX = "AccessGrantsHashedRefreshToken-index";
    private static final String CONFIG_DEFAULT_ACCESS_GRANTS_UNIQUE_USER_ID_AND_CLIENT_ID_INDEX = "AccessGrantsUniqueUserIdClientId-index";
    private static final String CONFIG_DEFAULT_TABLE_NAME = "PingFederateAccessGrants";
    private static final int CONFIG_DEFAULT_DYNAMO_DB_BATCH_SIZE = 50;
    private static final long CONFIG_DEFAULT_API_CALL_TIMEOUT = 10000L;
    private static final long CONFIG_DEFAULT_API_CALL_ATTEMPT_TIMEOUT = 1000L;
    private String accessGrantsClientIdIndex;
    private String accessGrantsUniqueUserIdAndClientIdIndex;
    private String accessGrantsHashedRefreshTokenIndex;
    private String tableName;
    private int maxGrantAllowed;
    private int maxGrantsToDelete;
    private final DynamoDBClientUtil dynamoDBClientUtil;
    private int batchSize;
    private final ConfigStore configStore = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass());

    public AccessGrantManagerDynamoDBImpl() {
        this.loadConfiguration();
        DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration(this.configStore.getLongValue(CONFIG_API_CALL_TIMEOUT, 10000L), this.configStore.getLongValue(CONFIG_API_CALL_ATTEMPT_TIMEOUT, 1000L), (String)StringUtils.defaultIfEmpty((CharSequence)this.configStore.getStringValue(CONFIG_ENDPOINT_OVERRIDE, null), null));
        this.dynamoDBClientUtil = DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.ACCESS_GRANTS, dynamoDBConfiguration);
    }

    private void loadConfiguration() {
        this.accessGrantsClientIdIndex = this.configStore.getStringValue(CONFIG_ACCESS_GRANTS_CLIENT_ID_INDEX, CONFIG_DEFAULT_ACCESS_GRANTS_CLIENT_ID_INDEX);
        this.accessGrantsHashedRefreshTokenIndex = this.configStore.getStringValue(CONFIG_ACCESS_GRANTS_HASHED_REFRESH_TOKEN_INDEX, CONFIG_DEFAULT_ACCESS_GRANTS_HASHED_REFRESH_TOKEN_INDEX);
        this.accessGrantsUniqueUserIdAndClientIdIndex = this.configStore.getStringValue(CONFIG_ACCESS_GRANTS_UNIQUE_USER_ID_AND_CLIENT_ID_INDEX, CONFIG_DEFAULT_ACCESS_GRANTS_UNIQUE_USER_ID_AND_CLIENT_ID_INDEX);
        this.maxGrantAllowed = this.configStore.getIntValue("maxPersistentGrants", -1);
        this.maxGrantsToDelete = this.configStore.getIntValue("maxPersistentGrantsToRemoveBatchSize", -1);
        this.tableName = this.configStore.getStringValue(CONFIG_TABLE_NAME, CONFIG_DEFAULT_TABLE_NAME);
        this.batchSize = DynamoDBConfiguration.getBatchSize(50, this.configStore.getIntValue(CONFIG_DYNAMO_DB_BATCH_SIZE, 50));
    }

    AccessGrantManagerDynamoDBImpl(DynamoDbClient dynamoDBClient) {
        this.loadConfiguration();
        this.dynamoDBClientUtil = new DynamoDBClientUtil(dynamoDBClient);
    }

    public AccessGrant doGetByRefreshToken(String refreshTokenValue) {
        String hashedTokenValue = TokenUtil.digestToken((String)refreshTokenValue);
        Collection grants = this.queryAccessGrantTableByIndex(HASHED_REFRESH_TOKEN_KEY, hashedTokenValue, this.accessGrantsHashedRefreshTokenIndex).stream().map(GrantWrapper::getAccessGrant).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)grants)) {
            return grants.stream().findAny().orElse(null);
        }
        return null;
    }

    protected AccessGrant getByGuidInternal(String accessGrantGuid) {
        return this.getGrantWrapperByGuid(accessGrantGuid).getAccessGrant();
    }

    private GrantWrapper getGrantWrapperByGuid(String accessGrantGuid) {
        GrantWrapper grantWrapper = new GrantWrapper(null, Collections.emptyList());
        HashMap<String, AttributeValue> keyToGet = new HashMap<String, AttributeValue>();
        keyToGet.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrantGuid).build());
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().key(keyToGet).tableName(this.tableName).build();
        try {
            Map returnedItem;
            try (DSEventTimer ignored = this.getEventTimer("get");){
                returnedItem = this.getDynamoDBClient().getItem(request).item();
            }
            if (MapUtils.isNotEmpty((Map)returnedItem)) {
                grantWrapper = this.buildAccessGrantFromResponse(returnedItem);
            } else {
                log.error((Object)String.format("No item found with the key %s!", accessGrantGuid));
            }
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
        }
        return grantWrapper;
    }

    private void logException(Exception e) {
        log.error((Object)e.getMessage());
        log.debug((Object)e);
        AsAuditLogger.setDescription((String)"Access Grant Management Exception");
        AsAuditLogger.log((String)"Access Grant Management Exception");
    }

    public void deleteGrant(String accessGrantGuid) {
        HashMap<String, AttributeValue> keyToGet = new HashMap<String, AttributeValue>();
        keyToGet.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrantGuid).build());
        DeleteItemRequest deleteReq = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.tableName).key(keyToGet).build();
        try (DSEventTimer ignored = this.getEventTimer("delete");){
            this.getDynamoDBClient().deleteItem(deleteReq);
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    protected void saveGrant(AccessGrant accessGrant, Collection<AccessGrantAttribute> attributes) {
        HashMap<String, AttributeValue> itemValues = new HashMap<String, AttributeValue>();
        itemValues.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getGuid()).build());
        itemValues.put(ISSUED, (AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getIssued())).build());
        itemValues.put(UPDATED, (AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getUpdated())).build());
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getUniqueUserIdentifer())) {
            itemValues.put(UNIQUE_USER_ID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getUniqueUserIdentifer()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getHashedRefreshTokenValue())) {
            itemValues.put(HASHED_REFRESH_TOKEN_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getHashedRefreshTokenValue()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getScope().getScopeStr())) {
            itemValues.put(SCOPE, (AttributeValue)AttributeValue.builder().s(accessGrant.getScope().getScopeStr()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getClientId())) {
            itemValues.put(CLIENT_ID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getClientId()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getGrantType())) {
            itemValues.put(GRANT_TYPE, (AttributeValue)AttributeValue.builder().s(accessGrant.getGrantType()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getContextualQualifier())) {
            itemValues.put(CONTEXTUAL_QUALIFIER, (AttributeValue)AttributeValue.builder().s(accessGrant.getContextualQualifier()).build());
        }
        if (accessGrant.getExpires() != null) {
            itemValues.put(EXPIRES, (AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getExpires() / 1000L)).build());
        }
        if (accessGrant.getAuthorizationDetails() != null && accessGrant.getAuthorizationDetails().getDetails() != null && !accessGrant.getAuthorizationDetails().getDetails().isEmpty()) {
            String obfuscatedAuthorizationDetails = Obfuscator.obfuscate((String)accessGrant.getAuthorizationDetails().toJson());
            itemValues.put(AUTHORIZATION_DETAILS, (AttributeValue)AttributeValue.builder().s(obfuscatedAuthorizationDetails).build());
        }
        try {
            if (CollectionUtils.isNotEmpty(attributes)) {
                ObjectMapper mapper = new ObjectMapper();
                String jsonInString = mapper.writeValueAsString(attributes);
                itemValues.put(GRANT_ATTRIBUTES, (AttributeValue)AttributeValue.builder().s(Obfuscator.obfuscate((String)jsonInString)).build());
            }
            PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.tableName).item(itemValues).build();
            try (DSEventTimer ignored = this.getEventTimer("put");){
                this.getDynamoDBClient().putItem(request);
            }
        }
        catch (JsonProcessingException | DynamoDbException e) {
            this.logException((Exception)e);
            throw new AccessGrantManagementException(e);
        }
        this.checkPersistentGrantLimit(accessGrant, this.maxGrantAllowed, this.maxGrantsToDelete);
    }

    public Collection<AccessGrant> getByUserKey(String userKey) {
        return this.queryAccessGrantTableByIndex(UNIQUE_USER_ID_KEY, userKey, this.accessGrantsUniqueUserIdAndClientIdIndex).stream().map(wrapper -> wrapper.accessGrant).collect(Collectors.toList());
    }

    public Collection<AccessGrant> getByClientId(String clientId) throws AccessGrantManagementException {
        return this.queryAccessGrantTableByIndex(CLIENT_ID_KEY, clientId, this.accessGrantsClientIdIndex).stream().map(wrapper -> wrapper.accessGrant).collect(Collectors.toList());
    }

    public void updateRefreshToken(AccessGrant accessGrant) {
        HashMap<String, AttributeValue> itemKey = new HashMap<String, AttributeValue>();
        itemKey.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getGuid()).build());
        HashMap<String, AttributeValueUpdate> updatedValues = new HashMap<String, AttributeValueUpdate>();
        if (StringUtils.isNotBlank((CharSequence)accessGrant.getHashedRefreshTokenValue())) {
            updatedValues.put(HASHED_REFRESH_TOKEN_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(accessGrant.getHashedRefreshTokenValue()).build()).action(AttributeAction.PUT).build());
        }
        updatedValues.put(ISSUED, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getIssued())).build()).action(AttributeAction.PUT).build());
        updatedValues.put(UPDATED, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(System.currentTimeMillis())).build()).action(AttributeAction.PUT).build());
        if (accessGrant.getExpires() != null) {
            updatedValues.put(EXPIRES, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getExpires() / 1000L)).build()).action(AttributeAction.PUT).build());
        }
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(itemKey).attributeUpdates(updatedValues).build();
        try (DSEventTimer ignored = this.getEventTimer("update");){
            this.getDynamoDBClient().updateItem(request);
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        HashMap<String, AttributeValue> itemKey = new HashMap<String, AttributeValue>();
        itemKey.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrant.getGuid()).build());
        HashMap<String, AttributeValueUpdate> updatedValues = new HashMap<String, AttributeValueUpdate>();
        if (accessGrant.getExpires() != null) {
            updatedValues.put(EXPIRES, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getExpires() / 1000L)).build()).action(AttributeAction.PUT).build());
        } else {
            updatedValues.put(EXPIRES, (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).build());
        }
        updatedValues.put(ISSUED, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(accessGrant.getIssued())).build()).action(AttributeAction.PUT).build());
        updatedValues.put(UPDATED, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(System.currentTimeMillis())).build()).action(AttributeAction.PUT).build());
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(itemKey).attributeUpdates(updatedValues).build();
        try (DSEventTimer ignored = this.getEventTimer("update");){
            this.getDynamoDBClient().updateItem(request);
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public Collection<AccessGrant> getByUserKeyClientIdGrantType(String userKey, String clientId, String grantType) throws AccessGrantManagementException {
        try {
            List<Map<String, AttributeValue>> grants;
            QueryResponse response;
            HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
            Condition userKeyCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(userKey).build()}).build();
            conditionMap.put(UNIQUE_USER_ID_KEY, userKeyCondition);
            Condition clientIdCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(clientId).build()}).build();
            conditionMap.put(CLIENT_ID_KEY, clientIdCondition);
            QueryRequest queryReq = (QueryRequest)QueryRequest.builder().tableName(this.tableName).keyConditions(conditionMap).indexName(this.accessGrantsUniqueUserIdAndClientIdIndex).build();
            try (DSEventTimer ignored = this.getEventTimer("query");){
                response = this.getDynamoDBClient().query(queryReq);
            }
            if (response.items().isEmpty()) {
                return Collections.emptyList();
            }
            AttributeValue defaultStr = (AttributeValue)AttributeValue.builder().s("").build();
            List<Map<String, AttributeValue>> keys = response.items().stream().filter(map -> grantType.equals(map.getOrDefault(GRANT_TYPE, defaultStr).s())).map(map -> map.getOrDefault(GUID_KEY, defaultStr).s()).filter(guid -> !"".equals(guid)).map(guid -> Collections.singletonMap(GUID_KEY, (AttributeValue)AttributeValue.builder().s(guid).build())).collect(Collectors.toList());
            if (keys.isEmpty()) {
                return Collections.emptyList();
            }
            try (DSEventTimer ignored = this.getEventTimer("get");){
                grants = this.dynamoDBClientUtil.getAll(this.tableName, keys, this.batchSize);
            }
            return grants.stream().map(this::buildAccessGrantFromResponse).filter(grantWrapper -> grantWrapper.getAccessGrant() != null).map(grantWrapper -> grantWrapper.accessGrant).collect(Collectors.toList());
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    public void deleteExpiredGrants() {
    }

    protected Collection<AccessGrantAttribute> retrieveGrantAttributes(String accessGrantGuid) {
        return this.getGrantWrapperByGuid(accessGrantGuid).getAccessGrantAttributes();
    }

    protected void updateGrantAttributes(String accessGrantGuid, Collection<AccessGrantAttribute> attributes) {
        HashMap<String, AttributeValue> itemKey = new HashMap<String, AttributeValue>();
        itemKey.put(GUID_KEY, (AttributeValue)AttributeValue.builder().s(accessGrantGuid).build());
        HashMap<String, AttributeValueUpdate> updatedValues = new HashMap<String, AttributeValueUpdate>();
        try (DSEventTimer ignored = this.getEventTimer("update");){
            if (CollectionUtils.isNotEmpty(attributes)) {
                ObjectMapper mapper = new ObjectMapper();
                String jsonInString = mapper.writeValueAsString(attributes);
                updatedValues.put(GRANT_ATTRIBUTES, (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(Obfuscator.obfuscate((String)jsonInString)).build()).action(AttributeAction.PUT).build());
            }
            UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(itemKey).attributeUpdates(updatedValues).build();
            this.getDynamoDBClient().updateItem(request);
        }
        catch (JsonProcessingException | DynamoDbException e) {
            this.logException((Exception)e);
            throw new AccessGrantManagementException(e);
        }
    }

    private List<AccessGrant> getPersistentGrantsForLimitCheck(String userKey, String clientId, String grantType, String contextQualifier) {
        try {
            QueryResponse response;
            HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
            Condition userKeyCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(userKey).build()}).build();
            conditionMap.put(UNIQUE_USER_ID_KEY, userKeyCondition);
            Condition clientIdCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(clientId).build()}).build();
            conditionMap.put(CLIENT_ID_KEY, clientIdCondition);
            QueryRequest queryReq = (QueryRequest)QueryRequest.builder().tableName(this.tableName).keyConditions(conditionMap).indexName(this.accessGrantsUniqueUserIdAndClientIdIndex).build();
            try (DSEventTimer ignored = this.getEventTimer("query");){
                response = this.getDynamoDBClient().query(queryReq);
            }
            if (response.items().isEmpty()) {
                return Collections.emptyList();
            }
            AttributeValue defaultStr = (AttributeValue)AttributeValue.builder().s("").build();
            return response.items().stream().filter(map -> grantType.equals(map.getOrDefault(GRANT_TYPE, defaultStr).s()) && contextQualifier.equals(map.getOrDefault(CONTEXTUAL_QUALIFIER, defaultStr).s())).map(this::buildAccessGrantFromResponse).filter(grantWrapper -> grantWrapper.getAccessGrant() != null).map(grantWrapper -> grantWrapper.accessGrant).sorted(Comparator.comparingLong(AccessGrant::getUpdated)).collect(Collectors.toList());
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private void checkPersistentGrantLimit(AccessGrant accessGrant, int maxGrantAllowed, int maxGrantsToDelete) {
        List<AccessGrant> grants;
        if (maxGrantAllowed > 0 && (grants = this.getPersistentGrantsForLimitCheck(accessGrant.getUniqueUserIdentifer(), accessGrant.getClientId(), accessGrant.getGrantType(), accessGrant.getContextualQualifier())).size() > maxGrantAllowed) {
            int exceedByAmt = grants.size() - maxGrantAllowed;
            int numGrantsToDelete = maxGrantsToDelete > 0 && exceedByAmt > maxGrantsToDelete ? maxGrantsToDelete : exceedByAmt;
            int numDeletedGrants = 0;
            Iterator<AccessGrant> grantsIter = grants.iterator();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing grants using parameters \nuserKey: " + accessGrant.getUniqueUserIdentifer() + "\nclientId: " + accessGrant.getClientId() + "\ngrantType: " + accessGrant.getGrantType() + "\ncontextQualifier: " + accessGrant.getContextualQualifier()));
            }
            while (grantsIter.hasNext() && numDeletedGrants < numGrantsToDelete) {
                AccessGrant grantToDelete = grantsIter.next();
                try {
                    this.deleteGrant(grantToDelete.getGuid());
                    ++numDeletedGrants;
                }
                catch (AccessGrantManagementException agme) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Exception thrown while deleting a grant during persistent grant limit cleanup. It is possible multiple deletes are occurring for the same grant.");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + numDeletedGrants + " grant(s)."));
            }
        }
    }

    public AccessGrant getByAccessGrantCriteria(AccessGrantCriteria accessGrantCriteria) throws AccessGrantManagementException {
        try {
            List<Map<String, AttributeValue>> grants;
            HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
            Condition userKeyCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(accessGrantCriteria.getUserKey()).build()}).build();
            conditionMap.put(UNIQUE_USER_ID_KEY, userKeyCondition);
            Condition clientIdCondition = (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(accessGrantCriteria.getClientId()).build()}).build();
            conditionMap.put(CLIENT_ID_KEY, clientIdCondition);
            QueryRequest queryReq = (QueryRequest)QueryRequest.builder().tableName(this.tableName).keyConditions(conditionMap).indexName(this.accessGrantsUniqueUserIdAndClientIdIndex).build();
            QueryResponse response = this.getDynamoDBClient().query(queryReq);
            if (response.items().isEmpty()) {
                return null;
            }
            AttributeValue defaultStr = (AttributeValue)AttributeValue.builder().s("").build();
            List<Map<String, AttributeValue>> keys = response.items().stream().filter(map -> accessGrantCriteria.getScope().isEqualOrLesserThan(new Scope(map.getOrDefault(SCOPE, defaultStr).s())) && accessGrantCriteria.getGrantType().equals(map.getOrDefault(GRANT_TYPE, defaultStr).s()) && accessGrantCriteria.getContextQualifier().equals(map.getOrDefault(CONTEXTUAL_QUALIFIER, defaultStr).s())).map(map -> map.getOrDefault(GUID_KEY, defaultStr).s()).filter(guid -> !"".equals(guid)).map(guid -> Collections.singletonMap(GUID_KEY, (AttributeValue)AttributeValue.builder().s(guid).build())).collect(Collectors.toList());
            if (keys.isEmpty()) {
                return null;
            }
            try (DSEventTimer ignored = this.getEventTimer("get");){
                grants = this.dynamoDBClientUtil.getAll(this.tableName, keys, this.batchSize);
            }
            return grants.stream().map(this::buildAccessGrantFromResponse).filter(grantWrapper -> {
                if (grantWrapper.getAccessGrant() != null) {
                    AuthorizationDetails authorizationDetails = grantWrapper.getAccessGrant().getAuthorizationDetails();
                    AuthorizationDetailContext context = new AuthorizationDetailContext(null, grantWrapper.getAccessGrant().getClientId(), grantWrapper.getAccessGrant().getScope());
                    return AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)accessGrantCriteria.getAuthorizationDetails(), (AuthorizationDetails)authorizationDetails, (AuthorizationDetailContext)context);
                }
                return false;
            }).map(grantWrapper -> grantWrapper.accessGrant).findFirst().orElse(null);
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public AccessGrant getByUserKeyScopeClientIdGrantTypeContext(String userKey, Scope scope, String clientId, String grantType, String contextQualifier) {
        return this.getByAccessGrantCriteria(new AccessGrantCriteria(userKey, scope, clientId, grantType, contextQualifier, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<GrantWrapper> queryAccessGrantTableByIndex(String partitionKeyName, String partitionKeyVal, String indexName) {
        try (DSEventTimer ignored = this.getEventTimer("query");){
            QueryResponse response = this.dynamoDBClientUtil.queryIndex(partitionKeyName, partitionKeyVal, indexName, this.tableName, GUID_KEY);
            if (response.items().isEmpty()) {
                List<GrantWrapper> list = Collections.emptyList();
                return list;
            }
            List<Map<String, AttributeValue>> keys = response.items().stream().map(map -> map.getOrDefault(GUID_KEY, (AttributeValue)AttributeValue.builder().s("").build()).s()).filter(guid -> !"".equals(guid)).map(guid -> Collections.singletonMap(GUID_KEY, (AttributeValue)AttributeValue.builder().s(guid).build())).collect(Collectors.toList());
            if (keys.isEmpty()) {
                List<GrantWrapper> list = Collections.emptyList();
                return list;
            }
            Collection collection = this.dynamoDBClientUtil.getAll(this.tableName, keys, this.batchSize).stream().map(this::buildAccessGrantFromResponse).filter(grantWrapper -> grantWrapper.getAccessGrant() != null).collect(Collectors.toList());
            return collection;
        }
        catch (DynamoDbException e) {
            this.logException((Exception)((Object)e));
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private GrantWrapper buildAccessGrantFromResponse(Map<String, AttributeValue> accessGrantMap) {
        GrantWrapper grantWrapper = new GrantWrapper(null, Collections.emptyList());
        if (MapUtils.isNotEmpty(accessGrantMap)) {
            String attributesString;
            AttributeValue emptyStringValue = (AttributeValue)AttributeValue.builder().s("").build();
            AttributeValue zeroLongValue = (AttributeValue)AttributeValue.builder().n("0").build();
            AccessGrant accessGrant = new AccessGrant(accessGrantMap.getOrDefault(HASHED_REFRESH_TOKEN_KEY, emptyStringValue).s(), accessGrantMap.getOrDefault(GUID_KEY, emptyStringValue).s(), accessGrantMap.getOrDefault(UNIQUE_USER_ID_KEY, emptyStringValue).s(), accessGrantMap.getOrDefault(GRANT_TYPE, emptyStringValue).s(), Scope.getScope((String)accessGrantMap.getOrDefault(SCOPE, emptyStringValue).s()), accessGrantMap.getOrDefault(CLIENT_ID_KEY, emptyStringValue).s(), Long.parseLong(accessGrantMap.getOrDefault(ISSUED, zeroLongValue).n()), Long.parseLong(accessGrantMap.getOrDefault(UPDATED, zeroLongValue).n()), Long.valueOf(Long.parseLong(accessGrantMap.getOrDefault(EXPIRES, zeroLongValue).n()) * 1000L), accessGrantMap.getOrDefault(CONTEXTUAL_QUALIFIER, emptyStringValue).s());
            AttributeValue obfuscatedAuthorizationDetailJson = accessGrantMap.get(AUTHORIZATION_DETAILS);
            if (obfuscatedAuthorizationDetailJson != null) {
                try {
                    String authorizationDetailJson = Obfuscator.deobfuscate((String)obfuscatedAuthorizationDetailJson.s());
                    accessGrant.setAuthorizationDetails(new AuthorizationDetails(authorizationDetailJson));
                }
                catch (IOException e) {
                    log.debug((Object)"unable to deserialize authorization detail", (Throwable)e);
                }
            }
            Collection<Object> accessGrantAttributes = new ArrayList<AccessGrantAttribute>();
            if (accessGrantMap.containsKey(GRANT_ATTRIBUTES) && StringUtils.isNotBlank((CharSequence)(attributesString = accessGrantMap.get(GRANT_ATTRIBUTES).s()))) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    attributesString = Obfuscator.deobfuscate((String)attributesString);
                    accessGrantAttributes = (Collection)mapper.readValue(attributesString, (JavaType)mapper.getTypeFactory().constructCollectionType(Collection.class, AccessGrantAttribute.class));
                }
                catch (IOException e) {
                    this.logException(e);
                    throw new AccessGrantManagementException((Throwable)e);
                }
            }
            if (accessGrant.isExpired()) {
                this.deleteGrant(accessGrant.getGuid());
                accessGrant = null;
                accessGrantAttributes = new ArrayList();
            }
            grantWrapper = new GrantWrapper(accessGrant, accessGrantAttributes);
        }
        return grantWrapper;
    }

    private DynamoDbClient getDynamoDBClient() {
        return this.dynamoDBClientUtil.getDynamoDBClient();
    }

    private DSEventTimer getEventTimer(String eventType) {
        return DSEventTimer.getDynamoDBInstance((String)eventType, (ServiceInformation)this);
    }

    private static class GrantWrapper {
        private final AccessGrant accessGrant;
        private final Collection<AccessGrantAttribute> accessGrantAttributes;

        public GrantWrapper(AccessGrant accessGrant, Collection<AccessGrantAttribute> accessGrantAttributes) {
            this.accessGrant = accessGrant;
            this.accessGrantAttributes = accessGrantAttributes;
        }

        public AccessGrant getAccessGrant() {
            return this.accessGrant;
        }

        public Collection<AccessGrantAttribute> getAccessGrantAttributes() {
            return this.accessGrantAttributes;
        }
    }
}

