/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.configservice.AutoReloadable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.dynamo.DynamoDBClientUtil;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.impl.AccountLinkingServiceBase;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;

public class AccountLinkingServiceDynamoDBImpl
extends AccountLinkingServiceBase
implements AccountLinkingService,
AutoReloadable {
    private static final String PARTITION_KEY_NAME = "Id";
    private static final String PUT_ITEM_REQUEST_UNIQUE_CONDITION_EXPRESSION = "attribute_not_exists(Id)";
    private static final String IDP_ENTITY_ID_ATTRIBUTE_NAME = "IdPEntityId";
    private static final String EXTERNAL_USER_ID_ATTRIBUTE_NAME = "ExternalUserId";
    private static final String ADAPTER_ID_ATTRIBUTE_NAME = "AdapterId";
    private static final String LOCAL_USER_ID_ATTRIBUTE_NAME = "LocalUserId";
    private static final String DATE_CREATED_ATTRIBUTE_NAME = "DateCreated";
    private static final ConfigStore CONFIG_STORE = ConfigStoreFarm.getConfig((String)"org.sourceid.saml20.service.impl.AccountLinkingServiceDynamoDBImpl");
    private static final String CONFIG_TABLE_NAME = "AccountLinkingTableName";
    private static final String CONFIG_DEFAULT_TABLE_NAME = "PingFederateAccountLink";
    private static final String CONFIG_API_CALL_TIMEOUT = "ApiCallTimeout";
    private static final long CONFIG_DEFAULT_API_CALL_TIMEOUT = 10000L;
    private static final String CONFIG_API_CALL_ATTEMPT_TIMEOUT = "ApiCallAttemptTimeout";
    private static final long CONFIG_DEFAULT_API_CALL_ATTEMPT_TIMEOUT = 1000L;
    private static final String CONFIG_ENDPOINT_OVERRIDE = "EndpointOverride";
    private static final String CONFIG_DEFAULT_ENDPOINT_OVERRIDE = null;
    private final String tableName = CONFIG_STORE.getStringValue("AccountLinkingTableName", "PingFederateAccountLink");
    private final DynamoDBClientUtil dynamoDBClientUtil;

    public AccountLinkingServiceDynamoDBImpl() {
        DynamoDBConfiguration dynamoDbConfiguration = new DynamoDBConfiguration(CONFIG_STORE.getLongValue(CONFIG_API_CALL_TIMEOUT, 10000L), CONFIG_STORE.getLongValue(CONFIG_API_CALL_ATTEMPT_TIMEOUT, 1000L), (String)StringUtils.defaultIfEmpty((CharSequence)CONFIG_STORE.getStringValue(CONFIG_ENDPOINT_OVERRIDE, CONFIG_DEFAULT_ENDPOINT_OVERRIDE), (CharSequence)CONFIG_DEFAULT_ENDPOINT_OVERRIDE));
        this.dynamoDBClientUtil = DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.CLIENTS, dynamoDbConfiguration);
    }

    public String lookupLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        Map attributes;
        GetItemResponse response;
        Map<String, AttributeValue> primaryKeyAttributes = this.getPrimaryKeyAttributes(idpEntityId, authnAdapterId, externalIdentifier);
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(this.tableName).key(primaryKeyAttributes).build();
        try (DSEventTimer ignored = this.getEventTimer("get");){
            response = this.dynamoDBClientUtil.getDynamoDBClient().getItem(request);
        }
        if (response.hasItem() && (attributes = response.item()).containsKey(LOCAL_USER_ID_ATTRIBUTE_NAME)) {
            return ((AttributeValue)attributes.get(LOCAL_USER_ID_ATTRIBUTE_NAME)).s();
        }
        return null;
    }

    public void storeLink(String localIdentifier, String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        Map<String, AttributeValue> attributes = this.getPrimaryKeyAttributes(idpEntityId, authnAdapterId, externalIdentifier);
        attributes.put(IDP_ENTITY_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(idpEntityId).build());
        attributes.put(EXTERNAL_USER_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(externalIdentifier).build());
        attributes.put(ADAPTER_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(authnAdapterId).build());
        attributes.put(LOCAL_USER_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(localIdentifier).build());
        attributes.put(DATE_CREATED_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(String.valueOf(System.currentTimeMillis())).build());
        PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.tableName).item(attributes).conditionExpression(PUT_ITEM_REQUEST_UNIQUE_CONDITION_EXPRESSION).build();
        try (DSEventTimer ignored = this.getEventTimer("put");){
            this.dynamoDBClientUtil.getDynamoDBClient().putItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            throw new AccountLinkingServiceException("Account link item already exists.", (Throwable)e);
        }
    }

    public void terminateLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        Map<String, AttributeValue> primaryKeyAttributes = this.getPrimaryKeyAttributes(idpEntityId, authnAdapterId, externalIdentifier);
        DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.tableName).key(primaryKeyAttributes).build();
        try (DSEventTimer ignored = this.getEventTimer("delete");){
            this.dynamoDBClientUtil.getDynamoDBClient().deleteItem(deleteRequest);
        }
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    private Map<String, AttributeValue> getPrimaryKeyAttributes(String idpEntityId, String authnAdapterId, String externalIdentifier) {
        String key = String.join((CharSequence)"", idpEntityId, externalIdentifier, authnAdapterId);
        String base64 = Base64URL.encodeToString((byte[])key.getBytes(StandardCharsets.UTF_8));
        HashMap<String, AttributeValue> primaryKey = new HashMap<String, AttributeValue>();
        primaryKey.put(PARTITION_KEY_NAME, (AttributeValue)AttributeValue.builder().s(base64).build());
        return primaryKey;
    }

    private DSEventTimer getEventTimer(String eventType) {
        return DSEventTimer.getDynamoDBInstance((String)eventType, (ServiceInformation)this);
    }
}

