/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session.data.impl;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.dynamo.DynamoDBClientUtil;
import org.sourceid.dynamo.DynamoDBConfiguration;
import org.sourceid.saml20.service.session.data.AbstractSessionStorageManagerImpl;
import org.sourceid.saml20.service.session.data.AuthnSessionData;
import org.sourceid.saml20.service.session.data.SessionGroupAndSessionsData;
import org.sourceid.saml20.service.session.data.SessionGroupData;
import org.sourceid.saml20.service.session.data.SessionStorageException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class SessionStorageManagerDynamoDBImpl
extends AbstractSessionStorageManagerImpl {
    static final String SESSION_GROUP_ID_ATTRIBUTE_NAME = "SessionGroupId";
    static final String HASHED_SESSION_ID_ATTRIBUTE_NAME = "HashedSessionId";
    static final String PARENT_GROUP_ID_ATTRIBUTE_NAME = "ParentSessionGroupId";
    static final String EXPIRY_TIME_ATTRIBUTE_NAME = "ExpiryTime";
    static final String LAST_ACTIVITY_TIME_ATTRIBUTE_NAME = "LastActivityTime";
    static final String METADATA_ATTRIBUTE_NAME = "Metadata";
    static final String USER_ID_ATTRIBUTE_NAME = "UserId";
    static final String AUTHENTICATION_SESSION_DATA_MAP_ATTRIBUTE_NAME = "SessionDataMap";
    static final String CONFIG_SESSION_GROUP_TABLE_NAME = "SessionGroupTableName";
    static final String CONFIG_USER_ID_TABLE_NAME = "UserIdTableName";
    static final String CONFIG_SESSION_GROUP_DEFAULT_TABLE_NAME = "PingFederateAuthenticationSessionGroup";
    static final String CONFIG_USER_ID_DEFAULT_TABLE_NAME = "PingFederateAuthenticationSessionUserId";
    static final String CONFIG_HASHED_SESSION_ID_INDEX_NAME = "HashedSessionIdIndexName";
    static final String CONFIG_SESSION_USER_ID_GROUP_ID_INDEX_NAME = "SessionUserIdGroupIdIndexName";
    static final String CONFIG_HASHED_SESSION_ID_DEFAULT_INDEX_NAME = "PingFederateAuthenticationSessionHashedSessionId-index";
    static final String CONFIG_SESSION_USER_ID_GROUP_ID_DEFAULT_INDEX_NAME = "PingFederateAuthenticationSessionUserIdGroupId-index";
    private static final String ATTRIBUTE_HASH_NAME_PLACEHOLDER = "#authnSessionAttributeHash";
    private static final String SESSION_DATA_VALUE_PLACEHOLDER = ":sessionData";
    private static final String CONFIG_API_CALL_TIMEOUT = "ApiCallTimeout";
    private static final String CONFIG_API_CALL_ATTEMPT_TIMEOUT = "ApiCallAttemptTimeout";
    private static final String CONFIG_ENDPOINT_OVERRIDE = "EndpointOverride";
    private static final long CONFIG_DEFAULT_API_CALL_TIMEOUT = 10000L;
    private static final long CONFIG_DEFAULT_API_CALL_ATTEMPT_TIMEOUT = 1000L;
    private static final int CONFIG_DEFAULT_DYNAMO_DB_BATCH_SIZE = 50;
    private static final String CONFIG_DYNAMO_DB_BATCH_SIZE = "dynamoDbBatchSize";
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"org.sourceid.saml20.service.session.data.impl.SessionStorageManagerDynamoDBImpl");
    private final String sessionGroupTableName = configStore.getStringValue("SessionGroupTableName", "PingFederateAuthenticationSessionGroup");
    private final String userIdTableName = configStore.getStringValue("UserIdTableName", "PingFederateAuthenticationSessionUserId");
    private final String hashedSessionGroupIndex = configStore.getStringValue("HashedSessionIdIndexName", "PingFederateAuthenticationSessionHashedSessionId-index");
    private final String sessionGroupIdUserIdIndex = configStore.getStringValue("SessionUserIdGroupIdIndexName", "PingFederateAuthenticationSessionUserIdGroupId-index");
    private final int batchSize;
    private final DynamoDBClientUtil dynamoDBClientUtil;

    public SessionStorageManagerDynamoDBImpl() {
        int configuredBatchSize = configStore.getIntValue(CONFIG_DYNAMO_DB_BATCH_SIZE, 50);
        this.batchSize = DynamoDBConfiguration.getBatchSize(50, configuredBatchSize);
        long apiCallTimeout = configStore.getLongValue(CONFIG_API_CALL_TIMEOUT, 10000L);
        long apiCallAttemptTimeout = configStore.getLongValue(CONFIG_API_CALL_ATTEMPT_TIMEOUT, 1000L);
        String endpointOverride = (String)StringUtils.defaultIfEmpty((CharSequence)configStore.getStringValue(CONFIG_ENDPOINT_OVERRIDE, null), null);
        DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration(apiCallTimeout, apiCallAttemptTimeout, endpointOverride);
        this.dynamoDBClientUtil = DynamoDBClientUtil.getInstance(DynamoDBClientUtil.DynamoDBService.AUTHN_SESSION, dynamoDBConfiguration);
    }

    public void createSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        HashMap<String, AttributeValue> sessionGroupItems = new HashMap<String, AttributeValue>();
        sessionGroupItems.put(SESSION_GROUP_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(sessionGroupData.getId()).build());
        sessionGroupItems.put(HASHED_SESSION_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(sessionGroupData.getHashedSessionId()).build());
        sessionGroupItems.put(AUTHENTICATION_SESSION_DATA_MAP_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().m(Collections.emptyMap()).build());
        sessionGroupItems.put(EXPIRY_TIME_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().n(String.valueOf(sessionGroupData.getExpiryTimeMillis() / 1000L)).build());
        sessionGroupItems.put(LAST_ACTIVITY_TIME_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().n(String.valueOf(sessionGroupData.getLastActivityTimeMillis() / 1000L)).build());
        if (StringUtils.isNotBlank((CharSequence)sessionGroupData.getParentGroupId())) {
            sessionGroupItems.put(PARENT_GROUP_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(sessionGroupData.getParentGroupId()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)sessionGroupData.getMetadata())) {
            sessionGroupItems.put(METADATA_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(sessionGroupData.getMetadata()).build());
        }
        PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.sessionGroupTableName).item(sessionGroupItems).build();
        try (DSEventTimer ignored = this.getEventTimer("put");){
            this.getDynamoDBClientInstance().putItem(request);
        }
        catch (SdkClientException | DynamoDbException e) {
            throw new SessionStorageException("Error creating session group", e);
        }
    }

    DynamoDbClient getDynamoDBClientInstance() {
        return this.dynamoDBClientUtil.getDynamoDBClient();
    }

    public void updateSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        block24: {
            HashMap<String, AttributeValue> itemKey = SessionStorageManagerDynamoDBImpl.getSessionGroupTableKeyEntry(sessionGroupData.getId());
            HashMap<String, AttributeValueUpdate> sessionGroupItems = new HashMap<String, AttributeValueUpdate>();
            sessionGroupItems.put(HASHED_SESSION_ID_ATTRIBUTE_NAME, SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getHashedSessionId()));
            sessionGroupItems.put(EXPIRY_TIME_ATTRIBUTE_NAME, SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getExpiryTimeMillis()));
            sessionGroupItems.put(LAST_ACTIVITY_TIME_ATTRIBUTE_NAME, SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getLastActivityTimeMillis()));
            if (StringUtils.isNotBlank((CharSequence)sessionGroupData.getParentGroupId())) {
                sessionGroupItems.put(PARENT_GROUP_ID_ATTRIBUTE_NAME, SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getParentGroupId()));
            }
            if (StringUtils.isNotBlank((CharSequence)sessionGroupData.getMetadata())) {
                sessionGroupItems.put(METADATA_ATTRIBUTE_NAME, SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getMetadata()));
            }
            UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.sessionGroupTableName).key(itemKey).attributeUpdates(sessionGroupItems).build();
            try {
                QueryResponse usersForSessionGroupResponse;
                try (DSEventTimer ignored = this.getEventTimer("update");){
                    this.getDynamoDBClientInstance().updateItem(request);
                }
                try (DSEventTimer ignored = this.getEventTimer("query");){
                    usersForSessionGroupResponse = this.dynamoDBClientUtil.queryIndex(SESSION_GROUP_ID_ATTRIBUTE_NAME, sessionGroupData.getId(), this.sessionGroupIdUserIdIndex, this.userIdTableName, USER_ID_ATTRIBUTE_NAME, SESSION_GROUP_ID_ATTRIBUTE_NAME);
                }
                if (!usersForSessionGroupResponse.hasItems() || usersForSessionGroupResponse.items().isEmpty()) break block24;
                for (Map userItem : usersForSessionGroupResponse.items()) {
                    HashMap<String, AttributeValue> userKeys = new HashMap<String, AttributeValue>();
                    userKeys.put(SESSION_GROUP_ID_ATTRIBUTE_NAME, (AttributeValue)userItem.get(SESSION_GROUP_ID_ATTRIBUTE_NAME));
                    userKeys.put(USER_ID_ATTRIBUTE_NAME, (AttributeValue)userItem.get(USER_ID_ATTRIBUTE_NAME));
                    AttributeValueUpdate attributeValueUpdate = SessionStorageManagerDynamoDBImpl.buildAttributeValueUpdateForPut(sessionGroupData.getExpiryTimeMillis());
                    Map<String, AttributeValueUpdate> attrUpdates = Collections.singletonMap(EXPIRY_TIME_ATTRIBUTE_NAME, attributeValueUpdate);
                    UpdateItemRequest updateUsers = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.userIdTableName).key(userKeys).attributeUpdates(attrUpdates).build();
                    DSEventTimer ignored = this.getEventTimer("update");
                    try {
                        this.getDynamoDBClientInstance().updateItem(updateUsers);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error while updating session group", e);
            }
        }
    }

    private static HashMap<String, AttributeValue> getSessionGroupTableKeyEntry(String keyAttributeValue) {
        HashMap<String, AttributeValue> itemKey = new HashMap<String, AttributeValue>();
        itemKey.put(SESSION_GROUP_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(keyAttributeValue).build());
        return itemKey;
    }

    private static AttributeValueUpdate buildAttributeValueUpdateForPut(String stringValue) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(stringValue).build()).action(AttributeAction.PUT).build();
    }

    private static AttributeValueUpdate buildAttributeValueUpdateForPut(long longValue) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(longValue / 1000L)).build()).action(AttributeAction.PUT).build();
    }

    public void deleteSessionGroups(Collection<String> hashedSessionIds) throws SessionStorageException {
        if (hashedSessionIds != null) {
            try {
                for (String hashedSessionId : hashedSessionIds) {
                    QueryResponse response;
                    try (DSEventTimer ignored = this.getEventTimer("query");){
                        response = this.dynamoDBClientUtil.queryIndex(HASHED_SESSION_ID_ATTRIBUTE_NAME, hashedSessionId, this.hashedSessionGroupIndex, this.sessionGroupTableName, SESSION_GROUP_ID_ATTRIBUTE_NAME);
                    }
                    if (!response.hasItems() || response.items().isEmpty()) continue;
                    for (Map sessionGroupEntry : response.items()) {
                        List<String> ids = Collections.singletonList(((AttributeValue)sessionGroupEntry.get(SESSION_GROUP_ID_ATTRIBUTE_NAME)).s());
                        this.deleteSessionGroupsByGroupIds(ids);
                    }
                }
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error while deleting session groups with hashed session id", e);
            }
        }
    }

    public void deleteSessionGroupsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        try {
            for (String sessionGroupId : sessionGroupIds) {
                QueryResponse userIndexQueryResponse;
                ArrayList<TransactWriteItem> deleteTransactionItems = new ArrayList<TransactWriteItem>();
                HashMap<String, AttributeValue> itemKey = SessionStorageManagerDynamoDBImpl.getSessionGroupTableKeyEntry(sessionGroupId);
                Delete sessionGroupDelete = (Delete)Delete.builder().tableName(this.sessionGroupTableName).key(itemKey).returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.NONE).build();
                deleteTransactionItems.add((TransactWriteItem)TransactWriteItem.builder().delete(sessionGroupDelete).build());
                try (Object ignored = this.getEventTimer("query");){
                    userIndexQueryResponse = this.dynamoDBClientUtil.queryIndex(SESSION_GROUP_ID_ATTRIBUTE_NAME, sessionGroupId, this.sessionGroupIdUserIdIndex, this.userIdTableName, USER_ID_ATTRIBUTE_NAME, SESSION_GROUP_ID_ATTRIBUTE_NAME);
                }
                if (userIndexQueryResponse.hasItems() && !userIndexQueryResponse.items().isEmpty()) {
                    for (Map userEntry : userIndexQueryResponse.items()) {
                        HashMap<String, AttributeValue> userItemKey = new HashMap<String, AttributeValue>();
                        userItemKey.put(USER_ID_ATTRIBUTE_NAME, (AttributeValue)userEntry.get(USER_ID_ATTRIBUTE_NAME));
                        userItemKey.put(SESSION_GROUP_ID_ATTRIBUTE_NAME, (AttributeValue)userEntry.get(SESSION_GROUP_ID_ATTRIBUTE_NAME));
                        Delete deleteUserEntry = (Delete)Delete.builder().tableName(this.userIdTableName).key(userItemKey).returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.NONE).build();
                        deleteTransactionItems.add((TransactWriteItem)TransactWriteItem.builder().delete(deleteUserEntry).build());
                    }
                }
                ignored = this.getEventTimer("transaction");
                try {
                    TransactWriteItemsRequest transactWriteItemsRequest = (TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(deleteTransactionItems).build();
                    this.getDynamoDBClientInstance().transactWriteItems(transactWriteItemsRequest);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        catch (SdkClientException | DynamoDbException e) {
            throw new SessionStorageException("Error while deleting session groups with session group ids.", e);
        }
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessions(Collection<String> hashedSessionIds) throws SessionStorageException {
        Collection<String> sessionIds = Collections.emptyList();
        for (String hashedSessionId : hashedSessionIds) {
            QueryResponse response;
            try (DSEventTimer ignored = this.getEventTimer("query");){
                response = this.dynamoDBClientUtil.queryIndex(HASHED_SESSION_ID_ATTRIBUTE_NAME, hashedSessionId, this.hashedSessionGroupIndex, this.sessionGroupTableName, SESSION_GROUP_ID_ATTRIBUTE_NAME);
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error while retrieving the hashed session entry for id: " + hashedSessionId, e);
            }
            if (!response.hasItems() || response.items().isEmpty()) continue;
            sessionIds = response.items().stream().map(indexEntry -> ((AttributeValue)indexEntry.get(SESSION_GROUP_ID_ATTRIBUTE_NAME)).s()).collect(Collectors.toList());
        }
        return this.getSessionGroupsAndSessionsByGroupIds(sessionIds);
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessionsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        ArrayList<SessionGroupAndSessionsData> sessionGroupAndSessionsDatas = new ArrayList<SessionGroupAndSessionsData>();
        List<Map<String, AttributeValue>> keys = sessionGroupIds.stream().map(id -> {
            AttributeValue attributeValue = (AttributeValue)AttributeValue.builder().s(id).build();
            return Collections.singletonMap(SESSION_GROUP_ID_ATTRIBUTE_NAME, attributeValue);
        }).collect(Collectors.toList());
        try {
            List<Map<String, AttributeValue>> sessionGroupEntries;
            try (DSEventTimer ignored = this.getEventTimer("get");){
                sessionGroupEntries = this.dynamoDBClientUtil.getAll(this.sessionGroupTableName, keys, this.batchSize);
            }
            for (Map<String, AttributeValue> sessionGroupEntry : sessionGroupEntries) {
                String sessionGroupId = sessionGroupEntry.get(SESSION_GROUP_ID_ATTRIBUTE_NAME).s();
                SessionGroupData sessionGroupData = this.getSessionGroupData(sessionGroupEntry);
                Collection<AuthnSessionData> authnSessions = SessionStorageManagerDynamoDBImpl.getAuthnSessions(sessionGroupEntry, sessionGroupId);
                Collection<String> userIds = this.getUserIds(sessionGroupId);
                SessionGroupAndSessionsData sessionGroupAndSessionsData = new SessionGroupAndSessionsData();
                sessionGroupAndSessionsData.setSessionGroupData(sessionGroupData);
                sessionGroupAndSessionsData.setAuthnSessions(authnSessions);
                sessionGroupAndSessionsData.setUniqueUserIds(userIds);
                sessionGroupAndSessionsDatas.add(sessionGroupAndSessionsData);
            }
        }
        catch (SdkClientException | DynamoDbException e) {
            throw new SessionStorageException("Error retrieving session groups, sessions and unique user Ids", e);
        }
        return sessionGroupAndSessionsDatas;
    }

    private SessionGroupData getSessionGroupData(Map<String, AttributeValue> sessionGroupEntry) {
        SessionGroupData sessionGroupData = new SessionGroupData();
        sessionGroupData.setId(this.getValueFromMap(sessionGroupEntry, SESSION_GROUP_ID_ATTRIBUTE_NAME));
        sessionGroupData.setHashedSessionId(this.getValueFromMap(sessionGroupEntry, HASHED_SESSION_ID_ATTRIBUTE_NAME));
        sessionGroupData.setParentGroupId(this.getValueFromMap(sessionGroupEntry, PARENT_GROUP_ID_ATTRIBUTE_NAME));
        sessionGroupData.setMetadata(this.getValueFromMap(sessionGroupEntry, METADATA_ATTRIBUTE_NAME));
        sessionGroupData.setExpiryTimeMillis(this.getTimeValueFromMap(sessionGroupEntry, EXPIRY_TIME_ATTRIBUTE_NAME));
        sessionGroupData.setLastActivityTimeMillis(this.getTimeValueFromMap(sessionGroupEntry, LAST_ACTIVITY_TIME_ATTRIBUTE_NAME));
        return sessionGroupData;
    }

    private static Collection<AuthnSessionData> getAuthnSessions(Map<String, AttributeValue> sessionGroupEntry, String sessionGroupId) {
        Map authnSessionEntries;
        Collection<Object> authnSessions = Collections.emptyList();
        if (sessionGroupEntry.containsKey(AUTHENTICATION_SESSION_DATA_MAP_ATTRIBUTE_NAME) && !(authnSessionEntries = sessionGroupEntry.get(AUTHENTICATION_SESSION_DATA_MAP_ATTRIBUTE_NAME).m()).isEmpty()) {
            authnSessions = authnSessionEntries.entrySet().stream().map(authnSessionEntry -> {
                AuthnSessionData authnSessionData = new AuthnSessionData();
                authnSessionData.setSessionGroupId(sessionGroupId);
                authnSessionData.setAttributeHash((String)authnSessionEntry.getKey());
                authnSessionData.setSessionData(((AttributeValue)authnSessionEntry.getValue()).s());
                return authnSessionData;
            }).collect(Collectors.toList());
        }
        return authnSessions;
    }

    private Collection<String> getUserIds(String sessionGroupId) {
        QueryResponse userIdTableResponse;
        HashSet<String> uniqueUserIds = new HashSet<String>();
        try (DSEventTimer ignored = this.getEventTimer("get");){
            userIdTableResponse = this.dynamoDBClientUtil.queryIndex(SESSION_GROUP_ID_ATTRIBUTE_NAME, sessionGroupId, this.sessionGroupIdUserIdIndex, this.userIdTableName, USER_ID_ATTRIBUTE_NAME);
        }
        if (userIdTableResponse.hasItems() && !userIdTableResponse.items().isEmpty()) {
            for (Map userIdEntry : userIdTableResponse.items()) {
                uniqueUserIds.add(((AttributeValue)userIdEntry.get(USER_ID_ATTRIBUTE_NAME)).s());
            }
        }
        return uniqueUserIds;
    }

    private String getValueFromMap(Map<String, AttributeValue> attributeValueMap, String attributeKey) {
        if (attributeValueMap.containsKey(attributeKey) && attributeValueMap.get(attributeKey) != null) {
            return attributeValueMap.get(attributeKey).s();
        }
        return null;
    }

    private long getTimeValueFromMap(Map<String, AttributeValue> attributeValueMap, String attributeKey) {
        return Long.parseLong(attributeValueMap.get(attributeKey).n()) * 1000L;
    }

    public Collection<SessionGroupData> getSessionGroupsByUniqueUserId(String uniqueUserId) throws SessionStorageException {
        ArrayList<SessionGroupData> sessionGroupData;
        block16: {
            sessionGroupData = new ArrayList<SessionGroupData>();
            try {
                List<Map<String, AttributeValue>> sessionGroupEntries;
                QueryResponse queryResponse;
                try (DSEventTimer ignored = this.getEventTimer("query");){
                    queryResponse = this.dynamoDBClientUtil.queryTable(USER_ID_ATTRIBUTE_NAME, uniqueUserId, this.userIdTableName, ComparisonOperator.EQ, SESSION_GROUP_ID_ATTRIBUTE_NAME);
                }
                if (!queryResponse.hasItems() || queryResponse.items().isEmpty()) break block16;
                try (DSEventTimer ignored = this.getEventTimer("get");){
                    sessionGroupEntries = this.dynamoDBClientUtil.getAll(this.sessionGroupTableName, queryResponse.items(), this.batchSize);
                }
                for (Map<String, AttributeValue> storedSessionEntry : sessionGroupEntries) {
                    sessionGroupData.add(this.getSessionGroupData(storedSessionEntry));
                }
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error retrieving session groups, session data and unique user IDs via unique user key '" + uniqueUserId + "'", e);
            }
        }
        return sessionGroupData;
    }

    public void saveAuthnSessions(Collection<AuthnSessionData> sessionDatas) throws SessionStorageException {
        Map<String, List<AuthnSessionData>> authnSessionDataByGroup = this.getAuthnSessionDataMap(sessionDatas);
        for (Map.Entry<String, List<AuthnSessionData>> authnSessionDataForGroupEntry : authnSessionDataByGroup.entrySet()) {
            HashMap<String, AttributeValue> itemKey = SessionStorageManagerDynamoDBImpl.getSessionGroupTableKeyEntry(authnSessionDataForGroupEntry.getKey());
            HashMap<CallSite, String> attributeHashSessionDataName = new HashMap<CallSite, String>();
            HashMap<CallSite, AttributeValue> attributeHashSessionDataValue = new HashMap<CallSite, AttributeValue>();
            StringBuilder updateExpression = new StringBuilder("SET ");
            int sessionDataCount = authnSessionDataForGroupEntry.getValue().size();
            List<AuthnSessionData> sessionDataForGroup = authnSessionDataForGroupEntry.getValue();
            for (int i = 0; i < sessionDataCount; ++i) {
                updateExpression.append("SessionDataMap.#authnSessionAttributeHash").append(i).append(" = ").append(SESSION_DATA_VALUE_PLACEHOLDER).append(i);
                if (i < sessionDataCount - 1) {
                    updateExpression.append(",");
                    updateExpression.append(" ");
                } else {
                    updateExpression.append(" ");
                }
                attributeHashSessionDataName.put((CallSite)((Object)(ATTRIBUTE_HASH_NAME_PLACEHOLDER + i)), sessionDataForGroup.get(i).getAttributeHash());
                attributeHashSessionDataValue.put((CallSite)((Object)(SESSION_DATA_VALUE_PLACEHOLDER + i)), (AttributeValue)AttributeValue.builder().s(sessionDataForGroup.get(i).getSessionData()).build());
            }
            UpdateItemRequest updateItemRequest = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.sessionGroupTableName).key(itemKey).updateExpression(updateExpression.toString()).expressionAttributeNames(attributeHashSessionDataName).expressionAttributeValues(attributeHashSessionDataValue).build();
            try {
                DSEventTimer ignored = this.getEventTimer("update");
                try {
                    this.getDynamoDBClientInstance().updateItem(updateItemRequest);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (SdkClientException | DynamoDbException ex) {
                throw new SessionStorageException("Error saving authn session data", ex);
            }
        }
    }

    private Map<String, List<AuthnSessionData>> getAuthnSessionDataMap(Collection<AuthnSessionData> sessionDatas) {
        Iterator<AuthnSessionData> sessionDataIterator = sessionDatas.iterator();
        HashMap<String, List<AuthnSessionData>> sessionGroupIdData = new HashMap<String, List<AuthnSessionData>>();
        while (sessionDataIterator.hasNext()) {
            AuthnSessionData session = sessionDataIterator.next();
            List<Object> sessionDataForGroup = sessionGroupIdData.containsKey(session.getSessionGroupId()) ? (List)sessionGroupIdData.get(session.getSessionGroupId()) : new ArrayList<AuthnSessionData>();
            sessionDataForGroup.add(session);
            sessionGroupIdData.put(session.getSessionGroupId(), sessionDataForGroup);
        }
        return sessionGroupIdData;
    }

    public void deleteAuthnSessions(String sessionGroupId, Collection<String> attributeHashes) throws SessionStorageException {
        HashMap<String, AttributeValue> itemKey = SessionStorageManagerDynamoDBImpl.getSessionGroupTableKeyEntry(sessionGroupId);
        for (String attributeHash : attributeHashes) {
            UpdateItemRequest updateItemRequest = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.sessionGroupTableName).key(itemKey).updateExpression("REMOVE SessionDataMap.#authnSessionAttributeHash").expressionAttributeNames(Collections.singletonMap(ATTRIBUTE_HASH_NAME_PLACEHOLDER, attributeHash)).build();
            try {
                DSEventTimer ignored = this.getEventTimer("update");
                try {
                    this.getDynamoDBClientInstance().updateItem(updateItemRequest);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error deleting authn session data", e);
            }
        }
    }

    public void addUniqueUserId(String sessionGroupId, String uniqueUserId) throws SessionStorageException {
        block16: {
            AttributeValue sessionGroupIds = (AttributeValue)AttributeValue.builder().s(sessionGroupId).build();
            HashMap<String, AttributeValue> userIdItems = new HashMap<String, AttributeValue>();
            userIdItems.put(USER_ID_ATTRIBUTE_NAME, (AttributeValue)AttributeValue.builder().s(uniqueUserId).build());
            userIdItems.put(SESSION_GROUP_ID_ATTRIBUTE_NAME, sessionGroupIds);
            try {
                GetItemResponse response;
                try (DSEventTimer ignored = this.getEventTimer("update");){
                    GetItemRequest getItemRequest = (GetItemRequest)GetItemRequest.builder().tableName(this.sessionGroupTableName).key(SessionStorageManagerDynamoDBImpl.getSessionGroupTableKeyEntry(sessionGroupId)).attributesToGet(new String[]{EXPIRY_TIME_ATTRIBUTE_NAME}).build();
                    response = this.getDynamoDBClientInstance().getItem(getItemRequest);
                }
                if (response.hasItem() && !response.item().isEmpty()) {
                    userIdItems.put(EXPIRY_TIME_ATTRIBUTE_NAME, (AttributeValue)response.item().get(EXPIRY_TIME_ATTRIBUTE_NAME));
                    PutItemRequest putRequest = (PutItemRequest)PutItemRequest.builder().tableName(this.userIdTableName).item(userIdItems).build();
                    try (DSEventTimer ignored = this.getEventTimer("put");){
                        this.getDynamoDBClientInstance().putItem(putRequest);
                        break block16;
                    }
                }
                throw new SessionStorageException("UserId " + uniqueUserId + " not saved. Unable to find session group with id: " + sessionGroupId);
            }
            catch (SdkClientException | DynamoDbException e) {
                throw new SessionStorageException("Error saving unique user ID", e);
            }
        }
    }

    public boolean supportsBatchCleanup() {
        return false;
    }

    public void deleteExpiredSessionGroups() throws SessionStorageException {
    }

    private DSEventTimer getEventTimer(String eventType) {
        return DSEventTimer.getDynamoDBInstance((String)eventType, (ServiceInformation)this);
    }
}

