/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key;

import com.pingidentity.pingcommons.gcp.key.GcpKmsClientWrapper;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.pathtemplate.ValidationException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.CryptoKeyName;
import com.pingidentity.sdk.key.MasterKeyEncryptor;
import com.pingidentity.sdk.key.MasterKeyEncryptorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpKmsMasterKeyEncryptor
implements MasterKeyEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(GcpKmsMasterKeyEncryptor.class);
    private static final String KEY_ID_ENV_VAR_NAME = "PI_GCP_MASTER_KEY_ENCRYPTOR_KEY_ID";
    private static GcpKmsClientWrapper kmsClientWrapper = new GcpKmsClientWrapper();
    private CryptoKeyName cryptoKeyName;

    public String initialize(String keyId) throws MasterKeyEncryptorException {
        String keyIdToUse = null;
        String keyIdFromEnvVar = System.getenv(KEY_ID_ENV_VAR_NAME);
        if (keyId != null) {
            logger.debug("Using system-provided key identifier.");
            keyIdToUse = keyId;
        } else if (keyIdFromEnvVar != null) {
            logger.debug("Using key identifier from environment variable.");
            keyIdToUse = keyIdFromEnvVar;
        }
        if (keyIdToUse == null) {
            throw new MasterKeyEncryptorException("Key identifier must be set");
        }
        if (keyIdFromEnvVar != null && !keyIdToUse.equals(keyIdFromEnvVar)) {
            logger.warn("Key identifier from environment variable is ignored. Using system-provided key identifier.");
        }
        try {
            this.cryptoKeyName = CryptoKeyName.parse(keyIdToUse);
        }
        catch (ValidationException e) {
            throw new MasterKeyEncryptorException("Failed to parse key identifier", (Throwable)e);
        }
        return keyIdToUse;
    }

    public byte[] encrypt(byte[] plainText) {
        return kmsClientWrapper.encrypt(this.cryptoKeyName.toString(), plainText);
    }

    public byte[] decrypt(byte[] cipherText) {
        return kmsClientWrapper.decrypt(this.cryptoKeyName.toString(), cipherText);
    }

    static void setKmsClientWrapper(GcpKmsClientWrapper kmsClientWrapper) {
        GcpKmsMasterKeyEncryptor.kmsClientWrapper = kmsClientWrapper;
    }
}

