/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.nativeimage;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.nativeimage.NativeImageUtils;
import com.pingidentity.pingcommons.gcp.key.shade.org.graalvm.nativeimage.hosted.Feature;

final class GrpcNettyFeature
implements Feature {
    private static final String GRPC_NETTY_SHADED_CLASS = "io.grpc.netty.shaded.io.grpc.netty.NettyServer";
    private static final String GOOGLE_AUTH_CLASS = "com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ServiceAccountCredentials";
    private static final String NETTY_SHADED_PACKAGE = "io.grpc.netty.shaded.io.netty.util.internal.shaded.";

    GrpcNettyFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        GrpcNettyFeature.loadGoogleAuthClasses(access);
        GrpcNettyFeature.loadGrpcNettyClasses(access);
        GrpcNettyFeature.loadMiscClasses(access);
    }

    private static void loadGoogleAuthClasses(Feature.BeforeAnalysisAccess access) {
        Class authClass = access.findClassByName(GOOGLE_AUTH_CLASS);
        if (authClass != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, GOOGLE_AUTH_CLASS);
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ServiceAccountJwtAccessCredentials");
        }
    }

    private static void loadGrpcNettyClasses(Feature.BeforeAnalysisAccess access) {
        Class nettyShadedClass = access.findClassByName(GRPC_NETTY_SHADED_CLASS);
        if (nettyShadedClass != null) {
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryUtil");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.buffer.AbstractByteBufAllocator");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf", "refCnt");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted", "refCnt");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.DefaultFileRegion");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.unix.PeerCredentials");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.DefaultChannelPipeline");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.grpc.netty.WriteBufferingAndExceptionHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.ProtocolNegotiators");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.grpc.netty.NettyClientHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.DefaultChannelPipeline$HeadContext");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.DefaultChannelPipeline$TailContext");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators$WaitUntilActiveHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators$ClientTlsHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators$GrpcNegotiationHandler");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.ChannelHandlerMask");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.Epoll");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelOption");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup");
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel");
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollSocketChannel");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.CertificateCallback");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.CertificateCallbackTask");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.SSLContext");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.SSLPrivateKeyMethodDecryptTask");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.SSLPrivateKeyMethodSignTask");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.SSLPrivateKeyMethodTask");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.internal.tcnative.SSLTask");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerIndexField", "producerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerLimitField", "producerLimit");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueConsumerIndexField", "consumerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueProducerFields", "producerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields", "producerLimit");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueConsumerFields", "consumerIndex");
        }
    }

    private static void loadMiscClasses(Feature.BeforeAnalysisAccess access) {
        NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.DescriptorProtos");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.pingidentity.pingcommons.gcp.key.shade.com.google.api.FieldBehavior");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "java.time.Instant");
        NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "javax.net.ssl.SSLContext", "contextSpi");
    }
}

