/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.httpjson;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ObsoleteApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.httpjson.AutoValue_HttpJsonCallOptions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.util.TimeConversionUtils;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.Credentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auto.value.AutoValue;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.TypeRegistry;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import com.pingidentity.pingcommons.gcp.key.shade.org.threeten.bp.Instant;
import java.time.Duration;

@AutoValue
public abstract class HttpJsonCallOptions {
    public static final HttpJsonCallOptions DEFAULT = HttpJsonCallOptions.newBuilder().build();

    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public final com.pingidentity.pingcommons.gcp.key.shade.org.threeten.bp.Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTimeoutDuration());
    }

    @Nullable
    public abstract Duration getTimeoutDuration();

    @Nullable
    @ObsoleteApi(value="Use getDeadlineInstant() instead")
    public final Instant getDeadline() {
        return TimeConversionUtils.toThreetenInstant(this.getDeadlineInstant());
    }

    @Nullable
    public abstract java.time.Instant getDeadlineInstant();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TypeRegistry getTypeRegistry();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_HttpJsonCallOptions.Builder();
    }

    public HttpJsonCallOptions merge(HttpJsonCallOptions inputOptions) {
        TypeRegistry newTypeRegistry;
        Credentials newCredentials;
        Duration newTimeout;
        if (inputOptions == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        java.time.Instant newDeadline = inputOptions.getDeadlineInstant();
        if (newDeadline != null) {
            builder.setDeadlineInstant(newDeadline);
        }
        if (inputOptions.getTimeout() != null && (newTimeout = inputOptions.getTimeoutDuration()) != null) {
            builder.setTimeoutDuration(newTimeout);
        }
        if ((newCredentials = inputOptions.getCredentials()) != null) {
            builder.setCredentials(newCredentials);
        }
        if ((newTypeRegistry = inputOptions.getTypeRegistry()) != null) {
            builder.setTypeRegistry(newTypeRegistry);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @ObsoleteApi(value="Use setTimeoutDuration(java.time.Duration) instead")
        public final Builder setTimeout(com.pingidentity.pingcommons.gcp.key.shade.org.threeten.bp.Duration value) {
            return this.setTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setTimeoutDuration(Duration var1);

        @ObsoleteApi(value="Use setDeadlineInstant(java.time.Instant) instead")
        public final Builder setDeadline(Instant value) {
            return this.setDeadlineInstant(TimeConversionUtils.toJavaTimeInstant(value));
        }

        public abstract Builder setDeadlineInstant(java.time.Instant var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTypeRegistry(TypeRegistry var1);

        public abstract HttpJsonCallOptions build();
    }
}

