/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ErrorDetails;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.StatusCode;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import java.util.Map;

public class ApiException
extends RuntimeException {
    private static final long serialVersionUID = -4375114339928877996L;
    private final ErrorDetails errorDetails;
    private final StatusCode statusCode;
    private final boolean retryable;

    public ApiException(Throwable cause, StatusCode statusCode, boolean retryable) {
        this(cause, statusCode, retryable, null);
    }

    public ApiException(String message, Throwable cause, StatusCode statusCode, boolean retryable) {
        super(message, cause);
        this.statusCode = Preconditions.checkNotNull(statusCode);
        this.retryable = retryable;
        this.errorDetails = null;
    }

    public ApiException(Throwable cause, StatusCode statusCode, boolean retryable, ErrorDetails errorDetails) {
        super(cause);
        this.statusCode = Preconditions.checkNotNull(statusCode);
        this.retryable = retryable;
        this.errorDetails = errorDetails;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getReason() {
        if (this.isErrorInfoEmpty()) {
            return null;
        }
        return this.errorDetails.getErrorInfo().getReason();
    }

    public String getDomain() {
        if (this.isErrorInfoEmpty()) {
            return null;
        }
        return this.errorDetails.getErrorInfo().getDomain();
    }

    public Map<String, String> getMetadata() {
        if (this.isErrorInfoEmpty()) {
            return null;
        }
        return this.errorDetails.getErrorInfo().getMetadataMap();
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    private boolean isErrorInfoEmpty() {
        return this.errorDetails == null || this.errorDetails.getErrorInfo() == null;
    }
}

