/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.BetaApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.pathtemplate.PathTemplate;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableMap;
import java.util.Map;

@BetaApi
public class RequestParamsBuilder {
    private final ImmutableMap.Builder<String, String> paramsBuilder = ImmutableMap.builder();

    private RequestParamsBuilder() {
    }

    public static RequestParamsBuilder create() {
        return new RequestParamsBuilder();
    }

    public void add(String fieldValue, String headerKey, PathTemplate pathTemplate) {
        if (this.checkInvalidHeaderValues(headerKey, fieldValue)) {
            return;
        }
        Map<String, String> matchedValues = pathTemplate.match(fieldValue);
        if (matchedValues != null && matchedValues.containsKey(headerKey)) {
            this.paramsBuilder.put(headerKey, matchedValues.get(headerKey));
        }
    }

    public void add(String headerKey, String fieldValue) {
        if (this.checkInvalidHeaderValues(headerKey, fieldValue)) {
            return;
        }
        this.paramsBuilder.put(headerKey, fieldValue);
    }

    private boolean checkInvalidHeaderValues(String headerKey, String fieldValue) {
        return headerKey == null || headerKey.isEmpty() || fieldValue == null || fieldValue.isEmpty();
    }

    public Map<String, String> build() {
        return this.paramsBuilder.buildKeepingLast();
    }
}

