/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFutureCallback;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing.ApiTracer;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nonnull;
import java.util.concurrent.CancellationException;

class TraceFinisher<T>
implements ApiFutureCallback<T> {
    private final ApiTracer tracer;

    TraceFinisher(@Nonnull ApiTracer tracer) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
    }

    @Override
    public void onFailure(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(throwable);
        }
    }

    @Override
    public void onSuccess(T responseT) {
        this.tracer.operationSucceeded();
    }
}

