/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFutureCallback;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFutures;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.longrunning.OperationSnapshot;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ApiCallContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.UnaryCallable;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing.ApiTracer;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing.ApiTracerFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing.SpanName;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.tracing.TracedUnaryCallable;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.util.concurrent.MoreExecutors;

public class TracedOperationInitialCallable<RequestT>
extends TracedUnaryCallable<RequestT, OperationSnapshot> {
    public TracedOperationInitialCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, ApiTracerFactory tracedFactory, SpanName spanName) {
        super(innerCallable, tracedFactory, spanName);
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(RequestT request, ApiCallContext context) {
        InitialCallableFinisher finisher = new InitialCallableFinisher(context.getTracer());
        try {
            ApiFuture<OperationSnapshot> future = super.futureCall(request, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    private static class InitialCallableFinisher
    implements ApiFutureCallback<OperationSnapshot> {
        private final ApiTracer operationTracer;

        private InitialCallableFinisher(ApiTracer operationTracer) {
            this.operationTracer = operationTracer;
        }

        @Override
        public void onSuccess(OperationSnapshot result) {
            this.operationTracer.lroStartSucceeded();
        }

        @Override
        public void onFailure(Throwable t2) {
            this.operationTracer.lroStartFailed(t2);
        }
    }
}

