/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.GenericJson;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.JsonFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.JsonObjectParser;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.util.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.http.HttpTransportFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.AccessToken;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.DefaultCredentialsProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ExternalAccountAuthorizedUserCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ExternalAccountCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.GdchCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ImpersonatedCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.OAuth2Credentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.OAuth2Utils;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.QuotaProjectIdProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.ServiceAccountCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.UserCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.MoreObjects;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableList;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GoogleCredentials
extends OAuth2Credentials
implements QuotaProjectIdProvider {
    private static final long serialVersionUID = -1522852442442473691L;
    static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    static final String USER_FILE_TYPE = "authorized_user";
    static final String SERVICE_ACCOUNT_FILE_TYPE = "service_account";
    static final String GDCH_SERVICE_ACCOUNT_FILE_TYPE = "gdch_service_account";
    private final String universeDomain;
    private final boolean isExplicitUniverseDomain;
    protected final String quotaProjectId;
    private static final DefaultCredentialsProvider defaultCredentialsProvider = new DefaultCredentialsProvider();

    public static GoogleCredentials create(AccessToken accessToken) {
        return GoogleCredentials.newBuilder().setAccessToken(accessToken).build();
    }

    public static GoogleCredentials create(String universeDomain, AccessToken accessToken) {
        return GoogleCredentials.newBuilder().setAccessToken(accessToken).setUniverseDomain(universeDomain).build();
    }

    public static GoogleCredentials getApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault(OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials getApplicationDefault(HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(transportFactory);
        return defaultCredentialsProvider.getDefaultCredentials(transportFactory);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream) throws IOException {
        return GoogleCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        Preconditions.checkNotNull(transportFactory);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get("type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if (USER_FILE_TYPE.equals(fileType)) {
            return UserCredentials.fromJson(fileContents, transportFactory);
        }
        if (SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return ServiceAccountCredentials.fromJson(fileContents, transportFactory);
        }
        if (GDCH_SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return GdchCredentials.fromJson(fileContents);
        }
        if ("external_account".equals(fileType)) {
            return ExternalAccountCredentials.fromJson(fileContents, transportFactory);
        }
        if ("external_account_authorized_user".equals(fileType)) {
            return ExternalAccountAuthorizedUserCredentials.fromJson(fileContents, transportFactory);
        }
        if ("impersonated_service_account".equals(fileType)) {
            return ImpersonatedCredentials.fromJson(fileContents, transportFactory);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Valid values are '%s', '%s', '%s', '%s', '%s', '%s'.", fileType, USER_FILE_TYPE, SERVICE_ACCOUNT_FILE_TYPE, GDCH_SERVICE_ACCOUNT_FILE_TYPE, "external_account", "external_account_authorized_user", "impersonated_service_account"));
    }

    public GoogleCredentials createWithQuotaProject(String quotaProject) {
        return this.toBuilder().setQuotaProjectId(quotaProject).build();
    }

    @Override
    public String getUniverseDomain() throws IOException {
        return this.universeDomain;
    }

    @VisibleForTesting
    protected boolean isExplicitUniverseDomain() {
        return this.isExplicitUniverseDomain;
    }

    boolean isDefaultUniverseDomain() throws IOException {
        return this.getUniverseDomain().equals("googleapis.com");
    }

    static Map<String, List<String>> addQuotaProjectIdToRequestMetadata(String quotaProjectId, Map<String, List<String>> requestMetadata) {
        Preconditions.checkNotNull(requestMetadata);
        HashMap<String, List<String>> newRequestMetadata = new HashMap<String, List<String>>(requestMetadata);
        if (quotaProjectId != null && !requestMetadata.containsKey(QUOTA_PROJECT_ID_HEADER_KEY)) {
            newRequestMetadata.put(QUOTA_PROJECT_ID_HEADER_KEY, Collections.singletonList(quotaProjectId));
        }
        return Collections.unmodifiableMap(newRequestMetadata);
    }

    @Override
    protected Map<String, List<String>> getAdditionalHeaders() {
        Map<String, List<String>> headers = super.getAdditionalHeaders();
        String quotaProjectId = this.getQuotaProjectId();
        if (quotaProjectId != null) {
            return GoogleCredentials.addQuotaProjectIdToRequestMetadata(quotaProjectId, headers);
        }
        return headers;
    }

    protected GoogleCredentials() {
        this(new Builder());
    }

    @Deprecated
    protected GoogleCredentials(AccessToken accessToken, String quotaProjectId) {
        this(GoogleCredentials.newBuilder().setAccessToken(accessToken).setQuotaProjectId(quotaProjectId));
    }

    @Deprecated
    public GoogleCredentials(AccessToken accessToken) {
        this(accessToken, null);
    }

    protected GoogleCredentials(Builder builder) {
        super(builder.getAccessToken(), builder.getRefreshMargin(), builder.getExpirationMargin());
        this.quotaProjectId = builder.getQuotaProjectId();
        if (builder.universeDomain == null || builder.universeDomain.trim().isEmpty()) {
            this.universeDomain = "googleapis.com";
            this.isExplicitUniverseDomain = false;
        } else {
            this.universeDomain = builder.getUniverseDomain();
            this.isExplicitUniverseDomain = true;
        }
    }

    @Deprecated
    protected GoogleCredentials(AccessToken accessToken, Duration refreshMargin, Duration expirationMargin) {
        this((Builder)GoogleCredentials.newBuilder().setAccessToken(accessToken).setRefreshMargin(refreshMargin).setExpirationMargin(expirationMargin));
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("quotaProjectId", this.quotaProjectId).add("universeDomain", this.universeDomain).add("isExplicitUniverseDomain", this.isExplicitUniverseDomain);
    }

    @Override
    public String toString() {
        return this.toStringHelper().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GoogleCredentials)) {
            return false;
        }
        GoogleCredentials other = (GoogleCredentials)obj;
        return Objects.equals(this.quotaProjectId, other.quotaProjectId) && Objects.equals(this.universeDomain, other.universeDomain) && Objects.equals(this.isExplicitUniverseDomain, other.isExplicitUniverseDomain);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.quotaProjectId, this.universeDomain, this.isExplicitUniverseDomain);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    public boolean createScopedRequired() {
        return false;
    }

    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this;
    }

    public GoogleCredentials createScoped(Collection<String> scopes, Collection<String> defaultScopes) {
        return this;
    }

    public GoogleCredentials createScoped(String ... scopes) {
        return this.createScoped(ImmutableList.copyOf(scopes));
    }

    public GoogleCredentials createWithCustomRetryStrategy(boolean defaultRetriesEnabled) {
        return this;
    }

    public GoogleCredentials createDelegated(String user) {
        return this;
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        @Nullable
        protected String quotaProjectId;
        @Nullable
        protected String universeDomain;

        protected Builder() {
        }

        protected Builder(GoogleCredentials credentials) {
            super(credentials);
            this.quotaProjectId = credentials.quotaProjectId;
            if (credentials.isExplicitUniverseDomain) {
                this.universeDomain = credentials.universeDomain;
            }
        }

        protected Builder(Builder builder) {
            this.setAccessToken(builder.getAccessToken());
            this.quotaProjectId = builder.quotaProjectId;
            this.universeDomain = builder.universeDomain;
        }

        @Override
        public GoogleCredentials build() {
            return new GoogleCredentials(this);
        }

        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        public String getUniverseDomain() {
            return this.universeDomain;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setAccessToken(AccessToken token) {
            super.setAccessToken(token);
            return this;
        }
    }
}

