/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.pathtemplate.PathTemplate;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.resourcenames.ResourceName;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CryptoKeyVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;
    private final String cryptoKey;
    private final String cryptoKeyVersion;

    @Deprecated
    protected CryptoKeyVersionName() {
        this.project = null;
        this.location = null;
        this.keyRing = null;
        this.cryptoKey = null;
        this.cryptoKeyVersion = null;
    }

    private CryptoKeyVersionName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.keyRing = Preconditions.checkNotNull(builder.getKeyRing());
        this.cryptoKey = Preconditions.checkNotNull(builder.getCryptoKey());
        this.cryptoKeyVersion = Preconditions.checkNotNull(builder.getCryptoKeyVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public String getCryptoKey() {
        return this.cryptoKey;
    }

    public String getCryptoKeyVersion() {
        return this.cryptoKeyVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CryptoKeyVersionName of(String project, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) {
        return CryptoKeyVersionName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).setCryptoKeyVersion(cryptoKeyVersion).build();
    }

    public static String format(String project, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) {
        return CryptoKeyVersionName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).setCryptoKeyVersion(cryptoKeyVersion).build().toString();
    }

    public static CryptoKeyVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.validatedMatch(formattedString, "CryptoKeyVersionName.parse: formattedString not in valid format");
        return CryptoKeyVersionName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("key_ring"), matchMap.get("crypto_key"), matchMap.get("crypto_key_version"));
    }

    public static List<CryptoKeyVersionName> parseList(List<String> formattedStrings) {
        ArrayList<CryptoKeyVersionName> list = new ArrayList<CryptoKeyVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CryptoKeyVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CryptoKeyVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CryptoKeyVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CryptoKeyVersionName cryptoKeyVersionName = this;
            synchronized (cryptoKeyVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.keyRing != null) {
                        fieldMapBuilder.put("key_ring", this.keyRing);
                    }
                    if (this.cryptoKey != null) {
                        fieldMapBuilder.put("crypto_key", this.cryptoKey);
                    }
                    if (this.cryptoKeyVersion != null) {
                        fieldMapBuilder.put("crypto_key_version", this.cryptoKeyVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.instantiate("project", this.project, "location", this.location, "key_ring", this.keyRing, "crypto_key", this.cryptoKey, "crypto_key_version", this.cryptoKeyVersion);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CryptoKeyVersionName that = (CryptoKeyVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyRing, that.keyRing) && Objects.equals(this.cryptoKey, that.cryptoKey) && Objects.equals(this.cryptoKeyVersion, that.cryptoKeyVersion);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.location);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.keyRing);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.cryptoKey);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.cryptoKeyVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;
        private String cryptoKey;
        private String cryptoKeyVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getCryptoKey() {
            return this.cryptoKey;
        }

        public String getCryptoKeyVersion() {
            return this.cryptoKeyVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public Builder setCryptoKey(String cryptoKey) {
            this.cryptoKey = cryptoKey;
            return this;
        }

        public Builder setCryptoKeyVersion(String cryptoKeyVersion) {
            this.cryptoKeyVersion = cryptoKeyVersion;
            return this;
        }

        private Builder(CryptoKeyVersionName cryptoKeyVersionName) {
            this.project = cryptoKeyVersionName.project;
            this.location = cryptoKeyVersionName.location;
            this.keyRing = cryptoKeyVersionName.keyRing;
            this.cryptoKey = cryptoKeyVersionName.cryptoKey;
            this.cryptoKeyVersion = cryptoKeyVersionName.cryptoKeyVersion;
        }

        public CryptoKeyVersionName build() {
            return new CryptoKeyVersionName(this);
        }
    }
}

