/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.pathtemplate.PathTemplate;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.resourcenames.ResourceName;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyHandleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEY_HANDLE = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/keyHandles/{key_handle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyHandle;

    @Deprecated
    protected KeyHandleName() {
        this.project = null;
        this.location = null;
        this.keyHandle = null;
    }

    private KeyHandleName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.keyHandle = Preconditions.checkNotNull(builder.getKeyHandle());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyHandleName of(String project, String location, String keyHandle) {
        return KeyHandleName.newBuilder().setProject(project).setLocation(location).setKeyHandle(keyHandle).build();
    }

    public static String format(String project, String location, String keyHandle) {
        return KeyHandleName.newBuilder().setProject(project).setLocation(location).setKeyHandle(keyHandle).build().toString();
    }

    public static KeyHandleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_KEY_HANDLE.validatedMatch(formattedString, "KeyHandleName.parse: formattedString not in valid format");
        return KeyHandleName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("key_handle"));
    }

    public static List<KeyHandleName> parseList(List<String> formattedStrings) {
        ArrayList<KeyHandleName> list = new ArrayList<KeyHandleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyHandleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyHandleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyHandleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_HANDLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyHandleName keyHandleName = this;
            synchronized (keyHandleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.keyHandle != null) {
                        fieldMapBuilder.put("key_handle", this.keyHandle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_HANDLE.instantiate("project", this.project, "location", this.location, "key_handle", this.keyHandle);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeyHandleName that = (KeyHandleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyHandle, that.keyHandle);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.location);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.keyHandle);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyHandle;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyHandle() {
            return this.keyHandle;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyHandle(String keyHandle) {
            this.keyHandle = keyHandle;
            return this;
        }

        private Builder(KeyHandleName keyHandleName) {
            this.project = keyHandleName.project;
            this.location = keyHandleName.location;
            this.keyHandle = keyHandleName.keyHandle;
        }

        public KeyHandleName build() {
            return new KeyHandleName(this);
        }
    }
}

