/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFunction;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.BetaApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ObsoleteApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.core.GaxProperties;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.core.GoogleCredentialsProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.GaxGrpcProperties;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.GrpcTransportChannel;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.ProtoOperationTransformers;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.RetrySettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ApiCallContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ClientContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.OperationCallSettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.PageContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.PagedCallSettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.PagedListDescriptor;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.PagedListResponseFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.StatusCode;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.StubSettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.TransportChannelProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.UnaryCallSettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.UnaryCallable;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.AutokeyClient;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.CreateKeyHandleMetadata;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.CreateKeyHandleRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.GetKeyHandleRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.KeyHandle;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.ListKeyHandlesRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.ListKeyHandlesResponse;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub.AutokeyStub;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub.GrpcAutokeyStub;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub.HttpJsonAutokeyStub;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.location.GetLocationRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.location.ListLocationsRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.location.ListLocationsResponse;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.location.Location;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableList;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableMap;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableSet;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.Lists;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.iam.v1.GetIamPolicyRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.iam.v1.Policy;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.iam.v1.SetIamPolicyRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.iam.v1.TestIamPermissionsRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.iam.v1.TestIamPermissionsResponse;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.longrunning.Operation;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Set;

public class AutokeyStubSettings
extends StubSettings<AutokeyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/cloudkms")).build();
    private final UnaryCallSettings<CreateKeyHandleRequest, Operation> createKeyHandleSettings;
    private final OperationCallSettings<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationSettings;
    private final UnaryCallSettings<GetKeyHandleRequest, KeyHandle> getKeyHandleSettings;
    private final PagedCallSettings<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> LIST_KEY_HANDLES_PAGE_STR_DESC = new PagedListDescriptor<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListKeyHandlesRequest injectToken(ListKeyHandlesRequest payload, String token) {
            return ListKeyHandlesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListKeyHandlesRequest injectPageSize(ListKeyHandlesRequest payload, int pageSize) {
            return ListKeyHandlesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListKeyHandlesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListKeyHandlesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<KeyHandle> extractResources(ListKeyHandlesResponse payload) {
            return payload.getKeyHandlesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse> LIST_KEY_HANDLES_PAGE_STR_FACT = new PagedListResponseFactory<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse>(){

        @Override
        public ApiFuture<AutokeyClient.ListKeyHandlesPagedResponse> getFuturePagedResponse(UnaryCallable<ListKeyHandlesRequest, ListKeyHandlesResponse> callable, ListKeyHandlesRequest request, ApiCallContext context, ApiFuture<ListKeyHandlesResponse> futureResponse) {
            PageContext<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> pageContext = PageContext.create(callable, LIST_KEY_HANDLES_PAGE_STR_DESC, request, context);
            return AutokeyClient.ListKeyHandlesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse>(){

        @Override
        public ApiFuture<AutokeyClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext<ListLocationsRequest, ListLocationsResponse, Location> pageContext = PageContext.create(callable, LIST_LOCATIONS_PAGE_STR_DESC, request, context);
            return AutokeyClient.ListLocationsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateKeyHandleRequest, Operation> createKeyHandleSettings() {
        return this.createKeyHandleSettings;
    }

    public OperationCallSettings<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationSettings() {
        return this.createKeyHandleOperationSettings;
    }

    public UnaryCallSettings<GetKeyHandleRequest, KeyHandle> getKeyHandleSettings() {
        return this.getKeyHandleSettings;
    }

    public PagedCallSettings<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesSettings() {
        return this.listKeyHandlesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AutokeyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAutokeyStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAutokeyStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "cloudkms";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudkms.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudkms.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AutokeyStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutokeyStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutokeyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AutokeyStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AutokeyStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.createKeyHandleSettings = settingsBuilder.createKeyHandleSettings().build();
        this.createKeyHandleOperationSettings = settingsBuilder.createKeyHandleOperationSettings().build();
        this.getKeyHandleSettings = settingsBuilder.getKeyHandleSettings().build();
        this.listKeyHandlesSettings = settingsBuilder.listKeyHandlesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AutokeyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateKeyHandleRequest, Operation> createKeyHandleSettings;
        private final OperationCallSettings.Builder<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationSettings;
        private final UnaryCallSettings.Builder<GetKeyHandleRequest, KeyHandle> getKeyHandleSettings;
        private final PagedCallSettings.Builder<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createKeyHandleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKeyHandleOperationSettings = OperationCallSettings.newBuilder();
            this.getKeyHandleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listKeyHandlesSettings = PagedCallSettings.newBuilder(LIST_KEY_HANDLES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder(LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createKeyHandleSettings, this.getKeyHandleSettings, this.listKeyHandlesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AutokeyStubSettings settings) {
            super(settings);
            this.createKeyHandleSettings = settings.createKeyHandleSettings.toBuilder();
            this.createKeyHandleOperationSettings = settings.createKeyHandleOperationSettings.toBuilder();
            this.getKeyHandleSettings = settings.getKeyHandleSettings.toBuilder();
            this.listKeyHandlesSettings = settings.listKeyHandlesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createKeyHandleSettings, this.getKeyHandleSettings, this.listKeyHandlesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutokeyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(AutokeyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(AutokeyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AutokeyStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutokeyStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider(AutokeyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(AutokeyStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AutokeyStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createKeyHandleSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_0_params"));
            builder.getKeyHandleSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            ((PagedCallSettings.Builder)builder.listKeyHandlesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            ((PagedCallSettings.Builder)builder.listLocationsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.createKeyHandleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_0_params")).build()).setResponseTransformer(ProtoOperationTransformers.ResponseTransformer.create(KeyHandle.class)).setMetadataTransformer(ProtoOperationTransformers.MetadataTransformer.create(CreateKeyHandleMetadata.class)).setPollingAlgorithm(OperationTimedPollAlgorithm.create(RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateKeyHandleRequest, Operation> createKeyHandleSettings() {
            return this.createKeyHandleSettings;
        }

        public OperationCallSettings.Builder<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationSettings() {
            return this.createKeyHandleOperationSettings;
        }

        public UnaryCallSettings.Builder<GetKeyHandleRequest, KeyHandle> getKeyHandleSettings() {
            return this.getKeyHandleSettings;
        }

        public PagedCallSettings.Builder<ListKeyHandlesRequest, ListKeyHandlesResponse, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesSettings() {
            return this.listKeyHandlesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AutokeyClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public AutokeyStubSettings build() throws IOException {
            return new AutokeyStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_0_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_1_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED)));
            definitions.put("no_retry_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put("no_retry_0_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_1_params", settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put("no_retry_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

