/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Verify;
import io.grpc.alts.internal.AeadCrypter;
import io.grpc.alts.internal.AesGcmHkdfAeadCrypter;
import io.grpc.alts.internal.ChannelCrypterNetty;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.List;

final class AltsChannelCrypter
implements ChannelCrypterNetty {
    private static final int KEY_LENGTH = AesGcmHkdfAeadCrypter.getKeyLength();
    private static final int COUNTER_LENGTH = 12;
    private static final int COUNTER_OVERFLOW_LENGTH = 8;
    private static final int TAG_LENGTH = 16;
    private final AeadCrypter aeadCrypter;
    private final byte[] outCounter = new byte[12];
    private final byte[] inCounter = new byte[12];
    private final byte[] oldCounter = new byte[12];

    AltsChannelCrypter(byte[] key, boolean isClient) {
        Preconditions.checkArgument(key.length == KEY_LENGTH);
        byte[] counter = isClient ? this.inCounter : this.outCounter;
        counter[counter.length - 1] = -128;
        this.aeadCrypter = new AesGcmHkdfAeadCrypter(key);
    }

    static int getKeyLength() {
        return KEY_LENGTH;
    }

    static int getCounterLength() {
        return 12;
    }

    @Override
    public void encrypt(ByteBuf outBuf, List<ByteBuf> plainBufs) throws GeneralSecurityException {
        Preconditions.checkArgument(outBuf.nioBufferCount() == 1);
        ByteBuf plainBuf = outBuf.slice(outBuf.writerIndex(), outBuf.writableBytes());
        plainBuf.writerIndex(0);
        for (ByteBuf inBuf : plainBufs) {
            plainBuf.writeBytes(inBuf);
        }
        Verify.verify(outBuf.writableBytes() == plainBuf.readableBytes() + 16);
        ByteBuffer out = outBuf.internalNioBuffer(outBuf.writerIndex(), outBuf.writableBytes());
        ByteBuffer plain = out.duplicate();
        plain.limit(out.limit() - 16);
        byte[] counter = this.incrementOutCounter();
        int outPosition = out.position();
        this.aeadCrypter.encrypt(out, plain, counter);
        int bytesWritten = out.position() - outPosition;
        outBuf.writerIndex(outBuf.writerIndex() + bytesWritten);
        Verify.verify(!outBuf.isWritable());
    }

    @Override
    public void decrypt(ByteBuf out, ByteBuf tag, List<ByteBuf> ciphertextBufs) throws GeneralSecurityException {
        ByteBuf cipherTextAndTag = out.slice(out.writerIndex(), out.writableBytes());
        cipherTextAndTag.writerIndex(0);
        for (ByteBuf inBuf : ciphertextBufs) {
            cipherTextAndTag.writeBytes(inBuf);
        }
        cipherTextAndTag.writeBytes(tag);
        this.decrypt(out, cipherTextAndTag);
    }

    @Override
    public void decrypt(ByteBuf out, ByteBuf ciphertextAndTag) throws GeneralSecurityException {
        int bytesRead = ciphertextAndTag.readableBytes();
        Preconditions.checkArgument(bytesRead == out.writableBytes());
        Preconditions.checkArgument(out.nioBufferCount() == 1);
        ByteBuffer outBuffer = out.internalNioBuffer(out.writerIndex(), out.writableBytes());
        Preconditions.checkArgument(ciphertextAndTag.nioBufferCount() == 1);
        ByteBuffer ciphertextAndTagBuffer = ciphertextAndTag.nioBuffer(ciphertextAndTag.readerIndex(), bytesRead);
        byte[] counter = this.incrementInCounter();
        int outPosition = outBuffer.position();
        this.aeadCrypter.decrypt(outBuffer, ciphertextAndTagBuffer, counter);
        int bytesWritten = outBuffer.position() - outPosition;
        out.writerIndex(out.writerIndex() + bytesWritten);
        ciphertextAndTag.readerIndex(out.readerIndex() + bytesRead);
        Verify.verify(out.writableBytes() == 16);
    }

    @Override
    public int getSuffixLength() {
        return 16;
    }

    @Override
    public void destroy() {
    }

    static void incrementCounter(byte[] counter, byte[] oldCounter) throws GeneralSecurityException {
        int i;
        System.arraycopy(counter, 0, oldCounter, 0, counter.length);
        for (i = 0; i < 8; ++i) {
            int n = i;
            counter[n] = (byte)(counter[n] + 1);
            if (counter[i] != 0) break;
        }
        if (i == 8) {
            System.arraycopy(oldCounter, 0, counter, 0, counter.length);
            throw new GeneralSecurityException("Counter has overflowed.");
        }
    }

    private byte[] incrementInCounter() throws GeneralSecurityException {
        AltsChannelCrypter.incrementCounter(this.inCounter, this.oldCounter);
        return this.oldCounter;
    }

    private byte[] incrementOutCounter() throws GeneralSecurityException {
        AltsChannelCrypter.incrementCounter(this.outCounter, this.oldCounter);
        return this.oldCounter;
    }

    @VisibleForTesting
    void incrementInCounterForTesting(int n) throws GeneralSecurityException {
        for (int i = 0; i < n; ++i) {
            this.incrementInCounter();
        }
    }

    @VisibleForTesting
    void incrementOutCounterForTesting(int n) throws GeneralSecurityException {
        for (int i = 0; i < n; ++i) {
            this.incrementOutCounter();
        }
    }
}

