/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.concurrent.ThreadSafe;
import io.grpc.BindableService;
import io.grpc.ExperimentalApi;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.services.ChannelzService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7929")
@ThreadSafe
public final class AdminInterface {
    private static final int DEFAULT_CHANNELZ_MAX_PAGE_SIZE = 100;
    private static final Logger logger = Logger.getLogger(AdminInterface.class.getName());

    private AdminInterface() {
    }

    public static List<ServerServiceDefinition> getStandardServices() {
        ArrayList<ServerServiceDefinition> services = new ArrayList<ServerServiceDefinition>();
        services.add(ChannelzService.newInstance(100).bindService());
        BindableService csds = null;
        try {
            Class<?> clazz = Class.forName("io.grpc.xds.CsdsService");
            Method m4 = clazz.getMethod("newInstance", new Class[0]);
            csds = (BindableService)m4.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find CSDS service", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        if (csds != null) {
            services.add(csds.bindService());
        }
        return Collections.unmodifiableList(services);
    }
}

