/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.auto.value.AutoValue;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import io.grpc.Status;
import io.grpc.xds.AutoValue_FaultConfig;
import io.grpc.xds.AutoValue_FaultConfig_FaultAbort;
import io.grpc.xds.AutoValue_FaultConfig_FaultDelay;
import io.grpc.xds.AutoValue_FaultConfig_FractionalPercent;
import io.grpc.xds.Filter;

@AutoValue
abstract class FaultConfig
implements Filter.FilterConfig {
    FaultConfig() {
    }

    @Nullable
    abstract FaultDelay faultDelay();

    @Nullable
    abstract FaultAbort faultAbort();

    @Nullable
    abstract Integer maxActiveFaults();

    @Override
    public final String typeUrl() {
        return "type.googleapis.com/envoy.extensions.filters.http.fault.v3.HTTPFault";
    }

    static FaultConfig create(@Nullable FaultDelay faultDelay, @Nullable FaultAbort faultAbort, @Nullable Integer maxActiveFaults) {
        return new AutoValue_FaultConfig(faultDelay, faultAbort, maxActiveFaults);
    }

    @AutoValue
    static abstract class FractionalPercent {
        FractionalPercent() {
        }

        abstract int numerator();

        abstract DenominatorType denominatorType();

        static FractionalPercent perHundred(int numerator) {
            return FractionalPercent.create(numerator, DenominatorType.HUNDRED);
        }

        static FractionalPercent perTenThousand(int numerator) {
            return FractionalPercent.create(numerator, DenominatorType.TEN_THOUSAND);
        }

        static FractionalPercent perMillion(int numerator) {
            return FractionalPercent.create(numerator, DenominatorType.MILLION);
        }

        static FractionalPercent create(int numerator, DenominatorType denominatorType) {
            return new AutoValue_FaultConfig_FractionalPercent(numerator, denominatorType);
        }

        static enum DenominatorType {
            HUNDRED,
            TEN_THOUSAND,
            MILLION;

        }
    }

    @AutoValue
    static abstract class FaultAbort {
        FaultAbort() {
        }

        @Nullable
        abstract Status status();

        abstract boolean headerAbort();

        abstract FractionalPercent percent();

        static FaultAbort forStatus(Status status, FractionalPercent percent) {
            Preconditions.checkNotNull(status, "status");
            return FaultAbort.create(status, false, percent);
        }

        static FaultAbort forHeader(FractionalPercent percent) {
            return FaultAbort.create(null, true, percent);
        }

        private static FaultAbort create(@Nullable Status status, boolean headerAbort, FractionalPercent percent) {
            return new AutoValue_FaultConfig_FaultAbort(status, headerAbort, percent);
        }
    }

    @AutoValue
    static abstract class FaultDelay {
        FaultDelay() {
        }

        @Nullable
        abstract Long delayNanos();

        abstract boolean headerDelay();

        abstract FractionalPercent percent();

        static FaultDelay forFixedDelay(long delayNanos, FractionalPercent percent) {
            return FaultDelay.create(delayNanos, false, percent);
        }

        static FaultDelay forHeader(FractionalPercent percentage) {
            return FaultDelay.create(null, true, percentage);
        }

        private static FaultDelay create(@Nullable Long delayNanos, boolean headerDelay, FractionalPercent percent) {
            return new AutoValue_FaultConfig_FaultDelay(delayNanos, headerDelay, percent);
        }
    }
}

