/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Joiner;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Splitter;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.net.UrlEscapers;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.util.concurrent.ListenableFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.util.concurrent.MoreExecutors;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.Any;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.LoadReportClient;
import io.grpc.xds.client.LoadStatsManager2;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.XdsResourceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10862")
public abstract class XdsClient {
    public static boolean isResourceNameValid(String resourceName, String typeUrl) {
        URI uri;
        Preconditions.checkNotNull(resourceName, "resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return true;
        }
        try {
            uri = new URI(resourceName);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String path = uri.getPath();
        Splitter slashSplitter = Splitter.on('/').omitEmptyStrings();
        if (path == null) {
            return false;
        }
        List<String> pathSegs = slashSplitter.splitToList(path);
        if (pathSegs.size() < 2) {
            return false;
        }
        String type = pathSegs.get(0);
        return type.equals(slashSplitter.splitToList(typeUrl).get(1));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10862")
    public static String canonifyResourceName(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return resourceName;
        }
        URI uri = URI.create(resourceName);
        String rawQuery = uri.getRawQuery();
        Splitter ampSplitter = Splitter.on('&').omitEmptyStrings();
        if (rawQuery == null) {
            return resourceName;
        }
        List<String> queries = ampSplitter.splitToList(rawQuery);
        if (queries.size() < 2) {
            return resourceName;
        }
        ArrayList<String> canonicalContextParams = new ArrayList<String>(queries.size());
        for (String query : queries) {
            canonicalContextParams.add(query);
        }
        Collections.sort(canonicalContextParams);
        String canonifiedQuery = Joiner.on('&').join(canonicalContextParams);
        return resourceName.replace(rawQuery, canonifiedQuery);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10862")
    public static String percentEncodePath(String input) {
        Iterable<String> pathSegs = Splitter.on('/').split(input);
        ArrayList<String> encodedSegs = new ArrayList<String>();
        for (String pathSeg : pathSegs) {
            encodedSegs.add(UrlEscapers.urlPathSegmentEscaper().escape(pathSeg));
        }
        return Joiner.on('/').join(encodedSegs);
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    public Bootstrapper.BootstrapInfo getBootstrapInfo() {
        throw new UnsupportedOperationException();
    }

    public Object getSecurityConfig() {
        throw new UnsupportedOperationException();
    }

    protected void startSubscriberTimersIfNeeded(Bootstrapper.ServerInfo serverInfo) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Map<XdsResourceType<?>, Map<String, ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        throw new UnsupportedOperationException();
    }

    public <T extends ResourceUpdate> void watchXdsResource(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public <T extends ResourceUpdate> void watchXdsResource(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher) {
        this.watchXdsResource(type, resourceName, watcher, MoreExecutors.directExecutor());
    }

    public <T extends ResourceUpdate> void cancelXdsResourceWatch(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher) {
        throw new UnsupportedOperationException();
    }

    public LoadStatsManager2.ClusterDropStats addClusterDropStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        throw new UnsupportedOperationException();
    }

    public LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        throw new UnsupportedOperationException();
    }

    public Map<Bootstrapper.ServerInfo, LoadReportClient> getServerLrsClientMap() {
        throw new UnsupportedOperationException();
    }

    public Future<Void> reportServerConnections(ServerConnectionCallback callback) {
        throw new UnsupportedOperationException();
    }

    public static interface ResourceStore {
        @Nullable
        public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo var1, XdsResourceType<? extends ResourceUpdate> var2);

        public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl();
    }

    static interface XdsResponseHandler {
        public void handleResourceResponse(XdsResourceType<?> var1, Bootstrapper.ServerInfo var2, String var3, List<Any> var4, String var5, ProcessingTracker var6);

        public void handleStreamClosed(Status var1);

        public void handleStreamRestarted(Bootstrapper.ServerInfo var1);
    }

    static final class ProcessingTracker {
        private final AtomicInteger pendingTask = new AtomicInteger(1);
        private final Executor executor;
        private final Runnable completionListener;

        ProcessingTracker(Runnable completionListener, Executor executor) {
            this.executor = executor;
            this.completionListener = completionListener;
        }

        void startTask() {
            this.pendingTask.incrementAndGet();
        }

        void onComplete() {
            if (this.pendingTask.decrementAndGet() == 0) {
                this.executor.execute(this.completionListener);
            }
        }
    }

    public static interface ServerConnectionCallback {
        public void reportServerConnectionGauge(boolean var1, String var2);
    }

    public static final class ResourceMetadata {
        private final String version;
        private final ResourceMetadataStatus status;
        private final long updateTimeNanos;
        private final boolean cached;
        @Nullable
        private final Any rawResource;
        @Nullable
        private final UpdateFailureState errorState;

        private ResourceMetadata(ResourceMetadataStatus status, String version, long updateTimeNanos, boolean cached, @Nullable Any rawResource, @Nullable UpdateFailureState errorState) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.version = Preconditions.checkNotNull(version, "version");
            this.updateTimeNanos = updateTimeNanos;
            this.cached = cached;
            this.rawResource = rawResource;
            this.errorState = errorState;
        }

        public static ResourceMetadata newResourceMetadataUnknown() {
            return new ResourceMetadata(ResourceMetadataStatus.UNKNOWN, "", 0L, false, null, null);
        }

        public static ResourceMetadata newResourceMetadataRequested() {
            return new ResourceMetadata(ResourceMetadataStatus.REQUESTED, "", 0L, false, null, null);
        }

        public static ResourceMetadata newResourceMetadataDoesNotExist() {
            return new ResourceMetadata(ResourceMetadataStatus.DOES_NOT_EXIST, "", 0L, false, null, null);
        }

        public static ResourceMetadata newResourceMetadataAcked(Any rawResource, String version, long updateTimeNanos) {
            Preconditions.checkNotNull(rawResource, "rawResource");
            return new ResourceMetadata(ResourceMetadataStatus.ACKED, version, updateTimeNanos, true, rawResource, null);
        }

        public static ResourceMetadata newResourceMetadataNacked(ResourceMetadata metadata, String failedVersion, long failedUpdateTime, String failedDetails, boolean cached) {
            Preconditions.checkNotNull(metadata, "metadata");
            return new ResourceMetadata(ResourceMetadataStatus.NACKED, metadata.getVersion(), metadata.getUpdateTimeNanos(), cached, metadata.getRawResource(), new UpdateFailureState(failedVersion, failedUpdateTime, failedDetails));
        }

        public String getVersion() {
            return this.version;
        }

        public ResourceMetadataStatus getStatus() {
            return this.status;
        }

        public long getUpdateTimeNanos() {
            return this.updateTimeNanos;
        }

        public boolean isCached() {
            return this.cached;
        }

        @Nullable
        public Any getRawResource() {
            return this.rawResource;
        }

        @Nullable
        public UpdateFailureState getErrorState() {
            return this.errorState;
        }

        public static final class UpdateFailureState {
            private final String failedVersion;
            private final long failedUpdateTimeNanos;
            private final String failedDetails;

            private UpdateFailureState(String failedVersion, long failedUpdateTimeNanos, String failedDetails) {
                this.failedVersion = Preconditions.checkNotNull(failedVersion, "failedVersion");
                this.failedUpdateTimeNanos = failedUpdateTimeNanos;
                this.failedDetails = Preconditions.checkNotNull(failedDetails, "failedDetails");
            }

            public String getFailedVersion() {
                return this.failedVersion;
            }

            public long getFailedUpdateTimeNanos() {
                return this.failedUpdateTimeNanos;
            }

            public String getFailedDetails() {
                return this.failedDetails;
            }
        }

        public static enum ResourceMetadataStatus {
            UNKNOWN,
            REQUESTED,
            DOES_NOT_EXIST,
            ACKED,
            NACKED;

        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10862")
    public static interface ResourceWatcher<T extends ResourceUpdate> {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);

        public void onChanged(T var1);
    }

    public static interface ResourceUpdate {
    }
}

