/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.concurrent.ThreadSafe;
import io.grpc.xds.internal.security.certprovider.CertificateProviderProvider;
import io.grpc.xds.internal.security.certprovider.FileWatcherCertificateProviderProvider;
import java.util.LinkedHashMap;

@ThreadSafe
public final class CertificateProviderRegistry {
    private static CertificateProviderRegistry instance;
    private final LinkedHashMap<String, CertificateProviderProvider> providers = new LinkedHashMap();

    @VisibleForTesting
    public CertificateProviderRegistry() {
    }

    public static synchronized CertificateProviderRegistry getInstance() {
        if (instance == null) {
            instance = new CertificateProviderRegistry();
            instance.register(new FileWatcherCertificateProviderProvider());
        }
        return instance;
    }

    public synchronized void register(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull(certificateProviderProvider, "certificateProviderProvider");
        this.providers.put(certificateProviderProvider.getName(), certificateProviderProvider);
    }

    public synchronized void deregister(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull(certificateProviderProvider, "certificateProviderProvider");
        this.providers.remove(certificateProviderProvider.getName());
    }

    @Nullable
    synchronized CertificateProviderProvider getProvider(String name) {
        return this.providers.get(Preconditions.checkNotNull(name, "name"));
    }
}

