/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.internal.SpiffeUtil;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProvider;
import io.grpc.xds.internal.security.trust.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FileWatcherCertificateProvider
extends CertificateProvider
implements Runnable {
    private static final Logger logger = Logger.getLogger(FileWatcherCertificateProvider.class.getName());
    private final ScheduledExecutorService scheduledExecutorService;
    private final TimeProvider timeProvider;
    private final Path certFile;
    private final Path keyFile;
    private final Path trustFile;
    private final Path spiffeTrustMapFile;
    private final long refreshIntervalInSeconds;
    @VisibleForTesting
    ScheduledFuture<?> scheduledFuture;
    private FileTime lastModifiedTimeCert;
    private FileTime lastModifiedTimeKey;
    private FileTime lastModifiedTimeRoot;
    private FileTime lastModifiedTimespiffeTrustMap;
    private boolean shutdown;

    FileWatcherCertificateProvider(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, String spiffeTrustMapFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
        super(watcher, notifyCertUpdates);
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        this.timeProvider = Preconditions.checkNotNull(timeProvider, "timeProvider");
        this.certFile = Paths.get(Preconditions.checkNotNull(certFile, "certFile"), new String[0]);
        this.keyFile = Paths.get(Preconditions.checkNotNull(keyFile, "keyFile"), new String[0]);
        Preconditions.checkArgument(trustFile != null || spiffeTrustMapFile != null, "either trustFile or spiffeTrustMapFile must be present");
        if (spiffeTrustMapFile != null) {
            this.spiffeTrustMapFile = Paths.get(spiffeTrustMapFile, new String[0]);
            this.trustFile = null;
        } else {
            this.spiffeTrustMapFile = null;
            this.trustFile = Paths.get(trustFile, new String[0]);
        }
        this.refreshIntervalInSeconds = refreshIntervalInSeconds;
    }

    @Override
    public void start() {
        this.scheduleNextRefreshCertificate(0L);
    }

    @Override
    public synchronized void close() {
        this.shutdown = true;
        this.scheduledExecutorService.shutdownNow();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.getWatcher().close();
    }

    private synchronized void scheduleNextRefreshCertificate(long delayInSeconds) {
        if (!this.shutdown) {
            this.scheduledFuture = this.scheduledExecutorService.schedule(this, delayInSeconds, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkAndReloadCertificates() {
        block27: {
            try {
                block25: {
                    try {
                        FileTime currentCertTime = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (currentCertTime.equals(this.lastModifiedTimeCert) || currentKeyTime.equals(this.lastModifiedTimeKey)) break block25;
                        byte[] certFileContents = Files.readAllBytes(this.certFile);
                        byte[] keyFileContents = Files.readAllBytes(this.keyFile);
                        FileTime currentCertTime2 = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime2 = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (!currentCertTime2.equals(currentCertTime) || !currentKeyTime2.equals(currentKeyTime)) break block25;
                        try (ByteArrayInputStream certStream = new ByteArrayInputStream(certFileContents);
                             ByteArrayInputStream keyStream = new ByteArrayInputStream(keyFileContents);){
                            PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStream);
                            X509Certificate[] certs = CertificateUtils.toX509Certificates(certStream);
                            this.getWatcher().updateCertificate(privateKey, Arrays.asList(certs));
                        }
                        this.lastModifiedTimeCert = currentCertTime;
                        this.lastModifiedTimeKey = currentKeyTime;
                    }
                    catch (Throwable t2) {
                        this.generateErrorIfCurrentCertExpired(t2);
                    }
                }
                try {
                    FileTime currentSpiffeTime;
                    if (this.spiffeTrustMapFile != null && !(currentSpiffeTime = Files.getLastModifiedTime(this.spiffeTrustMapFile, new LinkOption[0])).equals(this.lastModifiedTimespiffeTrustMap)) {
                        SpiffeUtil.SpiffeBundle trustBundle = SpiffeUtil.loadTrustBundleFromFile(this.spiffeTrustMapFile.toString());
                        this.getWatcher().updateSpiffeTrustMap(new HashMap<String, List<X509Certificate>>(trustBundle.getBundleMap()));
                        this.lastModifiedTimespiffeTrustMap = currentSpiffeTime;
                    }
                }
                catch (Throwable t3) {
                    this.getWatcher().onError(Status.fromThrowable(t3));
                }
                try {
                    FileTime currentRootTime;
                    if (this.trustFile == null || (currentRootTime = Files.getLastModifiedTime(this.trustFile, new LinkOption[0])).equals(this.lastModifiedTimeRoot)) break block27;
                    byte[] rootFileContents = Files.readAllBytes(this.trustFile);
                    FileTime currentRootTime2 = Files.getLastModifiedTime(this.trustFile, new LinkOption[0]);
                    if (!currentRootTime2.equals(currentRootTime)) break block27;
                    try (ByteArrayInputStream rootStream = new ByteArrayInputStream(rootFileContents);){
                        X509Certificate[] caCerts = CertificateUtils.toX509Certificates(rootStream);
                        this.getWatcher().updateTrustedRoots(Arrays.asList(caCerts));
                    }
                    this.lastModifiedTimeRoot = currentRootTime;
                }
                catch (Throwable t4) {
                    this.getWatcher().onError(Status.fromThrowable(t4));
                }
            }
            finally {
                this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
            }
        }
    }

    private void generateErrorIfCurrentCertExpired(Throwable t2) {
        X509Certificate currentCert = this.getWatcher().getLastIdentityCert();
        if (currentCert != null) {
            long delaySeconds = this.computeDelaySecondsToCertExpiry(currentCert);
            if (delaySeconds > this.refreshIntervalInSeconds) {
                logger.log(Level.FINER, "reload certificate error", t2);
                return;
            }
            this.getWatcher().clearValues();
        }
        this.getWatcher().onError(Status.fromThrowable(t2));
    }

    private long computeDelaySecondsToCertExpiry(X509Certificate lastCert) {
        Preconditions.checkNotNull(lastCert, "lastCert");
        return TimeUnit.NANOSECONDS.toSeconds(TimeUnit.MILLISECONDS.toNanos(lastCert.getNotAfter().getTime()) - this.timeProvider.currentTimeNanos());
    }

    @Override
    public void run() {
        block3: {
            if (!this.shutdown) {
                try {
                    this.checkAndReloadCertificates();
                }
                catch (Throwable t2) {
                    logger.log(Level.SEVERE, "Uncaught exception!", t2);
                    if (!(t2 instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, String spiffeTrustMapFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
                return new FileWatcherCertificateProvider(watcher, notifyCertUpdates, certFile, keyFile, trustFile, spiffeTrustMapFile, refreshIntervalInSeconds, scheduledExecutorService, timeProvider);
            }
        };

        Factory() {
        }

        static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher var1, boolean var2, String var3, String var4, String var5, String var6, long var7, ScheduledExecutorService var9, TimeProvider var10);
    }
}

